/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapPartition;
import com.oracle.svm.core.genscavenge.FillerObjectDummyPartition;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.image.ImageHeapPartition;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.code.CodeUtil;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class ObjectHeaderImpl
extends ObjectHeader {
    private static final UnsignedWord UNALIGNED_BIT = WordFactory.unsigned((int)1);
    private static final UnsignedWord REMEMBERED_SET_BIT = WordFactory.unsigned((int)2);
    private static final UnsignedWord FORWARDED_BIT = WordFactory.unsigned((int)4);
    private static final int IDHASH_STATE_SHIFT = 3;
    private static final UnsignedWord IDHASH_STATE_BITS = WordFactory.unsigned((int)24);
    private static final UnsignedWord IDHASH_STATE_UNASSIGNED = WordFactory.unsigned((int)0);
    private static final UnsignedWord IDHASH_STATE_FROM_ADDRESS = WordFactory.unsigned((int)1);
    private static final UnsignedWord IDHASH_STATE_IN_FIELD = WordFactory.unsigned((int)2);
    private final int numReservedBits;
    private final int numAlignmentBits = CodeUtil.log2((int)ConfigurationValues.getObjectLayout().getAlignment());
    private final int numReservedExtraBits;
    private final int reservedBitsMask;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    ObjectHeaderImpl() {
        int numMinimumReservedBits = 3;
        VMError.guarantee(numMinimumReservedBits <= this.numAlignmentBits, "Minimum set of reserved bits must be provided by object alignment");
        if (ObjectHeaderImpl.hasFixedIdentityHashField()) {
            this.numReservedBits = numMinimumReservedBits;
        } else {
            VMError.guarantee(ReferenceAccess.singleton().haveCompressedReferences(), "Ensures hubs (at the start of the image heap) remain addressable");
            this.numReservedBits = numMinimumReservedBits + 2;
            VMError.guarantee(this.numReservedBits <= this.numAlignmentBits || ObjectHeaderImpl.hasShift(), "With no shift, forwarding references are stored directly in the header (with 64-bit, must be) and we cannot use non-alignment header bits");
        }
        this.numReservedExtraBits = this.numReservedBits - this.numAlignmentBits;
        this.reservedBitsMask = (1 << this.numReservedBits) - 1;
    }

    @Fold
    public static ObjectHeaderImpl getObjectHeaderImpl() {
        ObjectHeaderImpl oh = HeapImpl.getObjectHeaderImpl();
        assert (oh != null);
        return oh;
    }

    @Override
    public int getReservedBitsMask() {
        return this.reservedBitsMask;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Word readHeaderFromPointer(Pointer objectPointer) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            return (Word)WordFactory.unsigned((int)objectPointer.readInt(ObjectHeaderImpl.getHubOffset()));
        }
        return (Word)objectPointer.readWord(ObjectHeaderImpl.getHubOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Word readHeaderFromObject(Object o) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            return (Word)WordFactory.unsigned((int)ObjectAccess.readInt((Object)o, (int)ObjectHeaderImpl.getHubOffset()));
        }
        return (Word)ObjectAccess.readWord((Object)o, (int)ObjectHeaderImpl.getHubOffset());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public DynamicHub readDynamicHubFromPointer(Pointer ptr) {
        Word header = this.readHeaderFromPointer(ptr);
        return this.dynamicHubFromObjectHeader(header);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public DynamicHub dynamicHubFromObjectHeader(Word header) {
        return (DynamicHub)this.extractPotentialDynamicHubFromHeader((UnsignedWord)header).toObject();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer readPotentialDynamicHubFromPointer(Pointer ptr) {
        Word potentialHeader = this.readHeaderFromPointer(ptr);
        return this.extractPotentialDynamicHubFromHeader((UnsignedWord)potentialHeader);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Pointer extractPotentialDynamicHubFromHeader(UnsignedWord header) {
        if (ReferenceAccess.singleton().haveCompressedReferences()) {
            UnsignedWord hubBits = header.unsignedShiftRight(this.numReservedBits);
            UnsignedWord baseRelativeBits = hubBits.shiftLeft(this.numAlignmentBits);
            return KnownIntrinsics.heapBase().add(baseRelativeBits);
        }
        UnsignedWord pointerBits = this.clearBits(header);
        return (Pointer)pointerBits;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Word encodeAsUnmanagedObjectHeader(DynamicHub hub) {
        return this.encodeAsObjectHeader(hub, false, false);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void initializeHeaderOfNewObject(Pointer objectPointer, Word encodedHub) {
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            ObjectHeaderImpl.dynamicAssert(encodedHub.and((Word)WordFactory.unsigned((long)-4294967296L)).isNull(), "hub can only use 32 bits");
            if (ol.hasFixedIdentityHashField()) {
                ObjectHeaderImpl.dynamicAssert(ol.getFixedIdentityHashOffset() == ObjectHeaderImpl.getHubOffset() + 4, "assumed layout to optimize initializing write");
                objectPointer.writeLong(ObjectHeaderImpl.getHubOffset(), encodedHub.rawValue(), LocationIdentity.INIT_LOCATION);
            } else {
                objectPointer.writeInt(ObjectHeaderImpl.getHubOffset(), (int)encodedHub.rawValue(), LocationIdentity.INIT_LOCATION);
            }
        } else {
            objectPointer.writeWord(ObjectHeaderImpl.getHubOffset(), (WordBase)encodedHub, LocationIdentity.INIT_LOCATION);
            if (ol.hasFixedIdentityHashField()) {
                objectPointer.writeInt(ol.getFixedIdentityHashOffset(), 0, LocationIdentity.INIT_LOCATION);
            }
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasOptionalIdentityHashField(Word header) {
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.staticAssert((!ObjectHeaderImpl.hasFixedIdentityHashField() ? 1 : 0) != 0, (String)"use only when fields are not fixed");
        } else {
            VMError.guarantee(!ObjectHeaderImpl.hasFixedIdentityHashField(), "use only when fields are not fixed");
        }
        UnsignedWord inFieldState = IDHASH_STATE_IN_FIELD.shiftLeft(3);
        return header.and(IDHASH_STATE_BITS).equal(inFieldState);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void setIdentityHashInField(Object o) {
        assert (VMOperation.isGCInProgress());
        VMError.guarantee(!ObjectHeaderImpl.hasFixedIdentityHashField());
        Word oldHeader = ObjectHeaderImpl.readHeaderFromObject(o);
        UnsignedWord inFieldState = IDHASH_STATE_IN_FIELD.shiftLeft(3);
        UnsignedWord newHeader = oldHeader.and(IDHASH_STATE_BITS.not()).or(inFieldState);
        ObjectHeaderImpl.writeHeaderToObject(o, (WordBase)newHeader);
        assert (this.hasOptionalIdentityHashField(ObjectHeaderImpl.readHeaderFromObject(o)));
    }

    @Override
    @Uninterruptible(reason="Prevent a GC interfering with the object's identity hash state.", callerMustBe=true)
    public void setIdentityHashFromAddress(Pointer ptr, Word currentHeader) {
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.staticAssert((!ObjectHeaderImpl.hasFixedIdentityHashField() ? 1 : 0) != 0, (String)"must always access field");
        } else {
            VMError.guarantee(!ObjectHeaderImpl.hasFixedIdentityHashField());
            assert (!this.hasIdentityHashFromAddress(currentHeader));
        }
        UnsignedWord fromAddressState = IDHASH_STATE_FROM_ADDRESS.shiftLeft(3);
        Word newHeader = currentHeader.and(IDHASH_STATE_BITS.not()).or(fromAddressState);
        ObjectHeaderImpl.writeHeaderToObject(ptr.toObjectNonNull(), (WordBase)newHeader);
        if (!GraalDirectives.inIntrinsic()) assert (this.hasIdentityHashFromAddress(ObjectHeaderImpl.readHeaderFromObject(ptr)));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasIdentityHashFromAddress(Word header) {
        return ObjectHeaderImpl.hasIdentityHashFromAddressInline(header);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static boolean hasIdentityHashFromAddressInline(Word header) {
        if (ObjectHeaderImpl.hasFixedIdentityHashField()) {
            return false;
        }
        UnsignedWord fromAddressState = IDHASH_STATE_FROM_ADDRESS.shiftLeft(3);
        return header.and(IDHASH_STATE_BITS).equal(fromAddressState);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void dynamicAssert(boolean condition, String msg) {
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.dynamicAssert((boolean)condition, (String)msg);
        } else assert (condition) : msg;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void writeHeaderToObject(Object o, WordBase header) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            ObjectAccess.writeInt((Object)o, (int)ObjectHeaderImpl.getHubOffset(), (int)((int)header.rawValue()));
        } else {
            ObjectAccess.writeWord((Object)o, (int)ObjectHeaderImpl.getHubOffset(), (WordBase)header);
        }
    }

    @Override
    public Word encodeAsTLABObjectHeader(DynamicHub hub) {
        return this.encodeAsObjectHeader(hub, false, false);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Word encodeAsObjectHeader(DynamicHub hub, boolean rememberedSet, boolean unaligned) {
        Word result = Word.objectToUntrackedPointer((Object)hub);
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            result = result.subtract((UnsignedWord)KnownIntrinsics.heapBase());
            result = result.shiftLeft(this.numReservedExtraBits);
        }
        if (rememberedSet) {
            result = result.or(REMEMBERED_SET_BIT);
        }
        if (unaligned) {
            result = result.or(UNALIGNED_BIT);
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnsignedWord clearBits(UnsignedWord header) {
        UnsignedWord mask = WordFactory.unsigned((int)this.reservedBitsMask);
        return header.and(mask.not());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isProducedHeapChunkZapped(UnsignedWord header) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            return header.equal(HeapParameters.getProducedHeapChunkZapInt());
        }
        return header.equal((UnsignedWord)HeapParameters.getProducedHeapChunkZapWord());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isConsumedHeapChunkZapped(UnsignedWord header) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            return header.equal(HeapParameters.getConsumedHeapChunkZapInt());
        }
        return header.equal((UnsignedWord)HeapParameters.getConsumedHeapChunkZapWord());
    }

    @Override
    public long encodeAsImageHeapObjectHeader(ImageHeapObject obj, long hubOffsetFromHeapBase) {
        long header = hubOffsetFromHeapBase << this.numReservedExtraBits;
        VMError.guarantee(header >>> this.numReservedExtraBits == hubOffsetFromHeapBase, "Hub is too far from heap base for encoding in object header");
        assert ((header & (long)this.reservedBitsMask) == 0L) : "Object header bits must be zero initially";
        if (HeapImpl.usesImageHeapCardMarking()) {
            ImageHeapPartition imageHeapPartition = obj.getPartition();
            if (imageHeapPartition instanceof ChunkedImageHeapPartition) {
                ChunkedImageHeapPartition partition = (ChunkedImageHeapPartition)imageHeapPartition;
                if (partition.isWritable()) {
                    header |= REMEMBERED_SET_BIT.rawValue();
                }
                if (partition.usesUnalignedObjects()) {
                    header |= UNALIGNED_BIT.rawValue();
                }
            } else assert (obj.getPartition() instanceof FillerObjectDummyPartition);
        }
        if (!ObjectHeaderImpl.hasFixedIdentityHashField()) {
            header |= IDHASH_STATE_IN_FIELD.rawValue() << 3;
        }
        return header;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isAlignedObject(Object o) {
        return !ObjectHeaderImpl.isUnalignedObject(o);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isAlignedHeader(UnsignedWord header) {
        return !ObjectHeaderImpl.isUnalignedHeader(header);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isUnalignedObject(Object obj) {
        Word header = ObjectHeaderImpl.readHeaderFromObject(obj);
        return ObjectHeaderImpl.isUnalignedHeader((UnsignedWord)header);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isUnalignedHeader(UnsignedWord header) {
        return header.and(UNALIGNED_BIT).notEqual(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setRememberedSetBit(Object o) {
        Word oldHeader = ObjectHeaderImpl.readHeaderFromObject(o);
        UnsignedWord newHeader = oldHeader.or(REMEMBERED_SET_BIT);
        ObjectHeaderImpl.writeHeaderToObject(o, (WordBase)newHeader);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static long setRememberedSetBit(long headerBytes) {
        return headerBytes | REMEMBERED_SET_BIT.rawValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean hasRememberedSet(UnsignedWord header) {
        return header.and(REMEMBERED_SET_BIT).notEqual(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isPointerToForwardedObject(Pointer p) {
        Word header = this.readHeaderFromPointer(p);
        return ObjectHeaderImpl.isForwardedHeader((UnsignedWord)header);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isForwardedHeader(UnsignedWord header) {
        return header.and(FORWARDED_BIT).notEqual(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Object getForwardedObject(Pointer ptr, UnsignedWord header) {
        assert (ObjectHeaderImpl.isForwardedHeader(header));
        if (ReferenceAccess.singleton().haveCompressedReferences()) {
            if (ObjectHeaderImpl.hasShift()) {
                ObjectLayout layout = ConfigurationValues.getObjectLayout();
                assert (layout.isAligned(ObjectHeaderImpl.getHubOffset()) && 2 * ObjectHeaderImpl.getReferenceSize() <= layout.getAlignment()) : "Forwarding reference must fit after hub";
                int forwardRefOffset = ObjectHeaderImpl.getHubOffset() + ObjectHeaderImpl.getReferenceSize();
                return ReferenceAccess.singleton().readObjectAt(ptr.add(forwardRefOffset), true);
            }
            return ReferenceAccess.singleton().uncompressReference(this.clearBits(header));
        }
        return ((Pointer)this.clearBits(header)).toObject();
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void installForwardingPointer(Object original, Object copy) {
        assert (!this.isPointerToForwardedObject((Pointer)Word.objectToUntrackedPointer((Object)original)));
        UnsignedWord forwardHeader = this.getForwardHeader(copy);
        ObjectAccess.writeLong((Object)original, (int)ObjectHeaderImpl.getHubOffset(), (long)forwardHeader.rawValue());
        assert (this.isPointerToForwardedObject((Pointer)Word.objectToUntrackedPointer((Object)original)));
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Object installForwardingPointerParallel(Object original, long eightHeaderBytes, Object copy) {
        UnsignedWord forwardHeader = this.getForwardHeader(copy);
        Word originalPtr = Word.objectToUntrackedPointer((Object)original);
        long value = originalPtr.compareAndSwapLong(ObjectHeaderImpl.getHubOffset(), eightHeaderBytes, forwardHeader.rawValue(), LocationIdentity.ANY_LOCATION);
        assert (this.isPointerToForwardedObject((Pointer)originalPtr));
        if (value != eightHeaderBytes) {
            return this.getForwardedObject((Pointer)originalPtr, WordFactory.unsigned((long)value));
        }
        return copy;
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private UnsignedWord getForwardHeader(Object copy) {
        Word result;
        if (ReferenceAccess.singleton().haveCompressedReferences()) {
            UnsignedWord compressedCopy = ReferenceAccess.singleton().getCompressedRepresentation(copy);
            result = ObjectHeaderImpl.hasShift() ? compressedCopy.shiftLeft(32).or(WordFactory.unsigned((long)0xE0E0E0E0L)) : compressedCopy;
        } else {
            result = Word.objectToUntrackedPointer((Object)copy);
        }
        assert (this.getHeaderBitsFromHeader((UnsignedWord)result).equal(0));
        return result.or(FORWARDED_BIT);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private UnsignedWord getHeaderBitsFromHeader(UnsignedWord header) {
        assert (!ObjectHeaderImpl.isProducedHeapChunkZapped(header)) : "Produced chunk zap value";
        assert (!ObjectHeaderImpl.isConsumedHeapChunkZapped(header)) : "Consumed chunk zap value";
        return header.and(this.reservedBitsMask);
    }

    @Fold
    static boolean hasShift() {
        return ReferenceAccess.singleton().getCompressEncoding().hasShift();
    }

    @Fold
    static int getHubOffset() {
        return ConfigurationValues.getObjectLayout().getHubOffset();
    }

    @Fold
    static int getReferenceSize() {
        return ConfigurationValues.getObjectLayout().getReferenceSize();
    }

    @Fold
    static boolean hasFixedIdentityHashField() {
        return ConfigurationValues.getObjectLayout().hasFixedIdentityHashField();
    }
}

