/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.parallel;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.parallel.ParallelGC;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class ChunkQueue {
    private static final int INITIAL_SIZE = 1024 * ChunkQueue.wordSize();
    private Pointer buffer;
    private int size;
    private int top;

    @Fold
    static int wordSize() {
        return ConfigurationValues.getTarget().wordSize;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    ChunkQueue() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void initialize() {
        assert (this.top == 0 && this.size == 0 && this.buffer.isNull());
        this.top = 0;
        this.size = INITIAL_SIZE;
        this.buffer = (Pointer)((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).malloc(WordFactory.unsigned((int)this.size));
        VMError.guarantee(this.buffer.isNonNull(), "Failed to allocate native memory for the ChunkBuffer.");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void push(Pointer ptr) {
        assert (!ParallelGC.singleton().isInParallelPhase() && VMThreads.ownsThreadMutex() || ParallelGC.singleton().isInParallelPhase() && ParallelGC.singleton().getMutex().isOwner(true));
        assert (ptr.isNonNull());
        if (this.top >= this.size) {
            this.size *= 2;
            assert (this.top < this.size);
            this.buffer = (Pointer)((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).realloc((PointerBase)this.buffer, WordFactory.unsigned((int)this.size));
            VMError.guarantee(this.buffer.isNonNull(), "Failed to allocate native memory for the ChunkBuffer.");
        }
        this.buffer.writeWord(this.top, (WordBase)ptr);
        this.top += ChunkQueue.wordSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Pointer pop() {
        assert (ParallelGC.singleton().isInParallelPhase() && ParallelGC.singleton().getMutex().isOwner(true));
        if (this.top > 0) {
            this.top -= ChunkQueue.wordSize();
            return (Pointer)this.buffer.readWord(this.top);
        }
        return (Pointer)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isEmpty() {
        assert (!ParallelGC.singleton().isInParallelPhase());
        return this.top == 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void teardown() {
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)this.buffer);
        this.buffer = (Pointer)WordFactory.nullPointer();
        this.size = 0;
        this.top = 0;
    }
}

