/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.parallel;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.genscavenge.parallel.ParallelGC;
import com.oracle.svm.core.option.SubstrateOptionKey;
import com.oracle.svm.core.util.UserError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@Platforms(value={Platform.HOSTED_ONLY.class})
@AutomaticallyRegisteredFeature
class ParallelGCFeature
implements InternalFeature {
    ParallelGCFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ParallelGC.isEnabled();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ParallelGCFeature.verifyOptionEnabled(SubstrateOptions.SpawnIsolates);
        ImageSingletons.add(ParallelGC.class, (Object)new ParallelGC());
    }

    private static void verifyOptionEnabled(SubstrateOptionKey<Boolean> option) {
        String optionMustBeEnabledFmt = "When using the parallel garbage collector ('--gc=parallel'), please note that option '%s' must be enabled.";
        UserError.guarantee(option.getValue(), optionMustBeEnabledFmt, option.getName());
    }
}

