/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.ReferenceMapIndex;
import com.oracle.svm.core.util.NonmovableByteArrayReader;
import com.oracle.svm.core.util.TypedMemoryReader;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class InstanceReferenceMapDecoder {
    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean walkOffsetsFromPointer(Pointer baseAddress, NonmovableArray<Byte> referenceMapEncoding, long referenceMapIndex, ObjectReferenceVisitor visitor, Object holderObject) {
        assert (ReferenceMapIndex.denotesValidReferenceMap(referenceMapIndex));
        assert (referenceMapEncoding.isNonNull());
        Pointer position = NonmovableByteArrayReader.pointerTo(referenceMapEncoding, referenceMapIndex);
        int entryCount = TypedMemoryReader.getS4(position);
        position = position.add(4);
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        boolean compressed = ReferenceAccess.singleton().haveCompressedReferences();
        assert (entryCount >= 0);
        UnsignedWord sizeOfEntries = WordFactory.unsigned((int)8).multiply(entryCount);
        Pointer end = position.add(sizeOfEntries);
        while (position.belowThan((UnsignedWord)end)) {
            int offset = TypedMemoryReader.getS4(position);
            position = position.add(4);
            long count = TypedMemoryReader.getU4(position);
            position = position.add(4);
            Pointer objRef = baseAddress.add(offset);
            int c = 0;
            while ((long)c < count) {
                boolean visitResult = InstanceReferenceMapDecoder.callVisitor(visitor, holderObject, compressed, objRef);
                if (!visitResult) {
                    return false;
                }
                objRef = objRef.add(referenceSize);
                ++c;
            }
        }
        return true;
    }

    @Uninterruptible(reason="Bridge between uninterruptible and potentially interruptible code.", mayBeInlined=true, calleeMustBe=false)
    private static boolean callVisitor(ObjectReferenceVisitor visitor, Object holderObject, boolean compressed, Pointer objRef) {
        return visitor.visitObjectReferenceInline(objRef, 0, compressed, holderObject);
    }
}

