/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.identityhashcode;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.identityhashcode.SubstrateIdentityHashCodeSnippets;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.VMError;
import java.util.SplittableRandom;
import jdk.internal.misc.Unsafe;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.IdentityHashCodeSnippets;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordFactory;

public final class IdentityHashCodeSupport {
    public static final LocationIdentity IDENTITY_HASHCODE_LOCATION = NamedLocationIdentity.mutable((String)"identityHashCode");
    public static final LocationIdentity IDENTITY_HASHCODE_SALT_LOCATION = NamedLocationIdentity.mutable((String)"identityHashCodeSalt");
    private static final FastThreadLocalObject<SplittableRandom> hashCodeGeneratorTL = FastThreadLocalFactory.createObject(SplittableRandom.class, "IdentityHashCodeSupport.hashCodeGeneratorTL");

    public static void ensureInitialized() {
        new SplittableRandom().nextInt();
    }

    public static IdentityHashCodeSnippets.Templates createSnippetTemplates(OptionValues options, Providers providers) {
        return SubstrateIdentityHashCodeSnippets.createTemplates(options, providers);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static int generateIdentityHashCode(Object obj) {
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        VMError.guarantee(ol.hasFixedIdentityHashField(), "Snippet must handle other cases");
        int newHashCode = IdentityHashCodeSupport.generateRandomHashCode();
        if (!Unsafe.getUnsafe().compareAndSetInt(obj, ol.getFixedIdentityHashOffset(), 0, newHashCode)) {
            newHashCode = ObjectAccess.readInt((Object)obj, (int)ol.getFixedIdentityHashOffset(), (LocationIdentity)IDENTITY_HASHCODE_LOCATION);
        }
        VMError.guarantee(newHashCode != 0, "Missing identity hash code");
        return newHashCode;
    }

    @Uninterruptible(reason="Prevent a GC interfering with the object's identity hash state.")
    public static int computeHashCodeFromAddress(Object obj) {
        long salt = Heap.getHeap().getIdentityHashSalt(obj);
        return IdentityHashCodeSupport.computeHashCodeFromAddress(Word.objectToUntrackedPointer((Object)obj), salt);
    }

    @Uninterruptible(reason="Prevent a GC interfering with the object's identity hash state.")
    public static int computeHashCodeFromAddress(Word address, long salt) {
        SignedWord salted = WordFactory.signed((long)salt).xor((SignedWord)address);
        int hash = IdentityHashCodeSupport.mix32(salted.rawValue()) >>> 1;
        return hash == 0 ? 1 : hash;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int mix32(long a) {
        long z = a;
        z = (z ^ z >>> 33) * 7109453100751455733L;
        return (int)((z ^ z >>> 28) * -3808689974395783757L >>> 32);
    }

    private static int generateRandomHashCode() {
        SplittableRandom hashCodeGenerator = hashCodeGeneratorTL.get();
        if (hashCodeGenerator == null) {
            hashCodeGenerator = new SplittableRandom();
            hashCodeGeneratorTL.set(hashCodeGenerator);
        }
        int hashCode = hashCodeGenerator.nextInt(Integer.MAX_VALUE) + 1;
        assert (hashCode != 0) : "Must not return 0 because it means 'hash code not computed yet' in the field that stores the hash code";
        assert (hashCode > 0) : "The Java HotSpot VM only returns positive numbers for the identity hash code, so we want to have the same restriction on Substrate VM in order to not surprise users";
        return hashCode;
    }
}

