/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.BootModuleLayerSupport;
import com.oracle.svm.core.jdk.resources.NativeImageResourcePath;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntry;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class Resources {
    private static final int INVALID_TIMESTAMP = -1;
    public static final char RESOURCES_INTERNAL_PATH_SEPARATOR = '/';
    private final EconomicMap<Pair<String, String>, ResourceStorageEntry> resources = ImageHeapMap.create();
    private long lastModifiedTime = -1L;

    public static Resources singleton() {
        return (Resources)ImageSingletons.lookup(Resources.class);
    }

    Resources() {
    }

    public EconomicMap<Pair<String, String>, ResourceStorageEntry> getResourceStorage() {
        return this.resources;
    }

    public Iterable<ResourceStorageEntry> resources() {
        return this.resources.getValues();
    }

    public int count() {
        return this.resources.size();
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public static String moduleName(Module module) {
        return module == null ? null : module.getName();
    }

    public static byte[] inputStreamToByteArray(InputStream is) {
        try {
            return is.readAllBytes();
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEntry(Module module, String resourceName, boolean isDirectory, byte[] data, boolean fromJar) {
        EconomicMap<Pair<String, String>, ResourceStorageEntry> resources;
        String moduleName = Resources.moduleName(module);
        EconomicMap<Pair<String, String>, ResourceStorageEntry> economicMap = resources = Resources.singleton().resources;
        synchronized (economicMap) {
            Pair key = Pair.create((Object)moduleName, (Object)resourceName);
            ResourceStorageEntry entry = (ResourceStorageEntry)resources.get((Object)key);
            if (entry == null) {
                if (Resources.singleton().lastModifiedTime == -1L) {
                    Resources.singleton().lastModifiedTime = new Date().getTime();
                }
                entry = new ResourceStorageEntry(isDirectory, fromJar);
                resources.put((Object)key, (Object)entry);
            }
            entry.getData().add(data);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerResource(String resourceName, InputStream is) {
        Resources.registerResource(null, resourceName, is, true);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerResource(String resourceName, InputStream is, boolean fromJar) {
        Resources.registerResource(null, resourceName, is, fromJar);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerResource(Module module, String resourceName, InputStream is) {
        Resources.registerResource(module, resourceName, is, true);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerResource(Module module, String resourceName, byte[] resourceContent) {
        Resources.addEntry(module, resourceName, false, resourceContent, true);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerResource(Module module, String resourceName, InputStream is, boolean fromJar) {
        Resources.addEntry(module, resourceName, false, Resources.inputStreamToByteArray(is), fromJar);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerDirectoryResource(String resourceDirName, String content) {
        Resources.registerDirectoryResource(null, resourceDirName, content, true);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerDirectoryResource(String resourceDirName, String content, boolean fromJar) {
        Resources.registerDirectoryResource(null, resourceDirName, content, fromJar);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerDirectoryResource(Module module, String resourceDirName, String content) {
        Resources.registerDirectoryResource(module, resourceDirName, content, true);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerDirectoryResource(Module module, String resourceDirName, String content, boolean fromJar) {
        Resources.addEntry(module, resourceDirName, true, content.getBytes(), fromJar);
    }

    public static String toCanonicalForm(String resourceName) {
        NativeImageResourcePath path = new NativeImageResourcePath(null, Resources.removeTrailingSlash(resourceName).getBytes(StandardCharsets.UTF_8), true);
        return new String(NativeImageResourcePath.getResolved(path));
    }

    private static boolean hasTrailingSlash(String resourceName) {
        return resourceName.endsWith("/");
    }

    private static String removeTrailingSlash(String resourceName) {
        return Resources.hasTrailingSlash(resourceName) ? resourceName.substring(0, resourceName.length() - 1) : resourceName;
    }

    private static boolean wasAlreadyInCanonicalForm(String resourceName, String canonicalResourceName) {
        return resourceName.equals(canonicalResourceName) || Resources.removeTrailingSlash(resourceName).equals(canonicalResourceName);
    }

    public static ResourceStorageEntry get(String name) {
        return Resources.get(null, name);
    }

    public static ResourceStorageEntry get(Module module, String resourceName) {
        String canonicalResourceName = Resources.toCanonicalForm(resourceName);
        String moduleName = Resources.moduleName(module);
        ResourceStorageEntry entry = (ResourceStorageEntry)Resources.singleton().resources.get((Object)Pair.create((Object)moduleName, (Object)canonicalResourceName));
        if (entry == null) {
            return null;
        }
        if (entry.isFromJar() && !Resources.wasAlreadyInCanonicalForm(resourceName, canonicalResourceName)) {
            return null;
        }
        if (!entry.isDirectory() && Resources.hasTrailingSlash(resourceName)) {
            return null;
        }
        return entry;
    }

    private static URL createURL(Module module, String resourceName, int index) {
        try {
            String refPart = index != 0 ? "#" + Integer.toString(index) : "";
            String moduleName = Resources.moduleName(module);
            return new URL("resource", moduleName, -1, "/" + resourceName + refPart);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static URL createURL(String resourceName) {
        return Resources.createURL(null, resourceName);
    }

    public static URL createURL(Module module, String resourceName) {
        if (resourceName == null) {
            return null;
        }
        Enumeration<URL> urls = Resources.createURLs(module, resourceName);
        return urls.hasMoreElements() ? urls.nextElement() : null;
    }

    public static InputStream createInputStream(String resourceName) {
        return Resources.createInputStream(null, resourceName);
    }

    public static InputStream createInputStream(Module module, String resourceName) {
        if (resourceName == null) {
            return null;
        }
        ResourceStorageEntry entry = Resources.get(module, resourceName);
        if (Resources.moduleName(module) == null && entry == null) {
            Module m;
            Iterator<Module> iterator = BootModuleLayerSupport.instance().getBootLayer().modules().iterator();
            while (iterator.hasNext() && (entry = Resources.get(m = iterator.next(), resourceName)) == null) {
            }
        }
        if (entry == null) {
            return null;
        }
        List<byte[]> data = entry.getData();
        return data.isEmpty() ? null : new ByteArrayInputStream(data.get(0));
    }

    public static Enumeration<URL> createURLs(String resourceName) {
        return Resources.createURLs(null, resourceName);
    }

    public static Enumeration<URL> createURLs(Module module, String resourceName) {
        if (resourceName == null) {
            return null;
        }
        ArrayList<URL> resourcesURLs = new ArrayList<URL>();
        String canonicalResourceName = Resources.toCanonicalForm(resourceName);
        boolean shouldAppendTrailingSlash = Resources.hasTrailingSlash(resourceName);
        if (Resources.moduleName(module) == null) {
            for (Module m : BootModuleLayerSupport.instance().getBootLayer().modules()) {
                ResourceStorageEntry entry = Resources.get(m, resourceName);
                Resources.addURLEntries(resourcesURLs, entry, m, (String)(shouldAppendTrailingSlash ? canonicalResourceName + "/" : canonicalResourceName));
            }
        }
        ResourceStorageEntry explicitEntry = Resources.get(module, resourceName);
        Resources.addURLEntries(resourcesURLs, explicitEntry, module, (String)(shouldAppendTrailingSlash ? canonicalResourceName + "/" : canonicalResourceName));
        if (resourcesURLs.isEmpty()) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(resourcesURLs);
    }

    private static void addURLEntries(List<URL> resourcesURLs, ResourceStorageEntry entry, Module module, String canonicalResourceName) {
        if (entry == null) {
            return;
        }
        int numberOfResources = entry.getData().size();
        for (int index = 0; index < numberOfResources; ++index) {
            resourcesURLs.add(Resources.createURL(module, canonicalResourceName, index));
        }
    }
}

