/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.jdk.ClassLoaderUtil;
import com.oracle.svm.core.jdk.ClassLoaderValueMapFieldValueTransformer;
import com.oracle.svm.core.jdk.JDK11OrEarlier;
import com.oracle.svm.core.jdk.JDK17OrLater;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PackageFieldTransformer;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.ResourcesHelper;
import com.oracle.svm.core.jdk.Target_java_lang_AssertionStatusDirectives;
import com.oracle.svm.core.jdk.Target_java_lang_ClassLoader_NativeLibrary;
import com.oracle.svm.core.jdk.Target_java_lang_Module;
import com.oracle.svm.core.util.VMError;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

@TargetClass(value=ClassLoader.class)
public final class Target_java_lang_ClassLoader {
    @Alias
    private Target_java_lang_ClassLoader parent;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private Vector<Class<?>> classes;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstanceWhenNotNull, declClass=ConcurrentHashMap.class)
    private ConcurrentHashMap<String, Object> parallelLockMap;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=PackageFieldTransformer.class)
    private ConcurrentHashMap<String, Package> packages;
    @Alias
    private static ClassLoader scl;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClassLoaderValueMapFieldValueTransformer.class)
    volatile ConcurrentHashMap<?, ?> classLoaderValueMap;
    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private static Set<String> loadedLibraryNames;
    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private static Map<String, Target_java_lang_ClassLoader_NativeLibrary> systemNativeLibraries;
    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private Map<String, Target_java_lang_ClassLoader_NativeLibrary> nativeLibraries;
    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private static String[] usr_paths;
    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private static String[] sys_paths;

    @Substitute
    public static ClassLoader getSystemClassLoader() {
        VMError.guarantee(scl != null);
        return scl;
    }

    @Delete
    private static native void initSystemClassLoader();

    @Substitute
    private URL getResource(String name) {
        return ResourcesHelper.nameToResourceURL(name);
    }

    @Substitute
    private Enumeration<URL> getResources(String name) {
        return ResourcesHelper.nameToResourceEnumerationURLs(name);
    }

    @Substitute
    public InputStream getResourceAsStream(String name) {
        return Resources.createInputStream(name);
    }

    @Substitute
    public static InputStream getSystemResourceAsStream(String name) {
        return Resources.createInputStream(name);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    static void loadLibrary(Class<?> fromClass, String name, boolean isAbsolute) {
        if (isAbsolute) {
            NativeLibrarySupport.singleton().loadLibraryAbsolute(new File(name));
        } else {
            NativeLibrarySupport.singleton().loadLibraryRelative(name);
        }
    }

    @Substitute
    private Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Alias
    protected native Class<?> findLoadedClass(String var1);

    @Alias
    protected native Class<?> findClass(String var1);

    @Substitute
    Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz != null) {
            return clazz;
        }
        if (!PredefinedClassesSupport.hasBytecodeClasses()) {
            throw new ClassNotFoundException(name);
        }
        if (this.parent != null) {
            try {
                clazz = this.parent.loadClass(name);
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.findClass(name);
    }

    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    native Class<?> findBootstrapClassOrNull(String var1);

    @Delete
    @TargetElement(onlyWith={JDK17OrLater.class}, name="findBootstrapClassOrNull")
    static native Class<?> findBootstrapClassOrNullJDK17OrLater(String var0);

    @Substitute
    static void checkClassLoaderPermission(ClassLoader cl, Class<?> caller) {
    }

    @Substitute
    Class<?> loadClass(Module module, String name) {
        try {
            return this.loadClass(name, false);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Substitute
    private Class<?> findLoadedClass0(String name) {
        return ClassForNameSupport.forNameOrNull(name, SubstrateUtil.cast(this, ClassLoader.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    ConcurrentHashMap<?, ?> createOrGetClassLoaderValueMap() {
        ConcurrentHashMap<Object, Object> result = this.classLoaderValueMap;
        if (result == null) {
            Target_java_lang_ClassLoader target_java_lang_ClassLoader = this;
            synchronized (target_java_lang_ClassLoader) {
                result = this.classLoaderValueMap;
                if (result == null) {
                    this.classLoaderValueMap = result = new ConcurrentHashMap();
                }
            }
        }
        return result;
    }

    @Alias
    native Stream<Package> packages();

    @Substitute
    public Target_java_lang_Module getUnnamedModule() {
        return ClassLoaderUtil.unnamedModuleReference.get();
    }

    @Substitute
    private void setDefaultAssertionStatus(boolean enabled) {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Substitute
    private void setPackageAssertionStatus(String packageName, boolean enabled) {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Substitute
    private void setClassAssertionStatus(String className, boolean enabled) {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Substitute
    private void clearAssertionStatus() {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Delete
    private native void initializeJavaAssertionMaps();

    @Delete
    private static native void registerNatives();

    @Delete
    private static native long findNative(ClassLoader var0, String var1);

    @Substitute
    Class<?> defineClass(byte[] b, int off, int len) throws ClassFormatError {
        return PredefinedClassesSupport.loadClass(SubstrateUtil.cast(this, ClassLoader.class), null, b, off, len, null);
    }

    @Substitute
    Class<?> defineClass(String name, byte[] b, int off, int len) throws ClassFormatError {
        return PredefinedClassesSupport.loadClass(SubstrateUtil.cast(this, ClassLoader.class), name, b, off, len, null);
    }

    @Substitute
    private Class<?> defineClass(String name, byte[] b, int off, int len, ProtectionDomain protectionDomain) {
        return PredefinedClassesSupport.loadClass(SubstrateUtil.cast(this, ClassLoader.class), name, b, off, len, protectionDomain);
    }

    @Substitute
    private Class<?> defineClass(String name, ByteBuffer b, ProtectionDomain protectionDomain) {
        int off;
        byte[] array;
        if (!PredefinedClassesSupport.hasBytecodeClasses()) {
            throw PredefinedClassesSupport.throwNoBytecodeClasses();
        }
        int len = b.remaining();
        if (b.hasArray()) {
            array = b.array();
            off = b.position() + b.arrayOffset();
        } else {
            array = new byte[len];
            b.get(array);
            off = 0;
        }
        return PredefinedClassesSupport.loadClass(SubstrateUtil.cast(this, ClassLoader.class), name, array, off, len, null);
    }

    @Substitute
    protected void resolveClass(Class<?> c) {
    }

    @Substitute
    private static Class<?> defineClass1(ClassLoader loader, String name, byte[] b, int off, int len, ProtectionDomain pd, String source) {
        throw VMError.unsupportedFeature("Defining classes at runtime is not supported.");
    }

    @Delete
    private static native Class<?> defineClass2(ClassLoader var0, String var1, ByteBuffer var2, int var3, int var4, ProtectionDomain var5, String var6);

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    private static Class<?> defineClass0(ClassLoader loader, Class<?> lookup, String name, byte[] b, int off, int len, ProtectionDomain pd, boolean initialize, int flags, Object classData) {
        throw VMError.unsupportedFeature("Defining hidden classes at runtime is not supported.");
    }

    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private native Class<?> findBootstrapClass(String var1);

    @Delete
    @TargetElement(onlyWith={JDK17OrLater.class}, name="findBootstrapClass")
    private static native Class<?> findBootstrapClassJDK17OrLater(String var0);

    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private static native String findBuiltinLib(String var0);

    @Delete
    private static native Target_java_lang_AssertionStatusDirectives retrieveDirectives();

    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private native Map<String, Target_java_lang_ClassLoader_NativeLibrary> nativeLibraries();

    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private static native Map<String, Target_java_lang_ClassLoader_NativeLibrary> systemNativeLibraries();

    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private static native boolean loadLibrary0(Class<?> var0, File var1);
}

