/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrMetadataTypeLibrary;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.thread.JavaThreads;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JfrEvent {
    public static final JfrEvent ThreadStart = JfrEvent.create("jdk.ThreadStart");
    public static final JfrEvent ThreadEnd = JfrEvent.create("jdk.ThreadEnd");
    public static final JfrEvent ThreadCPULoad = JfrEvent.create("jdk.ThreadCPULoad");
    public static final JfrEvent DataLoss = JfrEvent.create("jdk.DataLoss");
    public static final JfrEvent ClassLoadingStatistics = JfrEvent.create("jdk.ClassLoadingStatistics");
    public static final JfrEvent InitialEnvironmentVariable = JfrEvent.create("jdk.InitialEnvironmentVariable");
    public static final JfrEvent InitialSystemProperty = JfrEvent.create("jdk.InitialSystemProperty");
    public static final JfrEvent JavaThreadStatistics = JfrEvent.create("jdk.JavaThreadStatistics");
    public static final JfrEvent JVMInformation = JfrEvent.create("jdk.JVMInformation");
    public static final JfrEvent OSInformation = JfrEvent.create("jdk.OSInformation");
    public static final JfrEvent PhysicalMemory = JfrEvent.create("jdk.PhysicalMemory");
    public static final JfrEvent ExecutionSample = JfrEvent.create("jdk.ExecutionSample");
    public static final JfrEvent NativeMethodSample = JfrEvent.create("jdk.NativeMethodSample");
    public static final JfrEvent GarbageCollection = JfrEvent.create("jdk.GarbageCollection");
    public static final JfrEvent GCPhasePauseEvent = JfrEvent.create("jdk.GCPhasePause");
    public static final JfrEvent GCPhasePauseLevel1Event = JfrEvent.create("jdk.GCPhasePauseLevel1");
    public static final JfrEvent GCPhasePauseLevel2Event = JfrEvent.create("jdk.GCPhasePauseLevel2");
    public static final JfrEvent GCPhasePauseLevel3Event = JfrEvent.create("jdk.GCPhasePauseLevel3");
    public static final JfrEvent GCPhasePauseLevel4Event = JfrEvent.create("jdk.GCPhasePauseLevel4");
    public static final JfrEvent SafepointBegin = JfrEvent.create("jdk.SafepointBegin");
    public static final JfrEvent SafepointEnd = JfrEvent.create("jdk.SafepointEnd");
    public static final JfrEvent ExecuteVMOperation = JfrEvent.create("jdk.ExecuteVMOperation");
    public static final JfrEvent JavaMonitorEnter = JfrEvent.create("jdk.JavaMonitorEnter");
    public static final JfrEvent ThreadPark = JfrEvent.create("jdk.ThreadPark");
    public static final JfrEvent JavaMonitorWait = JfrEvent.create("jdk.JavaMonitorWait");
    public static final JfrEvent JavaMonitorInflate = JfrEvent.create("jdk.JavaMonitorInflate");
    public static final JfrEvent ObjectAllocationInNewTLAB = JfrEvent.create("jdk.ObjectAllocationInNewTLAB");
    private final long id;
    private final String name;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static JfrEvent create(String name) {
        return new JfrEvent(name);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JfrEvent(String name) {
        this.id = JfrMetadataTypeLibrary.lookupPlatformEvent(name);
        this.name = name;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getId() {
        return this.id;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getName() {
        return this.name;
    }

    @Uninterruptible(reason="Prevent races with VM operations that start/stop recording.", callerMustBe=true)
    public boolean shouldEmit() {
        return this.shouldEmit0() && !JfrThreadLocal.isThreadExcluded(JavaThreads.getCurrentThreadOrNull());
    }

    @Uninterruptible(reason="Prevent races with VM operations that start/stop recording.", callerMustBe=true)
    private boolean shouldEmit0() {
        return SubstrateJVM.get().isRecording() && SubstrateJVM.get().isEnabled(this);
    }
}

