/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.locks;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class VMMutex {
    static final UnsignedWord UNSPECIFIED_OWNER = WordFactory.unsigned((int)-1);
    private final String name;
    IsolateThread owner;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VMMutex() {
        this.name = "unspecified";
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VMMutex(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public VMMutex lock() {
        throw VMError.shouldNotReachHere("Lock cannot be used during native image generation");
    }

    @Uninterruptible(reason="Whole critical section needs to be uninterruptible.", callerMustBe=true)
    public void lockNoTransition() {
        throw VMError.shouldNotReachHere("Lock cannot be used during native image generation");
    }

    @Uninterruptible(reason="Whole critical section needs to be uninterruptible.", callerMustBe=true)
    public void lockNoTransitionUnspecifiedOwner() {
        throw VMError.shouldNotReachHere("Lock cannot be used during native image generation");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void unlock() {
        throw VMError.shouldNotReachHere("Lock cannot be used during native image generation");
    }

    @Uninterruptible(reason="Whole critical section needs to be uninterruptible.")
    public void unlockNoTransitionUnspecifiedOwner() {
        throw VMError.shouldNotReachHere("Lock cannot be used during native image generation");
    }

    @Deprecated(forRemoval=true)
    public void unlockWithoutChecks() {
        throw VMError.shouldNotReachHere("Lock cannot be used during native image generation");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final void assertIsOwner(String message) {
        assert (this.isOwner()) : message;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final void assertNotOwner(String message) {
        assert (!this.isOwner()) : message;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final void assertIsNotLocked(String message) {
        assert (this.owner.isNull()) : message;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final void guaranteeIsOwner(String message) {
        VMError.guarantee(this.isOwner(), message);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final void guaranteeNotOwner(String message) {
        VMError.guarantee(!this.isOwner(), message);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final boolean isOwner() {
        assert (CurrentIsolate.getCurrentThread().isNonNull()) : "current thread must not be null - otherwise use an unspecified owner";
        return this.owner == CurrentIsolate.getCurrentThread();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final boolean isOwner(boolean allowUnspecifiedOwner) {
        return this.owner == CurrentIsolate.getCurrentThread() || allowUnspecifiedOwner && this.hasUnspecifiedOwner();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setOwnerToCurrentThread() {
        this.assertIsNotLocked("The owner can only be set if no other thread holds the mutex.");
        assert (CurrentIsolate.getCurrentThread().isNonNull()) : "current thread must not be null - otherwise use an unspecified owner";
        this.owner = CurrentIsolate.getCurrentThread();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setOwnerToUnspecified() {
        this.assertIsNotLocked("The owner can only be set if no other thread holds the mutex.");
        this.owner = (IsolateThread)UNSPECIFIED_OWNER;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void clearCurrentThreadOwner() {
        this.assertIsOwner("Only the thread that holds the mutex can clear the owner.");
        this.owner = (IsolateThread)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void clearUnspecifiedOwner() {
        assert (this.owner == (IsolateThread)UNSPECIFIED_OWNER);
        this.owner = (IsolateThread)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasOwner() {
        return this.owner.isNonNull();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean hasUnspecifiedOwner() {
        return this.owner == (IsolateThread)UNSPECIFIED_OWNER;
    }
}

