/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.thread.Parker;
import com.oracle.svm.core.util.TimeUtils;

public abstract class ParkEvent
extends Parker {
    @Override
    protected void park(boolean isAbsolute, long time) {
        assert (time >= 0L);
        if (time == 0L) {
            this.condWait();
            return;
        }
        long remainingNanos = ParkEvent.computeRemainingNanos(isAbsolute, time);
        if (remainingNanos > 0L) {
            this.condTimedWait(remainingNanos);
        }
    }

    private static long computeRemainingNanos(boolean isAbsolute, long time) {
        if (isAbsolute) {
            return TimeUtils.millisToNanos(time - System.currentTimeMillis());
        }
        return time;
    }

    protected abstract void condWait();

    protected abstract void condTimedWait(long var1);

    public static interface ParkEventFactory
    extends Parker.ParkerFactory {
    }
}

