/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.locks.ClassInstanceReplacer;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMLockSupport;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.windows.WindowsVMCondition;
import com.oracle.svm.core.windows.WindowsVMLockSupport;
import com.oracle.svm.core.windows.WindowsVMMutex;
import com.oracle.svm.core.windows.WindowsVMSemaphore;
import com.oracle.svm.core.windows.headers.Process;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.WINDOWS.class})
final class WindowsVMLockFeature
implements InternalFeature {
    private final ClassInstanceReplacer<VMMutex, WindowsVMMutex> mutexReplacer = new ClassInstanceReplacer<VMMutex, WindowsVMMutex>(VMMutex.class){

        @Override
        protected WindowsVMMutex createReplacement(VMMutex source) {
            return new WindowsVMMutex(source.getName());
        }
    };
    private final ClassInstanceReplacer<VMCondition, WindowsVMCondition> conditionReplacer = new ClassInstanceReplacer<VMCondition, WindowsVMCondition>(VMCondition.class){

        @Override
        protected WindowsVMCondition createReplacement(VMCondition source) {
            return new WindowsVMCondition((WindowsVMMutex)WindowsVMLockFeature.this.mutexReplacer.apply(source.getMutex()));
        }
    };
    private final ClassInstanceReplacer<VMSemaphore, VMSemaphore> semaphoreReplacer = new ClassInstanceReplacer<VMSemaphore, VMSemaphore>(VMSemaphore.class){

        @Override
        protected VMSemaphore createReplacement(VMSemaphore source) {
            return new WindowsVMSemaphore();
        }
    };

    WindowsVMLockFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.MultiThreaded.getValue();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ImageSingletons.add(VMLockSupport.class, (Object)new WindowsVMLockSupport());
        access.registerObjectReplacer(this.mutexReplacer);
        access.registerObjectReplacer(this.conditionReplacer);
        access.registerObjectReplacer(this.semaphoreReplacer);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        int alignment = 8;
        ObjectLayout layout = ConfigurationValues.getObjectLayout();
        int baseOffset = layout.getArrayBaseOffset(JavaKind.Byte);
        int nextIndex = NumUtil.roundUp((int)baseOffset, (int)8) - baseOffset;
        WindowsVMMutex[] mutexes = this.mutexReplacer.getReplacements().toArray(new WindowsVMMutex[0]);
        int mutexSize = NumUtil.roundUp((int)SizeOf.get(Process.CRITICAL_SECTION.class), (int)8);
        for (WindowsVMMutex mutex : mutexes) {
            long offset = layout.getArrayElementOffset(JavaKind.Byte, nextIndex);
            assert (offset % 8L == 0L);
            mutex.structOffset = WordFactory.unsigned((long)offset);
            nextIndex += mutexSize;
        }
        WindowsVMCondition[] conditions = this.conditionReplacer.getReplacements().toArray(new WindowsVMCondition[0]);
        int conditionSize = NumUtil.roundUp((int)SizeOf.get(Process.CONDITION_VARIABLE.class), (int)8);
        for (WindowsVMCondition condition : conditions) {
            long offset = layout.getArrayElementOffset(JavaKind.Byte, nextIndex);
            assert (offset % 8L == 0L);
            condition.structOffset = WordFactory.unsigned((long)offset);
            nextIndex += conditionSize;
        }
        WindowsVMLockSupport lockSupport = WindowsVMLockSupport.singleton();
        lockSupport.mutexes = mutexes;
        lockSupport.conditions = conditions;
        lockSupport.semaphores = this.semaphoreReplacer.getReplacements().toArray(new WindowsVMSemaphore[0]);
        lockSupport.syncStructs = new byte[nextIndex];
    }
}

