/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.cenum;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.phases.CInterfaceEnumTool;
import com.oracle.svm.hosted.phases.CInterfaceInvocationPlugin;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.constant.CEnumValue;

public class CEnumCallWrapperMethod
extends CustomSubstitutionMethod {
    private final NativeLibraries nativeLibraries;

    CEnumCallWrapperMethod(NativeLibraries nativeLibraries, ResolvedJavaMethod method) {
        super(method);
        this.nativeLibraries = nativeLibraries;
    }

    @Override
    public int getModifiers() {
        return this.original.getModifiers() & 0xFFFFFEFF;
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        ValueNode returnValue;
        HostedGraphKit kit = new HostedGraphKit(debug, providers, method, purpose);
        StructuredGraph graph = kit.getGraph();
        ResolvedJavaType returnType = (ResolvedJavaType)method.getSignature().getReturnType(null);
        ValueNode arg = kit.loadArguments(method.toParameterTypes()).get(0);
        CInterfaceEnumTool tool = new CInterfaceEnumTool(providers.getMetaAccess(), providers.getSnippetReflection());
        JavaKind pushKind = CInterfaceInvocationPlugin.pushKind(method);
        if (method.getAnnotation(CEnumLookup.class) != null) {
            EnumInfo enumInfo = (EnumInfo)this.nativeLibraries.findElementInfo((AnnotatedElement)returnType);
            JavaKind parameterKind = JavaKind.Int;
            returnValue = tool.createEnumLookupInvoke(kit, returnType, enumInfo, parameterKind, arg);
        } else if (method.getAnnotation(CEnumValue.class) != null) {
            ResolvedJavaType declaringType = method.getDeclaringClass();
            EnumInfo enumInfo = (EnumInfo)this.nativeLibraries.findElementInfo((AnnotatedElement)declaringType);
            ValueNode invoke = tool.createEnumValueInvoke(kit, enumInfo, returnType.getJavaKind(), arg);
            ValueNode adapted = CInterfaceInvocationPlugin.adaptPrimitiveType(graph, invoke, invoke.stamp(NodeView.DEFAULT).getStackKind(), returnType.getJavaKind(), false);
            Stamp originalStamp = StampFactory.forKind((JavaKind)returnType.getJavaKind());
            returnValue = CInterfaceInvocationPlugin.adaptPrimitiveType(graph, adapted, returnType.getJavaKind(), originalStamp.getStackKind(), false);
        } else {
            throw VMError.shouldNotReachHere();
        }
        kit.getFrameState().push(pushKind, returnValue);
        kit.createReturn(returnValue, pushKind);
        return kit.finalizeGraph();
    }
}

