/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedSnippets;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.classinitialization.ClassInitializationOptions;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.InitKind;
import com.oracle.svm.hosted.classinitialization.ProvenSafeClassInitializationSupport;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.clinit.ClassInitializationTracking;

@AutomaticallyRegisteredFeature
public class ClassInitializationFeature
implements InternalFeature {
    private static final String NATIVE_IMAGE_CLASS_REASON = "Native Image classes are always initialized at build time";
    private ClassInitializationSupport classInitializationSupport;
    private AnalysisUniverse universe;
    private AnalysisMetaAccess metaAccess;

    public static void processClassInitializationOptions(ClassInitializationSupport initializationSupport) {
        ClassInitializationFeature.initializeNativeImagePackagesAtBuildTime(initializationSupport);
        ClassInitializationOptions.ClassInitialization.getValue().getValuesWithOrigins().forEach(entry -> {
            for (String info : ((String)entry.getLeft()).split(",")) {
                boolean noMatches = Arrays.stream(InitKind.values()).noneMatch(v -> info.endsWith(v.suffix()));
                OptionOrigin origin = (OptionOrigin)entry.getRight();
                if (noMatches) {
                    throw UserError.abort("Element in class initialization configuration must end in %s, %s, or %s. Found: %s (from %s)", InitKind.RUN_TIME.suffix(), InitKind.RERUN.suffix(), InitKind.BUILD_TIME.suffix(), info, origin);
                }
                Pair<String, InitKind> elementType = InitKind.strip(info);
                ((InitKind)((Object)((Object)elementType.getRight()))).stringConsumer(initializationSupport, origin).accept((String)elementType.getLeft());
            }
        });
    }

    private static void initializeNativeImagePackagesAtBuildTime(ClassInitializationSupport initializationSupport) {
        initializationSupport.initializeAtBuildTime("com.oracle.svm", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("com.oracle.graal", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("com.oracle.objectfile", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.collections", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.compiler", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.word", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.nativeimage", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.nativebridge", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.util", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.home", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.polyglot", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.options", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.graphio", NATIVE_IMAGE_CLASS_REASON);
        initializationSupport.initializeAtBuildTime("org.graalvm.jniutils", NATIVE_IMAGE_CLASS_REASON);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.classInitializationSupport = access.getHostVM().getClassInitializationSupport();
        this.classInitializationSupport.setUnsupportedFeatures(access.getBigBang().getUnsupportedFeatures());
        access.registerObjectReplacer(this::checkImageHeapInstance);
        this.universe = ((FeatureImpl.DuringSetupAccessImpl)a).getBigBang().getUniverse();
        this.metaAccess = ((FeatureImpl.DuringSetupAccessImpl)a).getBigBang().getMetaAccess();
    }

    private Object checkImageHeapInstance(Object obj) {
        if (obj != null && this.classInitializationSupport.shouldInitializeAtRuntime(obj.getClass())) {
            String msg = "No instances of " + obj.getClass().getTypeName() + " are allowed in the image heap as this class should be initialized at image runtime.";
            msg = msg + this.classInitializationSupport.objectInstantiationTraceMessage(obj, " To fix the issue mark " + obj.getClass().getTypeName() + " for build-time initialization with " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, obj.getClass().getTypeName(), "initialize-at-build-time") + " or use the the information from the trace to find the culprit and " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, "<culprit>", "initialize-at-run-time") + " to prevent its instantiation.\n");
            throw new UnsupportedFeatureException(msg);
        }
        return obj;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : EnsureClassInitializedSnippets.FOREIGN_CALLS) {
            access.getBigBang().addRootMethod((AnalysisMethod)descriptor.findMethod((MetaAccessProvider)access.getMetaAccess()), true);
        }
    }

    @Override
    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(EnsureClassInitializedSnippets.FOREIGN_CALLS);
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        EnsureClassInitializedSnippets.registerLowerings(options, providers, lowerings);
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        this.classInitializationSupport.checkDelayedInitialization();
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        try (Timer.StopTimer ignored = TimerCollection.createTimerAndStart((TimerCollection.Registry)TimerCollection.Registry.CLINIT);){
            List unspecifiedClasses;
            this.classInitializationSupport.setUnsupportedFeatures(null);
            assert (this.classInitializationSupport.checkDelayedInitialization());
            this.classInitializationSupport.doLateInitialization(this.universe, this.metaAccess);
            if (ClassInitializationOptions.PrintClassInitialization.getValue().booleanValue()) {
                this.reportClassInitializationInfo(SubstrateOptions.reportsPath());
            }
            if (SubstrateOptions.TraceClassInitialization.hasBeenSet()) {
                ClassInitializationFeature.reportTrackedClassInitializationTraces(SubstrateOptions.reportsPath());
            }
            if (ClassInitializationOptions.AssertInitializationSpecifiedForAllClasses.getValue().booleanValue() && !(unspecifiedClasses = this.classInitializationSupport.classesWithKind(InitKind.RUN_TIME).stream().filter(c -> this.classInitializationSupport.specifiedInitKindFor((Class<?>)c) == null).map(Class::getTypeName).collect(Collectors.toList())).isEmpty()) {
                System.err.println("The following classes have unspecified initialization policy:" + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), unspecifiedClasses));
                UserError.abort("To fix the error either specify the initialization policy for given classes or set %s", SubstrateOptionsParser.commandArgument(ClassInitializationOptions.AssertInitializationSpecifiedForAllClasses, "-"));
            }
        }
    }

    private void reportClassInitializationInfo(String path) {
        ReportUtils.report((String)"class initialization report", (String)path, (String)"class_initialization_report", (String)"csv", writer -> {
            writer.println("Class Name, Initialization Kind, Reason for Initialization");
            this.reportKind((PrintWriter)writer, InitKind.BUILD_TIME);
            this.reportKind((PrintWriter)writer, InitKind.RERUN);
            this.reportKind((PrintWriter)writer, InitKind.RUN_TIME);
        });
    }

    private void reportKind(PrintWriter writer, InitKind kind) {
        ArrayList allClasses = new ArrayList(this.classInitializationSupport.classesWithKind(kind));
        allClasses.sort(Comparator.comparing(Class::getTypeName));
        allClasses.forEach(clazz -> {
            writer.print(clazz.getTypeName() + ", ");
            writer.print(String.valueOf((Object)kind) + ", ");
            writer.println(this.classInitializationSupport.reasonForClass((Class<?>)clazz));
        });
    }

    private static void reportTrackedClassInitializationTraces(String path) {
        Map initializedClasses = ClassInitializationTracking.initializedClasses;
        int size = initializedClasses.size();
        if (size > 0) {
            ReportUtils.report((String)(size + " class initialization trace(s) of class(es) traced by " + SubstrateOptions.TraceClassInitialization.getName()), (String)path, (String)"traced_class_initialization", (String)"txt", writer -> initializedClasses.forEach((k, v) -> {
                writer.println(k.getName());
                writer.println("---------------------------------------------");
                writer.println(ProvenSafeClassInitializationSupport.getTraceString(v));
                writer.println();
            }));
        }
    }

    public void afterImageWrite(Feature.AfterImageWriteAccess a) {
        this.classInitializationSupport.checkDelayedInitialization();
    }
}

