/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.HostedDirectCallTrampolineSupport;
import com.oracle.svm.hosted.code.HostedImageHeapConstantPatch;
import com.oracle.svm.hosted.code.HostedPatcher;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.word.WordFactory;

public class LIRNativeImageCodeCache
extends NativeImageCodeCache {
    private static final byte CODE_FILLER_BYTE = -52;
    private int codeCacheSize;
    private final Map<HostedMethod, Map<HostedMethod, Integer>> trampolineMap;
    private final Map<HostedMethod, List<Pair<HostedMethod, Integer>>> orderedTrampolineMap;
    private final Map<HostedMethod, Integer> compilationPosition;
    private final TargetDescription target = ConfigurationValues.getTarget();

    public LIRNativeImageCodeCache(Map<HostedMethod, CompilationResult> compilations, NativeImageHeap imageHeap) {
        super(compilations, imageHeap);
        this.trampolineMap = new HashMap<HostedMethod, Map<HostedMethod, Integer>>();
        this.orderedTrampolineMap = new HashMap<HostedMethod, List<Pair<HostedMethod, Integer>>>();
        this.compilationPosition = new HashMap<HostedMethod, Integer>();
        int compilationPos = 0;
        for (Pair<HostedMethod, CompilationResult> entry : this.getOrderedCompilations()) {
            this.compilationPosition.put((HostedMethod)entry.getLeft(), compilationPos);
            ++compilationPos;
        }
    }

    @Override
    public int getCodeCacheSize() {
        assert (this.codeCacheSize > 0);
        return this.codeCacheSize;
    }

    @Override
    public int getCodeAreaSize() {
        return this.getCodeCacheSize();
    }

    private void setCodeCacheSize(int size) {
        assert (this.codeCacheSize == 0 && size > 0);
        this.codeCacheSize = size;
    }

    @Override
    public int codeSizeFor(HostedMethod method) {
        int methodEnd;
        int methodStart = method.getCodeAddressOffset();
        if (this.orderedTrampolineMap.containsKey(method)) {
            List<Pair<HostedMethod, Integer>> trampolineList = this.orderedTrampolineMap.get(method);
            int lastTrampolineStart = (Integer)trampolineList.get(trampolineList.size() - 1).getRight();
            methodEnd = LIRNativeImageCodeCache.computeNextMethodStart(lastTrampolineStart, HostedDirectCallTrampolineSupport.singleton().getTrampolineSize());
        } else {
            methodEnd = LIRNativeImageCodeCache.computeNextMethodStart(methodStart, this.compilationResultFor(method).getTargetCodeSize());
        }
        return methodEnd - methodStart;
    }

    private boolean verifyMethodLayout() {
        HostedDirectCallTrampolineSupport trampolineSupport = HostedDirectCallTrampolineSupport.singleton();
        int currentPos = 0;
        for (Pair<HostedMethod, CompilationResult> entry : this.getOrderedCompilations()) {
            HostedMethod method = (HostedMethod)entry.getLeft();
            CompilationResult compilation = (CompilationResult)entry.getRight();
            int methodStart = method.getCodeAddressOffset();
            assert (currentPos == methodStart);
            currentPos += compilation.getTargetCodeSize();
            if (this.orderedTrampolineMap.containsKey(method)) {
                for (Pair<HostedMethod, Integer> trampoline : this.orderedTrampolineMap.get(method)) {
                    int trampolineOffset = (Integer)trampoline.getRight();
                    currentPos = NumUtil.roundUp((int)currentPos, (int)trampolineSupport.getTrampolineAlignment());
                    assert (trampolineOffset == currentPos);
                    currentPos += trampolineSupport.getTrampolineSize();
                }
            }
            currentPos = LIRNativeImageCodeCache.computeNextMethodStart(currentPos, 0);
            int size = currentPos - method.getCodeAddressOffset();
            assert (this.codeSizeFor(method) == size);
        }
        return true;
    }

    @Override
    public void layoutMethods(DebugContext debug, BigBang bb, ForkJoinPool threadPool) {
        try (Indent indent = debug.logAndIndent("layout methods");){
            int totalSize;
            Pair<HostedMethod, CompilationResult> lastCompilation;
            HostedMethod lastMethod;
            HostedMethod method;
            HostedDirectCallTrampolineSupport trampolineSupport = HostedDirectCallTrampolineSupport.singleton();
            HashMap<HostedMethod, Integer> curOffsetMap = trampolineSupport.mayNeedTrampolines() ? new HashMap<HostedMethod, Integer>() : null;
            int curPos = 0;
            for (Pair<HostedMethod, CompilationResult> entry : this.getOrderedCompilations()) {
                method = (HostedMethod)entry.getLeft();
                CompilationResult compilation = (CompilationResult)entry.getRight();
                if (!trampolineSupport.mayNeedTrampolines()) {
                    method.setCodeAddressOffset(curPos);
                } else {
                    curOffsetMap.put(method, curPos);
                }
                curPos = LIRNativeImageCodeCache.computeNextMethodStart(curPos, compilation.getTargetCodeSize());
            }
            if (trampolineSupport.mayNeedTrampolines()) {
                this.addDirectCallTrampolines(curOffsetMap);
                for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
                    method = (HostedMethod)pair.getLeft();
                    int methodStartOffset = (Integer)curOffsetMap.get(method);
                    method.setCodeAddressOffset(methodStartOffset);
                    Map<HostedMethod, Integer> trampolines = this.trampolineMap.get(method);
                    if (trampolines.size() == 0) continue;
                    ArrayList<Pair> sortedTrampolines = new ArrayList<Pair>(trampolines.size());
                    int position = methodStartOffset + ((CompilationResult)pair.getRight()).getTargetCodeSize();
                    for (HostedMethod callTarget : trampolines.keySet().toArray(HostedMethod.EMPTY_ARRAY)) {
                        position = NumUtil.roundUp((int)position, (int)trampolineSupport.getTrampolineAlignment());
                        trampolines.put(callTarget, position);
                        sortedTrampolines.add(Pair.create((Object)callTarget, (Object)position));
                        position += trampolineSupport.getTrampolineSize();
                    }
                    this.orderedTrampolineMap.put(method, sortedTrampolines);
                }
            }
            if (this.orderedTrampolineMap.containsKey(lastMethod = (HostedMethod)(lastCompilation = this.getLastCompilation()).getLeft())) {
                List<Pair<HostedMethod, Integer>> trampolines = this.orderedTrampolineMap.get(lastMethod);
                int lastTrampolineStart = (Integer)trampolines.get(trampolines.size() - 1).getRight();
                totalSize = LIRNativeImageCodeCache.computeNextMethodStart(lastTrampolineStart, trampolineSupport.getTrampolineSize());
            } else {
                totalSize = LIRNativeImageCodeCache.computeNextMethodStart(((HostedMethod)lastCompilation.getLeft()).getCodeAddressOffset(), ((CompilationResult)lastCompilation.getRight()).getTargetCodeSize());
            }
            this.setCodeCacheSize(totalSize);
            assert (this.verifyMethodLayout());
            this.buildRuntimeMetadata(threadPool, new MethodPointer((ResolvedJavaMethod)this.getFirstCompilation().getLeft()), WordFactory.unsigned((int)totalSize));
        }
    }

    private static int computeNextMethodStart(int current, int addend) {
        int result;
        try {
            result = NumUtil.roundUp((int)Math.addExact(current, addend), (int)SubstrateOptions.codeAlignment());
        }
        catch (ArithmeticException e) {
            throw VMError.shouldNotReachHere("Code size is larger than 2GB");
        }
        return result;
    }

    private void addDirectCallTrampolines(Map<HostedMethod, Integer> curOffsetMap) {
        boolean changed;
        HostedDirectCallTrampolineSupport trampolineSupport = HostedDirectCallTrampolineSupport.singleton();
        do {
            int callerCompilationNum = 0;
            int curPos = 0;
            changed = false;
            for (Pair<HostedMethod, CompilationResult> entry : this.getOrderedCompilations()) {
                HostedMethod caller = (HostedMethod)entry.getLeft();
                CompilationResult compilation = (CompilationResult)entry.getRight();
                int originalStart = curOffsetMap.get(caller);
                int newStart = curPos;
                curOffsetMap.put(caller, newStart);
                int newEnd = curPos += compilation.getTargetCodeSize();
                Map trampolines = this.trampolineMap.computeIfAbsent(caller, k -> new HashMap());
                for (int j = 0; j < trampolines.size(); ++j) {
                    curPos = NumUtil.roundUp((int)curPos, (int)trampolineSupport.getTrampolineAlignment());
                    curPos += trampolineSupport.getTrampolineSize();
                }
                for (Infopoint infopoint : compilation.getInfopoints()) {
                    if (!(infopoint instanceof Call) || !((Call)infopoint).direct) continue;
                    Call call = (Call)infopoint;
                    HostedMethod callee = (HostedMethod)call.target;
                    if (trampolines.containsKey(callee)) continue;
                    int calleeStart = curOffsetMap.get(callee);
                    int calleeCompilationNum = this.compilationPosition.get(callee);
                    int maxDistance = calleeCompilationNum < callerCompilationNum ? newEnd - calleeStart : calleeStart - originalStart;
                    if (maxDistance <= trampolineSupport.getMaxCallDistance()) continue;
                    changed = true;
                    trampolines.put(callee, 0);
                    curPos = NumUtil.roundUp((int)curPos, (int)trampolineSupport.getTrampolineAlignment());
                    curPos += trampolineSupport.getTrampolineSize();
                }
                curPos = LIRNativeImageCodeCache.computeNextMethodStart(curPos, 0);
                ++callerCompilationNum;
            }
        } while (changed);
    }

    @Override
    public void patchMethods(DebugContext debug, RelocatableBuffer relocs, ObjectFile objectFile) {
        for (Pair<HostedMethod, CompilationResult> pair : this.getOrderedCompilations()) {
            HostedMethod method = (HostedMethod)pair.getLeft();
            CompilationResult compilation = (CompilationResult)pair.getRight();
            int compStart = method.getCodeAddressOffset();
            HashMap<Integer, HostedPatcher> patches = new HashMap<Integer, HostedPatcher>();
            ByteBuffer targetCode = null;
            for (CompilationResult.CodeAnnotation codeAnnotation : compilation.getCodeAnnotations()) {
                if (codeAnnotation instanceof HostedPatcher) {
                    HostedPatcher priorValue = patches.put(codeAnnotation.getPosition(), (HostedPatcher)codeAnnotation);
                    VMError.guarantee(priorValue == null, "Registering two patchers for same position.");
                    continue;
                }
                if (!(codeAnnotation instanceof HostedImageHeapConstantPatch)) continue;
                HostedImageHeapConstantPatch patch = (HostedImageHeapConstantPatch)codeAnnotation;
                Iterator objectInfo = this.imageHeap.getConstantInfo(patch.constant);
                long objectAddress = ((NativeImageHeap.ObjectInfo)((Object)objectInfo)).getAddress();
                if (targetCode == null) {
                    targetCode = ByteBuffer.wrap(compilation.getTargetCode()).order(this.target.arch.getByteOrder());
                }
                int originalValue = targetCode.getInt(patch.getPosition());
                long newValue = (long)originalValue + objectAddress;
                VMError.guarantee(NumUtil.isInt((long)newValue), "Image heap size is limited to 2 GByte");
                targetCode.putInt(patch.getPosition(), (int)newValue);
            }
            Map<HostedMethod, Integer> trampolineOffsetMap = this.trampolineMap.get(method);
            int patchesHandled = 0;
            HashSet<Integer> patchedOffsets = new HashSet<Integer>();
            for (Infopoint infopoint : compilation.getInfopoints()) {
                if (!(infopoint instanceof Call) || !((Call)infopoint).direct) continue;
                Call call = (Call)infopoint;
                HostedMethod callTarget = (HostedMethod)call.target;
                int callTargetStart = callTarget.getCodeAddressOffset();
                if (trampolineOffsetMap != null && trampolineOffsetMap.containsKey(callTarget)) {
                    callTargetStart = trampolineOffsetMap.get(callTarget);
                }
                int pcDisplacement = callTargetStart - (compStart + call.pcOffset);
                ((HostedPatcher)patches.get(call.pcOffset)).patch(compStart, pcDisplacement, compilation.getTargetCode());
                boolean noPriorMatch = patchedOffsets.add(call.pcOffset);
                VMError.guarantee(noPriorMatch, "Patching same offset twice.");
                ++patchesHandled;
            }
            for (DataPatch dataPatch : compilation.getDataPatches()) {
                Reference ref = dataPatch.reference;
                ((HostedPatcher)patches.get(dataPatch.pcOffset)).relocate(ref, relocs, compStart);
                boolean noPriorMatch = patchedOffsets.add(dataPatch.pcOffset);
                VMError.guarantee(noPriorMatch, "Patching same offset twice.");
                ++patchesHandled;
            }
            VMError.guarantee(patchesHandled == patches.size(), "Not all patches applied.");
            try {
                DebugContext.Scope ds = debug.scope((Object)"After Patching", (Object)method.asJavaMethod());
                try {
                    debug.dump(1, (Object)compilation, "After patching");
                }
                finally {
                    if (ds == null) continue;
                    ds.close();
                }
            }
            catch (Throwable e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
    }

    @Override
    public void writeCode(RelocatableBuffer buffer) {
        ByteBuffer bufferBytes = buffer.getByteBuffer();
        int startPos = bufferBytes.position();
        for (Pair<HostedMethod, CompilationResult> compilationPair : this.getOrderedCompilations()) {
            HostedMethod method = (HostedMethod)compilationPair.getLeft();
            CompilationResult compilation = (CompilationResult)compilationPair.getRight();
            bufferBytes.position(startPos + method.getCodeAddressOffset());
            bufferBytes.put(compilation.getTargetCode(), 0, compilation.getTargetCodeSize());
            int curPos = bufferBytes.position();
            List<Pair<HostedMethod, Integer>> trampolines = this.orderedTrampolineMap.get(method);
            if (trampolines != null) {
                HostedDirectCallTrampolineSupport trampolineSupport = HostedDirectCallTrampolineSupport.singleton();
                int trampolineSize = trampolineSupport.getTrampolineSize();
                for (Pair<HostedMethod, Integer> trampoline : trampolines) {
                    for (int i = curPos; i < NumUtil.roundUp((int)curPos, (int)trampolineSupport.getTrampolineAlignment()); ++i) {
                        bufferBytes.put((byte)-52);
                    }
                    curPos = bufferBytes.position();
                    assert (curPos == (Integer)trampoline.getRight());
                    byte[] trampolineCode = trampolineSupport.createTrampoline(this.target, (HostedMethod)trampoline.getLeft(), curPos);
                    assert (trampolineCode.length == trampolineSize);
                    bufferBytes.put(trampolineCode, 0, trampolineSize);
                    curPos += trampolineSize;
                }
            }
            for (int i = curPos; i < NumUtil.roundUp((int)curPos, (int)SubstrateOptions.codeAlignment()); ++i) {
                bufferBytes.put((byte)-52);
            }
        }
        bufferBytes.position(startPos);
    }

    @Override
    public NativeTextSectionImpl getTextSectionImpl(RelocatableBuffer buffer, ObjectFile objectFile, NativeImageCodeCache codeCache) {
        return new NativeTextSectionImpl(buffer, objectFile, codeCache);
    }

    @Override
    public List<ObjectFile.Symbol> getSymbols(ObjectFile objectFile) {
        return StreamSupport.stream(objectFile.getSymbolTable().spliterator(), false).collect(Collectors.toList());
    }

    private static final class NativeTextSectionImpl
    extends NativeImage.NativeTextSectionImpl {
        private NativeTextSectionImpl(RelocatableBuffer buffer, ObjectFile objectFile, NativeImageCodeCache codeCache) {
            super(buffer, objectFile, codeCache);
        }

        @Override
        protected void defineMethodSymbol(String name, boolean global, ObjectFile.Element section, HostedMethod method, CompilationResult result) {
            int size = result == null ? 0 : result.getTargetCodeSize();
            this.objectFile.createDefinedSymbol(name, section, (long)method.getCodeAddressOffset(), size, true, global);
        }
    }
}

