/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.jdk.jniRegistration.BaseClassMemberRegistration;
import com.oracle.svm.hosted.jdk.jniRegistration.ClassJavaAwtWindowRegistration;
import com.oracle.svm.hosted.jdk.jniRegistration.ClassSunFont2DRegistration;
import com.oracle.svm.hosted.jdk.jniRegistration.ClassSunJava2dWindowsWindowsFlags;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.desktop.UserSessionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Kernel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.plaf.synth.SynthContext;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.hotspot.SnippetSignature;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeJNIAccess;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.nativeimage.impl.RuntimeResourceSupport;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticallyRegisteredFeature
public class JNIRegistrationAwt
extends JNIRegistrationUtil
implements InternalFeature {
    private boolean isSupportedPlatform() {
        return JNIRegistrationAwt.isLinux() || JNIRegistrationAwt.isWindows() || JNIRegistrationAwt.isDarwin();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (this.isSupportedPlatform()) {
            access.registerReachabilityHandler(JNIRegistrationAwt::handlePreferencesClassReachable, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.Toolkit"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.cmm.lcms.LCMS"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.event.NativeLibLoader"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.NativeLibLoader"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.NativeLibLoader"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.image.ColorModel"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.GraphicsEnvironment"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.FontManagerNativeLibrary"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.print.PrintServiceLookup"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.Disposer")});
            if (JNIRegistrationAwt.isPosix()) {
                if (JNIRegistrationAwt.isDarwin()) {
                    PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("java_awt");
                    PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("sun_awt");
                    PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("sun_java2d");
                    PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("sun_print");
                    PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("sun_font");
                    PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("com_sun_imageio_plugins_jpeg");
                }
                access.registerReachabilityHandler(JNIRegistrationAwt::registerFreeType, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.FontManagerNativeLibrary")});
                access.registerReachabilityHandler(JNIRegistrationAwt::registerLCMS, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.cmm.lcms.LCMS")});
                access.registerReachabilityHandler(JNIRegistrationAwt::registerImagingLib, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.ImagingLib")});
                access.registerReachabilityHandler(JNIRegistrationAwt::registerJPEG, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.JPEGImageDecoder"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageReader"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageWriter")});
            }
            if (JNIRegistrationAwt.isDarwin()) {
                PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("awt_lwawt");
                PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("sun_lwawt_macosx");
                PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("apple_laf");
                PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("com_apple_eio");
                PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("com_apple_eawt");
                PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("com_apple_laf");
            }
            access.registerReachabilityHandler(JNIRegistrationAwt::registerColorProfiles, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.color.ICC_Profile")});
            access.registerReachabilityHandler(JNIRegistrationAwt::registerFlavorMapProps, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.datatransfer.SystemFlavorMap")});
            access.registerReachabilityHandler(JNIRegistrationAwt::registerRTFReaderCharsets, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.swing.text.rtf.RTFReader")});
            access.registerReachabilityHandler(JNIRegistrationAwt::registerOceanThemeIcons, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.swing.plaf.metal.OceanTheme")});
            access.registerReachabilityHandler(JNIRegistrationAwt::registerFontManager, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.SunFontManager")});
            if (!JNIRegistrationAwt.isHeadless()) {
                access.registerReachabilityHandler(JNIRegistrationAwt::registerBasicLafResources, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.swing.plaf.basic.BasicLookAndFeel")});
                access.registerReachabilityHandler(JNIRegistrationAwt::registerDndIcons, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.dnd.DragSource")});
                access.registerReachabilityHandler(JNIRegistrationAwt::registerKeyCodes, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.event.KeyEvent")});
                access.registerReachabilityHandler(JNIRegistrationAwt::registerDataTransferer, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.datatransfer.DataTransferer")});
                access.registerReachabilityHandler(JNIRegistrationAwt::registerShellFolderManager, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.swing.FilePane")});
                if (JNIRegistrationAwt.isLinux()) {
                    access.registerReachabilityHandler(JNIRegistrationAwt::registerGtkFileDialog, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.X11.GtkFileDialogPeer")});
                }
            }
        }
    }

    private static void handlePreferencesClassReachable(Feature.DuringAnalysisAccess access) {
        RuntimeJNIAccess.register((Class[])new Class[]{System.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.lang.System", "load", String.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.lang.System", "loadLibrary", String.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.lang.System", "getProperty", String.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.lang.System", "setProperty", String.class, String.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{GraphicsEnvironment.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.GraphicsEnvironment", "isHeadless", new Class[0])});
        NativeLibraries nativeLibraries = JNIRegistrationAwt.getNativeLibraries(access);
        if (JNIRegistrationAwt.isDarwin()) {
            NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("awt");
            nativeLibraries.addStaticJniLibrary("awt", new String[0]);
            nativeLibraries.addStaticJniLibrary("osx", new String[0]);
            nativeLibraries.addStaticJniLibrary("osxui", new String[0]);
            nativeLibraries.addStaticJniLibrary("osxapp", new String[0]);
            nativeLibraries.addStaticJniLibrary("jawt", new String[0]);
            NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("osx");
            NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("osxui");
            NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("osxapp");
            NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("jawt");
            NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("jli");
            nativeLibraries.addStaticJniLibrary("jli", new String[0]);
            Stream.of("Cocoa", "Carbon", "OpenGL", "CoreServices", "Accelerate", "QuartzCore", "Security", "JavaRuntimeSupport").forEach(framework -> nativeLibraries.addDynamicNonJniLibrary("-framework " + framework));
            if (JavaVersionUtil.JAVA_SPEC >= 17) {
                nativeLibraries.addDynamicNonJniLibrary("-framework Metal");
            }
            nativeLibraries.addDynamicNonJniLibrary("stdc++");
            nativeLibraries.addDynamicNonJniLibrary("m");
        }
        JNIRegistrationAwt.registerCommonClasses(access);
        if (!JNIRegistrationAwt.isHeadless() || JNIRegistrationAwt.isDarwin()) {
            JNIRegistrationAwt.registerHeadfullClasses(access);
        }
        access.registerReachabilityHandler(JNIRegistrationAwt::registerHtml32bdtd, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.swing.text.html.HTMLEditorKit")});
    }

    private static void registerJPEG(Feature.DuringAnalysisAccess access) {
        if (JNIRegistrationAwt.isDarwin()) {
            NativeLibraries nativeLibraries = JNIRegistrationAwt.getNativeLibraries(access);
            NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("javajpeg");
            nativeLibraries.addStaticJniLibrary("javajpeg", new String[0]);
        }
        JNIRegistrationAwt.registerJPEGClasses(access);
    }

    private static void registerJPEGClasses(Feature.DuringAnalysisAccess access) {
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.JPEGImageDecoder")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.image.JPEGImageDecoder", "sendHeaderInfo", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.image.JPEGImageDecoder", "sendPixels", byte[].class, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.image.JPEGImageDecoder", "sendPixels", int[].class, Integer.TYPE)});
    }

    private static void registerSystemColor(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Class[])new Class[]{SystemColor.class});
        RuntimeReflection.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.SystemColor", "activeCaption", "activeCaptionBorder", "activeCaptionText", "control", "controlDkShadow", "controlHighlight", "controlLtHighlight", "controlShadow", "controlText", "desktop", "inactiveCaption", "inactiveCaptionBorder", "inactiveCaptionText", "info", "infoText", "menu", "menuText", "scrollbar", "text", "textHighlight", "textHighlightText", "textInactiveText", "textText", "window", "windowBorder", "windowText"));
    }

    private static void registerEvent(Feature.DuringAnalysisAccess access) {
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Event", "target", "x", "y"));
    }

    private static void registerWindowsMenu(Feature.DuringAnalysisAccess access) {
        RuntimeJNIAccess.register((Class[])new Class[]{Menu.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Menu", "countItemsImpl", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Menu", "getItemImpl", Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{MenuComponent.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.MenuComponent", "getFont_NoClientCode", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{MenuItem.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.MenuItem", "enabled", "label"));
        RuntimeJNIAccess.register((Class[])new Class[]{CheckboxMenuItem.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.CheckboxMenuItem", "state"));
        RuntimeJNIAccess.register((Class[])new Class[]{PopupMenu.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.PopupMenu", "isTrayIconPopup"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WMenuItemPeer")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.windows.WMenuItemPeer", "isCheckbox", "shortcutLabel"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WMenuItemPeer", "getDefaultFont", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WMenuItemPeer", "handleAction", Long.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WCheckboxMenuItemPeer", "handleAction", Boolean.TYPE)});
    }

    private static void registerTrayIcon(Feature.DuringAnalysisAccess access) {
        RuntimeJNIAccess.register((Class[])new Class[]{TrayIcon.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.TrayIcon", "actionCommand", "id"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WTrayIconPeer")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WTrayIconPeer", "postEvent", AWTEvent.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WTrayIconPeer", "showPopupMenu", Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WTrayIconPeer", "updateImage", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.event.ActionEvent")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.event.ActionEvent", Object.class, Integer.TYPE, String.class, Long.TYPE, Integer.TYPE)});
    }

    private static void registerImagingLib(Feature.DuringAnalysisAccess access) {
        if (JNIRegistrationAwt.isDarwin()) {
            NativeLibraries nativeLibraries = JNIRegistrationAwt.getNativeLibraries(access);
            NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("mlib_image");
            nativeLibraries.addStaticJniLibrary("mlib_image", new String[0]);
        }
    }

    private static void registerLCMS(Feature.DuringAnalysisAccess access) {
        if (JNIRegistrationAwt.isDarwin()) {
            NativeLibraries nativeLibraries = JNIRegistrationAwt.getNativeLibraries(access);
            NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("lcms");
            nativeLibraries.addStaticJniLibrary("lcms", new String[0]);
        }
    }

    private static void registerFreeType(Feature.DuringAnalysisAccess access) {
        if (SubstrateOptions.StaticExecutable.getValue().booleanValue()) {
            return;
        }
        if (JNIRegistrationAwt.isDarwin()) {
            NativeLibraries nativeLibraries = JNIRegistrationAwt.getNativeLibraries(access);
            NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("fontmanager");
            nativeLibraries.addStaticJniLibrary("fontmanager", "awt_lwawt", "freetype");
        }
        if (JNIRegistrationAwt.isLinux()) {
            RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.FontConfigManager$FontConfigInfo")});
            RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.font.FontConfigManager$FontConfigInfo", "fcVersion", "cacheDirs"));
            RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.FontConfigManager$FcCompFont")});
            RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.font.FontConfigManager$FcCompFont", "fcName", "firstFont", "allFonts"));
            RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.FontConfigManager$FontConfigFont")});
            RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.font.FontConfigManager$FontConfigFont", new Class[0])});
            RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.font.FontConfigManager$FontConfigFont", "familyName", "styleStr", "fullName", "fontFile"));
        }
    }

    private static void registerColorProfiles(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "sun.java2d.cmm.profiles.*");
    }

    private static void registerFlavorMapProps(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "sun.datatransfer.resources.flavormap.properties");
    }

    private static void registerRTFReaderCharsets(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "javax.swing.text.rtf.charsets.*");
    }

    private static void registerOceanThemeIcons(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "javax.swing.plaf.metal.icons.*");
        ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "javax.swing.plaf.basic.icons.*");
    }

    private static void registerBasicLafResources(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        ResourcesRegistry resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        resourcesRegistry.addResourceBundles("com.sun.swing.internal.plaf.basic.resources.basic");
    }

    private static void registerDndIcons(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        ResourcesRegistry resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        resourcesRegistry.addResources("sun.awt.*");
    }

    private static void registerErrorClasses(Feature.DuringAnalysisAccess access) {
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.lang.Exception")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.lang.Exception", String.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.AWTError")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.AWTError", String.class)});
    }

    private static void registerKeyCodes(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Class[])new Class[]{KeyEvent.class});
        String[] keys = (String[])Arrays.stream(KeyEvent.class.getDeclaredFields()).filter(f -> f.getType() == Integer.TYPE && f.getName().startsWith("VK_")).map(f -> f.getName()).toArray(String[]::new);
        RuntimeReflection.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.event.KeyEvent", keys));
    }

    private static void registerDataTransferer(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Class[])new Class[]{String.class});
        RuntimeReflection.register((Class[])new Class[]{List.class});
        RuntimeReflection.register((Class[])new Class[]{Reader.class});
        RuntimeReflection.register((Class[])new Class[]{InputStream.class});
        RuntimeReflection.register((Class[])new Class[]{Serializable.class});
        RuntimeReflection.register((Class[])new Class[]{CharBuffer.class});
        RuntimeReflection.register((Class[])new Class[]{ByteBuffer.class});
        RuntimeReflection.register((Class[])new Class[]{Image.class});
        RuntimeReflection.register((Class[])new Class[]{byte[].class});
        RuntimeReflection.register((Class[])new Class[]{char[].class});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.rmi.MarshalledObject", Object.class)});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.rmi.MarshalledObject", "get", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageReader", "readInputData", byte[].class, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageReader", "skipInputBytes", Long.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageReader", "warningOccurred", Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageReader", "warningWithMessage", String.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageReader", "setImageData", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageReader", "acceptPixels", Integer.TYPE, Boolean.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageReader", "passStarted", Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageReader", "passComplete", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageReader", "pushBack", Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageReader", "skipPastImage", Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageWriter", "writeOutputData", byte[].class, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageWriter", "warningOccurred", Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageWriter", "warningWithMessage", String.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageWriter", "writeMetadata", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageWriter", "grabPixels", Integer.TYPE)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "javax.imageio.plugins.jpeg.JPEGQTable", "qTable"));
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "javax.imageio.plugins.jpeg.JPEGHuffmanTable", "lengths", "values"));
    }

    private static void registerShellFolderManager(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.shell.ShellFolderManager")});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.awt.shell.ShellFolderManager", new Class[0])});
        if (JNIRegistrationAwt.isWindows()) {
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.shell.Win32ShellFolderManager2")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.awt.shell.Win32ShellFolderManager2", new Class[0])});
            RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.shell.Win32ShellFolder2")});
            RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.shell.Win32ShellFolder2", "FDATE", "FNAME", "FSIZE", "FTYPE", "displayName", "folderType", "pIShellIcon"));
            RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.shell.Win32ShellFolder2", "setRelativePIDL", Long.TYPE)});
            RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.shell.Win32ShellFolder2", "setIShellFolder", Long.TYPE)});
            RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.shell.Win32ShellFolder2$KnownFolderDefinition")});
            RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.awt.shell.Win32ShellFolder2$KnownFolderDefinition", new Class[0])});
            RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.shell.Win32ShellFolder2$KnownFolderDefinition", "attributes", "category", "defenitionFlags", "description", "ftidType", "guid", "icon", "localizedName", "name", "parent", "parsingName", "path", "relativePath", "saveLocation", "security", "tooltip"));
            RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.shell.ShellFolderColumnInfo")});
            RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.awt.shell.ShellFolderColumnInfo", String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE)});
        }
    }

    private static void registerFontManager(Feature.DuringAnalysisAccess access) {
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.GlyphLayout$GVData")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.font.GlyphLayout$GVData", "_count", "_flags", "_glyphs", "_indices", "_positions"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.font.GlyphLayout$GVData", "grow", new Class[0])});
        if (JNIRegistrationAwt.isLinux()) {
            RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.GraphicsEnvironment", "getLocalGraphicsEnvironment", new Class[0])});
            RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.SunGraphicsEnvironment")});
            RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.java2d.SunGraphicsEnvironment", "isDisplayLocal", new Class[0])});
        }
        if (JavaVersionUtil.JAVA_SPEC >= 19) {
            RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.FontUtilities")});
            RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.font.FontUtilities", "debugFonts", new Class[0])});
        }
    }

    private static void registerGtkFileDialog(Feature.DuringAnalysisAccess access) {
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.X11.GtkFileDialogPeer", "widget"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.X11.GtkFileDialogPeer", "filenameFilterCallback", String.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.X11.GtkFileDialogPeer", "setFileInternal", String.class, String[].class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.X11.GtkFileDialogPeer", "setWindow", Long.TYPE)});
    }

    private static void registerHtml32bdtd(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)duringAnalysisAccess, "javax.swing.text.html.HTMLEditorKit")});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)duringAnalysisAccess, "javax.swing.text.html.HTMLEditorKit", new Class[0])});
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)duringAnalysisAccess, "javax.swing.text.rtf.RTFEditorKit")});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)duringAnalysisAccess, "javax.swing.text.rtf.RTFEditorKit", new Class[0])});
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)duringAnalysisAccess, "javax.swing.JEditorPane$PlainEditorKit")});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)duringAnalysisAccess, "javax.swing.JEditorPane$PlainEditorKit", new Class[0])});
        ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "javax.swing.text.html.parser.html32.bdtd");
        JNIRegistrationAwt.registerDefaultCSS(duringAnalysisAccess);
    }

    private static void registerDefaultCSS(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "javax.swing.text.html.default.css");
    }

    private static NativeLibraries getNativeLibraries(Feature.DuringAnalysisAccess access) {
        FeatureImpl.DuringAnalysisAccessImpl a = (FeatureImpl.DuringAnalysisAccessImpl)access;
        return a.getNativeLibraries();
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private static void registerCommonClasses(Feature.DuringAnalysisAccess access) {
        if (JNIRegistrationAwt.isLinux()) {
            JNIRegistrationAwt.registerErrorClasses(access);
        } else if (JNIRegistrationAwt.isWindows()) {
            JNIRegistrationAwt.registerErrorClasses(access);
            JNIRegistrationAwt.registerCommonWindowsClasses(access);
        }
        RuntimeJNIAccess.register((Class[])new Class[]{AlphaComposite.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.AlphaComposite", "extraAlpha", "rule"));
        RuntimeJNIAccess.register((Class[])new Class[]{Color.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.Color", Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Color", "getRGB", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{AffineTransform.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.geom.AffineTransform", "m00", "m01", "m02", "m10", "m11", "m12"));
        RuntimeJNIAccess.register((Class[])new Class[]{GeneralPath.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.geom.GeneralPath", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.geom.GeneralPath", Integer.TYPE, byte[].class, Integer.TYPE, float[].class, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{Path2D.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.geom.Path2D", "numTypes", "pointTypes", "windingRule"));
        RuntimeJNIAccess.register((Class[])new Class[]{Path2D.Float.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.geom.Path2D$Float", "floatCoords"));
        RuntimeJNIAccess.register((Class[])new Class[]{Point2D.Float.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.geom.Point2D$Float", "x", "y"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.geom.Point2D$Float", Float.TYPE, Float.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{Rectangle2D.Float.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.geom.Rectangle2D$Float", "height", "width", "x", "y"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.geom.Rectangle2D$Float", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.geom.Rectangle2D$Float", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{ColorModel.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.image.ColorModel", "colorSpace", "colorSpaceType", "isAlphaPremultiplied", "is_sRGB", "nBits", "numComponents", "pData", "supportsAlpha", "transparency"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.image.ColorModel", "getRGBdefault", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{IndexColorModel.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.image.IndexColorModel", "allgrayopaque", "colorData", "map_size", "rgb", "transparent_index"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.SunHints")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.SunHints", "INTVAL_STROKE_PURE"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.CharToGlyphMapper")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.font.CharToGlyphMapper", "charToGlyph", Integer.TYPE)});
        JNIRegistrationAwt.registerJNIAccessForClassMembers(access, new ClassSunFont2DRegistration());
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.FontStrike")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.font.FontStrike", "getGlyphMetrics", Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.FreetypeFontScaler")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.font.FreetypeFontScaler", "invalidateScaler", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.GlyphList")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.font.GlyphList", "images", "lcdRGBOrder", "lcdSubPixPos", "len", "positions", "usePositions", "x", "y", "gposx", "gposy"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.PhysicalStrike")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.font.PhysicalStrike", "pScalerContext"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.font.PhysicalStrike", "adjustPoint", Point2D.Float.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.font.PhysicalStrike", "getGlyphPoint", Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.StrikeMetrics")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.font.StrikeMetrics", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.TrueTypeFont")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.font.TrueTypeFont", "readBlock", ByteBuffer.class, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.font.TrueTypeFont", "readBytes", Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.Type1Font")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.font.Type1Font", "readFile", ByteBuffer.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.Disposer")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.java2d.Disposer", "addRecord", Object.class, Long.TYPE, Long.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.InvalidPipeException")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.NullSurfaceData")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.SunGraphics2D")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.java2d.SunGraphics2D", "clipRegion", "composite", "eargb", "lcdTextContrast", "pixel", "strokeHint"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.SurfaceData")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.java2d.SurfaceData", "pData", "valid"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.Blit")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.Blit", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.BlitBg")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.BlitBg", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType", "AnyAlpha", "Src", "SrcNoEa", "SrcOver", "SrcOverNoEa", "Xor"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.DrawGlyphList")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.DrawGlyphList", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.DrawGlyphListAA")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.DrawGlyphListAA", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.DrawGlyphListLCD")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.DrawGlyphListLCD", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.DrawLine")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.DrawLine", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.DrawParallelogram")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.DrawParallelogram", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.DrawPath")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.DrawPath", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.DrawPolygons")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.DrawPolygons", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.DrawRect")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.DrawRect", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.FillParallelogram")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.FillParallelogram", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.FillPath")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.FillPath", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.FillRect")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.FillRect", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.FillSpans")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.FillSpans", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.GraphicsPrimitive")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.java2d.loops.GraphicsPrimitive", "pNativePrim"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.GraphicsPrimitiveMgr")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.java2d.loops.GraphicsPrimitiveMgr", "register", JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "[Lsun.java2d.loops.GraphicsPrimitive;"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "[Lsun.java2d.loops.GraphicsPrimitive;")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.MaskBlit")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.MaskBlit", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.MaskFill")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.MaskFill", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.ScaledBlit")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.ScaledBlit", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType", "Any3Byte", "Any4Byte", "AnyByte", "AnyColor", "AnyInt", "AnyShort", "ByteBinary1Bit", "ByteBinary2Bit", "ByteBinary4Bit", "ByteGray", "ByteIndexed", "ByteIndexedBm", "FourByteAbgr", "FourByteAbgrPre", "Index12Gray", "Index8Gray", "IntArgb", "IntArgbBm", "IntArgbPre", "IntBgr", "IntRgb", "IntRgbx", "OpaqueColor", "ThreeByteBgr", "Ushort4444Argb", "Ushort555Rgb", "Ushort555Rgbx", "Ushort565Rgb", "UshortGray", "UshortIndexed"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.TransformHelper")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.loops.TransformHelper", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.CompositeType"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.SurfaceType"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.loops.XORComposite")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.java2d.loops.XORComposite", "alphaMask", "xorColor", "xorPixel"));
        List.of("sun.java2d.loops.OpaqueCopyAnyToArgb", "sun.java2d.loops.OpaqueCopyArgbToAny", "sun.java2d.loops.XorCopyArgbToAny", "sun.java2d.loops.SetFillRectANY", "sun.java2d.loops.SetFillPathANY", "sun.java2d.loops.SetFillSpansANY", "sun.java2d.loops.SetDrawLineANY", "sun.java2d.loops.SetDrawPolygonsANY", "sun.java2d.loops.SetDrawPathANY", "sun.java2d.loops.SetDrawRectANY", "sun.java2d.loops.XorFillRectANY", "sun.java2d.loops.XorFillPathANY", "sun.java2d.loops.XorFillSpansANY", "sun.java2d.loops.XorDrawLineANY", "sun.java2d.loops.XorDrawPolygonsANY", "sun.java2d.loops.XorDrawPathANY", "sun.java2d.loops.XorDrawRectANY", "sun.java2d.loops.XorDrawGlyphListANY", "sun.java2d.loops.XorDrawGlyphListAAANY").forEach(graphicsPrimitive -> {
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, graphicsPrimitive)});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, graphicsPrimitive, new Class[0])});
        });
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.pipe.Region")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.java2d.pipe.Region", "bands", "endIndex", "hix", "hiy", "lox", "loy"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.pipe.RegionIterator")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.java2d.pipe.RegionIterator", "curIndex", "numXbands", "region"));
        RuntimeJNIAccess.register((Class[])new Class[]{BufferedImage.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.image.BufferedImage", "colorModel", "imageType", "raster"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.image.BufferedImage", "getRGB", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, int[].class, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.image.BufferedImage", "setRGB", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, int[].class, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{Raster.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.image.Raster", "dataBuffer", "height", "minX", "minY", "numBands", "numDataElements", "sampleModel", "sampleModelTranslateX", "sampleModelTranslateY", "width"));
        RuntimeJNIAccess.register((Class[])new Class[]{SampleModel.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.image.SampleModel", "height", "width"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.image.SampleModel", "getPixels", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, int[].class, DataBuffer.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.image.SampleModel", "setPixels", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, int[].class, DataBuffer.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{SinglePixelPackedSampleModel.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.image.SinglePixelPackedSampleModel", "bitMasks", "bitOffsets", "bitSizes", "maxBitSize"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.BufImgSurfaceData$ICMColorData")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.image.BufImgSurfaceData$ICMColorData", "pData"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.awt.image.BufImgSurfaceData$ICMColorData", Long.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.IntegerComponentRaster")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.image.IntegerComponentRaster", "data", "dataOffsets", "pixelStride", "scanlineStride", "type"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.AWTAutoShutdown")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.AWTAutoShutdown", "notifyToolkitThreadBusy", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.AWTAutoShutdown", "notifyToolkitThreadFree", new Class[0])});
    }

    private static void registerCommonWindowsClasses(Feature.DuringAnalysisAccess access) {
        RuntimeJNIAccess.register((Class[])new Class[]{Boolean.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.lang.Boolean", "getBoolean", String.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{Toolkit.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Toolkit", "getDefaultToolkit", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Toolkit", "getFontMetrics", Font.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.SunToolkit")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.SunToolkit", "isTouchKeyboardAutoShowEnabled", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WToolkit")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WToolkit", "windowsSettingChange", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WToolkit", "displayChanged", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WToolkit", "paletteChanged", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.Win32GraphicsEnvironment")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.Win32GraphicsEnvironment", "dwmCompositionChanged", Boolean.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{Component.class});
        RuntimeJNIAccess.register((Class[])new Class[]{Insets.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.Insets", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Insets", "bottom", "left", "right", "top"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.SunVolatileImage")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.image.SunVolatileImage", "volSurfaceManager"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.VolatileSurfaceManager")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.image.VolatileSurfaceManager", "sdCurrent"));
        RuntimeJNIAccess.register((Class[])new Class[]{UserSessionEvent.Reason.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.desktop.UserSessionEvent$Reason", "CONSOLE", "LOCK", "REMOTE", "UNSPECIFIED"));
        JNIRegistrationAwt.registerJNIAccessForClassMembers(access, new ClassSunJava2dWindowsWindowsFlags());
        RuntimeJNIAccess.register((Class[])new Class[]{Font.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Font", "getFontPeer", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Font", "getFont", String.class)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Font", "name", "pData", "size", "style"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WDesktopPeer", "systemSleepCallback", Boolean.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WDesktopPeer", "userSessionCallback", Boolean.TYPE, UserSessionEvent.Reason.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WDesktopPeer")});
    }

    private static void registerHeadfullClasses(Feature.DuringAnalysisAccess access) {
        if (JNIRegistrationAwt.isLinux()) {
            JNIRegistrationAwt.registerLinuxClasses(access);
            JNIRegistrationAwt.registerLinuxX11Classes(access);
        } else if (JNIRegistrationAwt.isDarwin()) {
            JNIRegistrationAwt.registerDarwinClasses(access);
        } else if (JNIRegistrationAwt.isWindows()) {
            JNIRegistrationAwt.registerWindowsClasses(access);
        }
        JNIRegistrationAwt.registerLookAndFeelClasses(access);
        RuntimeJNIAccess.register((Class[])new Class[]{String.class});
        RuntimeJNIAccess.register((Class[])new Class[]{Locale.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.lang.String", "toLowerCase", Locale.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{ArrayList.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.util.ArrayList", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.util.ArrayList", Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.util.ArrayList", "add", Object.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.util.ArrayList", "contains", Object.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{Dimension.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Dimension", "height", "width"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.Dimension", Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{AWTEvent.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.AWTEvent", "bdata", "consumed", "id"));
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.SequencedEvent")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.SequencedEvent")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.SequencedEvent", AWTEvent.class)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Color", "value"));
        RuntimeJNIAccess.register((Class[])new Class[]{Component.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Component", "appContext", "background", "cursor", "enabled", "focusable", "foreground", "graphicsConfig", "height", "parent", "isPacked", "name", "peer", "visible", "width", "x", "y"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Component", "getLocationOnScreen_NoTreeLock", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Component", "getParent_NoClientCode", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{DisplayMode.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.DisplayMode", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{Font.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Font", "pData", "size", "style"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Font", "getFamily_NoClientCode", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Font", "getFontPeer", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Font", "getName", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{Insets.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Insets", "bottom", "left", "right", "top"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.Insets", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{Rectangle.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.Rectangle", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{InputEvent.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.event.InputEvent", "modifiers"));
        RuntimeJNIAccess.register((Class[])new Class[]{KeyEvent.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.event.KeyEvent", "isProxyActive", "keyChar", "keyCode"));
        RuntimeJNIAccess.register((Class[])new Class[]{DirectColorModel.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.image.DirectColorModel", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{ClassLoader.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.lang.ClassLoader", "getPlatformClassLoader", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.lang.ClassLoader", "loadClass", String.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{Thread.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.lang.Thread", "yield", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.SunToolkit")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.SunToolkit", "awtLock", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.SunToolkit", "awtLockNotify", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.SunToolkit", "awtLockNotifyAll", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.SunToolkit", "awtLockWait", Long.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.SunToolkit", "awtUnlock", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.ByteComponentRaster")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.image.ByteComponentRaster", "data", "dataOffsets", "pixelStride", "scanlineStride", "type"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.GifImageDecoder")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.image.GifImageDecoder", "outCode", "prefix", "suffix"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.image.GifImageDecoder", "readBytes", byte[].class, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.image.GifImageDecoder", "sendPixels", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, ColorModel.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.ImageRepresentation")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.image.ImageRepresentation", "numSrcLUT", "srcLUTtransIndex"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.pipe.ShapeSpanIterator")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.java2d.pipe.ShapeSpanIterator", "pData"));
        RuntimeJNIAccess.register((Class[])new Class[]{InputStream.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.io.InputStream", "available", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.io.InputStream", "read", byte[].class, Integer.TYPE, Integer.TYPE)});
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.marlin.DMarlinRenderingEngine")});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.java2d.marlin.DMarlinRenderingEngine", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{Boolean.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.lang.Boolean", Boolean.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{Float.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.lang.Float", Float.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{Integer.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.lang.Integer", Integer.TYPE)});
    }

    private static void registerComponentUIs(Feature.DuringAnalysisAccess access, String packageName, String ... componentUIs) {
        Stream.of(componentUIs).map(name -> String.format("%s.%s", packageName, name)).forEach(componentUI -> {
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, componentUI)});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, componentUI, "createUI", JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.swing.JComponent"))});
        });
    }

    private static void registerDNDClasses(Feature.DuringAnalysisAccess access) {
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.dnd.SunDragSourceContextPeer")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.dnd.SunDragSourceContextPeer", "dragEnter", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.dnd.SunDragSourceContextPeer", "dragExit", Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.dnd.SunDragSourceContextPeer", "operationChanged", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.dnd.SunDragSourceContextPeer", "dragDropFinished", Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.dnd.SunDragSourceContextPeer", "dragMotion", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.dnd.SunDragSourceContextPeer", "dragMouseMoved", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.dnd.SunDropTargetContextPeer", "handleExitMessage", Component.class, Long.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.dnd.SunDropTargetContextPeer")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.dnd.SunDropTargetContextPeer", "handleMotionMessage", Component.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, long[].class, Long.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.dnd.SunDropTargetContextPeer", "handleDropMessage", Component.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, long[].class, Long.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.dnd.SunDropTargetContextPeer", "handleEnterMessage", Component.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, long[].class, Long.TYPE)});
    }

    private static void registerLookAndFeelClasses(Feature.DuringAnalysisAccess access) {
        JNIRegistrationAwt.registerComponentUIs(access, "javax.swing.plaf.basic", "BasicButtonUI", "BasicCheckBoxUI", "BasicColorChooserUI", "BasicFormattedTextFieldUI", "BasicMenuBarUI", "BasicMenuUI", "BasicMenuItemUI", "BasicCheckBoxMenuItemUI", "BasicRadioButtonMenuItemUI", "BasicRadioButtonUI", "BasicToggleButtonUI", "BasicPopupMenuUI", "BasicProgressBarUI", "BasicScrollBarUI", "BasicScrollPaneUI", "BasicSplitPaneUI", "BasicSliderUI", "BasicSeparatorUI", "BasicSpinnerUI", "BasicToolBarSeparatorUI", "BasicPopupMenuSeparatorUI", "BasicTabbedPaneUI", "BasicTextAreaUI", "BasicTextFieldUI", "BasicPasswordFieldUI", "BasicTextPaneUI", "BasicEditorPaneUI", "BasicTreeUI", "BasicLabelUI", "BasicListUI", "BasicToolBarUI", "BasicToolTipUI", "BasicComboBoxUI", "BasicTableUI", "BasicTableHeaderUI", "BasicInternalFrameUI", "BasicDesktopPaneUI", "BasicDesktopIconUI", "BasicFileChooserUI", "BasicOptionPaneUI", "BasicPanelUI", "BasicViewportUI", "BasicRootPaneUI");
        Class<?> lazyActionMapClass = JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.swing.plaf.basic.LazyActionMap");
        Stream.of("ButtonListener", "ComboBoxUI", "DesktopPaneUI", "InternalFrameUI", "LabelUI", "ListUI", "MenuBarUI", "MenuItemUI", "MenuUI", "OptionPaneUI", "PopupMenuUI", "RootPaneUI", "ScrollBarUI", "ScrollPaneUI", "SliderUI", "SpinnerUI", "SplitPaneUI", "TabbedPaneUI", "TableHeaderUI", "TableUI", "ToolBarUI", "TreeUI").map("javax.swing.plaf.basic.Basic"::concat).map(className -> JNIRegistrationAwt.method((Feature.FeatureAccess)access, className, "loadActionMap", lazyActionMapClass)).forEach(xva$0 -> RuntimeReflection.register((Executable[])new Executable[]{xva$0}));
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.swing.plaf.metal.MetalLookAndFeel")});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "javax.swing.plaf.metal.MetalLookAndFeel", new Class[0])});
        JNIRegistrationAwt.registerComponentUIs(access, "javax.swing.plaf.metal", "MetalButtonUI", "MetalCheckBoxUI", "MetalComboBoxUI", "MetalDesktopIconUI", "MetalFileChooserUI", "MetalInternalFrameUI", "MetalLabelUI", "MetalPopupMenuSeparatorUI", "MetalProgressBarUI", "MetalRadioButtonUI", "MetalScrollBarUI", "MetalScrollPaneUI", "MetalSeparatorUI", "MetalSliderUI", "MetalSplitPaneUI", "MetalTabbedPaneUI", "MetalTextFieldUI", "MetalToggleButtonUI", "MetalToolBarUI", "MetalToolTipUI", "MetalTreeUI", "MetalRootPaneUI", "MetalMenuBarUI");
        ResourcesRegistry resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        resourcesRegistry.addResourceBundles("com.sun.swing.internal.plaf.metal.resources.metal");
        JNIRegistrationAwt.registerComponentUIs(access, "javax.swing.plaf.synth", "SynthLookAndFeel");
        resourcesRegistry.addResourceBundles("com.sun.swing.internal.plaf.synth.resources.synth");
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.swing.plaf.nimbus.NimbusLookAndFeel")});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "javax.swing.plaf.nimbus.NimbusLookAndFeel", new Class[0])});
        Stream.of("MenuBarPainter", "SpinnerNextButtonPainter", "RadioButtonPainter", "TextAreaPainter", "CheckBoxMenuItemPainter", "FormattedTextFieldPainter", "ToggleButtonPainter", "InternalFrameTitlePaneMaximizeButtonPainter", "MenuPainter", "SliderThumbPainter", "DesktopIconPainter", "MenuBarMenuPainter", "TableEditorPainter", "ComboBoxTextFieldPainter", "RadioButtonMenuItemPainter", "InternalFrameTitlePaneMenuButtonPainter", "TextFieldPainter", "TableHeaderPainter", "InternalFrameTitlePaneIconifyButtonPainter", "DesktopPanePainter", "PopupMenuSeparatorPainter", "TreeCellPainter", "OptionPanePainter", "TextPanePainter", "ScrollPanePainter", "ToolBarToggleButtonPainter", "ProgressBarPainter", "TabbedPaneTabAreaPainter", "TableHeaderRendererPainter", "InternalFramePainter", "ComboBoxArrowButtonPainter", "SeparatorPainter", "ScrollBarButtonPainter", "SpinnerPanelSpinnerFormattedTextFieldPainter", "EditorPanePainter", "OptionPaneMessageAreaOptionPaneLabelPainter", "PopupMenuPainter", "TreeCellEditorPainter", "ButtonPainter", "CheckBoxPainter", "SliderTrackPainter", "SpinnerPreviousButtonPainter", "FileChooserPainter", "TabbedPaneTabPainter", "TreePainter", "InternalFrameTitlePaneCloseButtonPainter", "ToolBarPainter", "ToolTipPainter", "ToolBarButtonPainter", "ComboBoxPainter", "ScrollBarThumbPainter", "PasswordFieldPainter", "ArrowButtonPainter", "ScrollBarTrackPainter", "MenuItemPainter", "SplitPaneDividerPainter").map("javax.swing.plaf.nimbus."::concat).forEach(cls -> {
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, cls)});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, cls, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.swing.plaf.nimbus.AbstractRegionPainter$PaintContext"), Integer.TYPE)});
        });
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.motif.MotifLookAndFeel")});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.motif.MotifLookAndFeel", new Class[0])});
        JNIRegistrationAwt.registerComponentUIs(access, "com.sun.java.swing.plaf.motif", "MotifButtonUI", "MotifCheckBoxUI", "MotifFileChooserUI", "MotifLabelUI", "MotifMenuBarUI", "MotifMenuUI", "MotifMenuItemUI", "MotifCheckBoxMenuItemUI", "MotifRadioButtonMenuItemUI", "MotifRadioButtonUI", "MotifToggleButtonUI", "MotifPopupMenuUI", "MotifProgressBarUI", "MotifScrollBarUI", "MotifScrollPaneUI", "MotifSliderUI", "MotifSplitPaneUI", "MotifTabbedPaneUI", "MotifTextAreaUI", "MotifTextFieldUI", "MotifPasswordFieldUI", "MotifTextPaneUI", "MotifEditorPaneUI", "MotifTreeUI", "MotifInternalFrameUI", "MotifDesktopPaneUI", "MotifSeparatorUI", "MotifPopupMenuSeparatorUI", "MotifOptionPaneUI", "MotifComboBoxUI", "MotifDesktopIconUI");
        resourcesRegistry.addResources("com.sun.java.swing.plaf.motif.icons.*");
        resourcesRegistry.addResourceBundles("com.sun.java.swing.plaf.motif.resources.motif");
        resourcesRegistry.addResources("sun.awt.resources.awt");
        if (JNIRegistrationAwt.isLinux()) {
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.gtk.GTKLookAndFeel")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.gtk.GTKLookAndFeel", new Class[0])});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.gtk.GTKLookAndFeel", "createUI", JComponent.class)});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.gtk.GTKIconFactory")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.gtk.GTKIconFactory", "getCheckBoxMenuItemCheckIcon", new Class[0])});
            resourcesRegistry.addResources("com.sun.java.swing.plaf.gtk.resources.metacity.*");
            List.of("paintTreeExpandedIcon", "paintTreeCollapsedIcon", "paintCheckBoxIcon", "paintRadioButtonIcon", "paintCheckBoxMenuItemCheckIcon", "paintRadioButtonMenuItemCheckIcon", "paintAscendingSortIcon", "paintDescendingSortIcon").forEach(paintIconMethod -> RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.gtk.GTKPainter", paintIconMethod, SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)}));
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.gtk.GTKPainter", "paintMenuArrowIcon", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.gtk.GTKConstants$ArrowType"))});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.gtk.GTKPainter", "paintToolBarHandleIcon", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.gtk.GTKConstants$Orientation"))});
            List.of("getAscendingSortIcon", "getDescendingSortIcon", "getTreeExpandedIcon", "getTreeCollapsedIcon", "getRadioButtonIcon", "getCheckBoxIcon", "getMenuArrowIcon", "getCheckBoxMenuItemCheckIcon", "getRadioButtonMenuItemCheckIcon", "getToolBarHandleIcon").forEach(getIconMethod -> RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.gtk.GTKIconFactory", getIconMethod, new Class[0])}));
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.gtk.GTKPainter$ListTableFocusBorder", "getSelectedCellBorder", new Class[0])});
        } else if (JNIRegistrationAwt.isDarwin()) {
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaLookAndFeel")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaLookAndFeel", new Class[0])});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaMenuPainter")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaMenuPainter", new Class[0])});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaMnemonicHandler$AltProcessor")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaMnemonicHandler$AltProcessor", new Class[0])});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaScrollRegionBorder")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaScrollRegionBorder", new Class[0])});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaTextFieldBorder")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaTextFieldBorder", new Class[0])});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaUtilControlSize$PropertySizeListener")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaUtilControlSize$PropertySizeListener", new Class[0])});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaKeyBindings")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaKeyBindings", new Class[0])});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaButtonBorder$Dynamic")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaButtonBorder$Dynamic", new Class[0])});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaButtonBorder$Named")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaButtonBorder$Named", JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaButtonBorder$Named"))});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaButtonBorder$Toggle")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaButtonBorder$Toggle", new Class[0])});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaButtonBorder$Toolbar")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaButtonBorder$Toolbar", new Class[0])});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaGroupBorder$TabbedPane")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaGroupBorder$TabbedPane", new Class[0])});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaGroupBorder$Titleless")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaGroupBorder$Titleless", new Class[0])});
            JNIRegistrationAwt.registerComponentUIs(access, "com.apple.laf", "AquaButtonUI", "AquaButtonCheckBoxUI", "AquaMenuItemUI", "AquaLabelUI", "AquaListUI", "AquaMenuUI", "AquaMenuItemUI", "AquaOptionPaneUI", "AquaPanelUI", "AquaMenuItemUI", "AquaButtonRadioUI", "AquaProgressBarUI", "AquaRootPaneUI", "AquaSliderUI", "AquaScrollBarUI", "AquaTabbedPaneContrastUI", "AquaTabbedPaneUI", "AquaTableUI", "AquaButtonToggleUI", "AquaToolBarUI", "AquaToolTipUI", "AquaTreeUI", "AquaInternalFrameUI", "AquaInternalFrameDockIconUI", "AquaInternalFramePaneUI", "AquaEditorPaneUI", "AquaTextFieldUI", "AquaTextPaneUI", "AquaComboBoxUI", "AquaPopupMenuUI", "AquaTextAreaUI", "AquaMenuBarUI", "AquaFileChooserUI", "AquaTextPasswordFieldUI", "AquaTableHeaderUI", "AquaTextFieldFormattedUI", "AquaSpinnerUI", "AquaSplitPaneUI", "AquaScrollPaneUI", "AquaPopupMenuSeparatorUI", "AquaPopupMenuSeparatorUI", "AquaToolBarSeparatorUI");
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaButtonCheckBoxUI", new Class[0])});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaButtonRadioUI", new Class[0])});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaButtonToggleUI", new Class[0])});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaButtonUI", new Class[0])});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaLabelUI", new Class[0])});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaPanelUI", new Class[0])});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaPopupMenuSeparatorUI", new Class[0])});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaRootPaneUI", new Class[0])});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaToolTipUI", new Class[0])});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaToolBarUI$ToolBarBorder")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaToolBarUI$ToolBarBorder", new Class[0])});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.laf.AquaButtonUI$AquaHierarchyButtonListener")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.apple.laf.AquaButtonUI$AquaHierarchyButtonListener", new Class[0])});
        } else if (JNIRegistrationAwt.isWindows()) {
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.windows.WindowsLookAndFeel")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", new Class[0])});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel")});
            RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel", new Class[0])});
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.windows.WindowsSeparatorUI")});
            JNIRegistrationAwt.registerComponentUIs(access, "com.sun.java.swing.plaf.windows", "WindowsButtonUI", "WindowsCheckBoxUI", "WindowsCheckBoxMenuItemUI", "WindowsLabelUI", "WindowsRadioButtonUI", "WindowsRadioButtonMenuItemUI", "WindowsToggleButtonUI", "WindowsProgressBarUI", "WindowsSliderUI", "WindowsSplitPaneUI", "WindowsSpinnerUI", "WindowsTabbedPaneUI", "WindowsTextAreaUI", "WindowsTextFieldUI", "WindowsPasswordFieldUI", "WindowsTextPaneUI", "WindowsEditorPaneUI", "WindowsTreeUI", "WindowsToolBarUI", "WindowsToolBarSeparatorUI", "WindowsComboBoxUI", "WindowsTableHeaderUI", "WindowsInternalFrameUI", "WindowsDesktopPaneUI", "WindowsDesktopIconUI", "WindowsFileChooserUI", "WindowsMenuUI", "WindowsMenuItemUI", "WindowsMenuBarUI", "WindowsPopupMenuUI", "WindowsPopupMenuSeparatorUI", "WindowsScrollBarUI", "WindowsRootPaneUI");
            resourcesRegistry.addResources("com.sun.java.swing.plaf.windows.icons.*");
            resourcesRegistry.addResourceBundles("com.sun.java.swing.plaf.windows.resources.windows");
        }
    }

    private static void registerLinuxClasses(Feature.DuringAnalysisAccess access) {
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.xr.XRBackendNative")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.java2d.xr.XRBackendNative", "FMTPTR_A8", "FMTPTR_ARGB32", "MASK_XIMG"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.xr.XRSurfaceData")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.java2d.xr.XRSurfaceData", "picture", "xid"));
    }

    private static void registerLinuxX11Classes(Feature.DuringAnalysisAccess access) {
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.UNIXToolkit")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.UNIXToolkit", "loadIconCallback", byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.X11GraphicsEnvironment")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.X11.XWindow")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.X11.XWindow", "drawState", "graphicsConfig", "target"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.X11.XFramePeer")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.X11.XDialogPeer")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.X11.XRootWindow")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.X11.XRootWindow", "getXRootWindow", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.X11.XBaseWindow")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.X11.XBaseWindow", "window"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.X11.XBaseWindow", "getWindow", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.X11.XContentWindow")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.X11.XErrorHandlerUtil")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.X11.XErrorHandlerUtil", "init", Long.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.X11.XToolkit")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.X11.XToolkit", "modLockIsShiftLock", "numLockMask"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.X11GraphicsConfig")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.X11GraphicsConfig", "aData", "bitsPerPixel"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.X11GraphicsDevice")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.X11GraphicsDevice", "screen"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.X11GraphicsDevice", "addDoubleBufferVisual", Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.X11InputMethodBase")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.X11InputMethodBase", "pData"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.X11.XErrorHandlerUtil", "globalErrorHandler", Long.TYPE, Long.TYPE)});
        if (JavaVersionUtil.JAVA_SPEC < 17) {
            RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.X11GraphicsConfig", "screen"));
        }
    }

    private static void registerDarwinClasses(Feature.DuringAnalysisAccess access) {
        JNIRegistrationAwt.registerKeyCodes(access);
        JNIRegistrationAwt.registerDNDClasses(access);
        JNIRegistrationAwt.registerJPEGClasses(access);
        JNIRegistrationAwt.registerSystemColor(access);
        JNIRegistrationAwt.registerDarwinMenu(access);
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.util.Locale", String.class, String.class, String.class)});
        RuntimeReflection.register((Class[])new Class[]{Toolkit.class});
        RuntimeReflection.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Toolkit", "eventListener"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.LWCToolkit")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.LWCToolkit", "installToolkitThreadInJava", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.NSEvent")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.lwawt.macosx.NSEvent", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.lwawt.macosx.NSEvent", Integer.TYPE, Integer.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "short"), String.class, String.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.event.InputEvent", "getButtonDownMasks", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.CGraphicsEnvironment")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.CGraphicsEnvironment", "_displayReconfiguration", Integer.TYPE, Boolean.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.datatransfer.DataTransferer")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.datatransfer.DataTransferer", "convertData", Object.class, Transferable.class, Long.TYPE, Map.class, Boolean.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.datatransfer.DataTransferer", "getInstance", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.eawt.FullScreenHandler")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.apple.eawt.FullScreenHandler", "handleFullScreenEventFromNative", Window.class, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.eawt._AppEventHandler")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.apple.eawt._AppEventHandler", "handleNativeNotification", Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.apple.eawt._AppMenuBarHandler")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "com.apple.eawt._AppMenuBarHandler", "initMenuStates", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{Point2D.Double.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.geom.Point2D$Double", Double.TYPE, Double.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{Rectangle2D.Double.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.geom.Rectangle2D$Double", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.geom.Rectangle2D$Float", "setRect", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{Kernel.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.image.Kernel", "data", "height", "width"));
        RuntimeJNIAccess.register((Class[])new Class[]{PackedColorModel.class});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.accessibility.Accessible")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.accessibility.AccessibleBundle")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "javax.accessibility.AccessibleBundle", "key"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.accessibility.AccessibleRole")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.BytePackedRaster")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.image.BytePackedRaster", "data", "dataBitOffset", "pixelBitStride", "scanlineStride", "type"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.ShortComponentRaster")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.image.ShortComponentRaster", "data", "dataOffsets", "pixelStride", "scanlineStride", "type"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.CFontManager")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.font.CFontManager", "registerFont", String.class, String.class)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.font.GlyphList", "images", "lcdRGBOrder", "lcdSubPixPos", "len", "positions", "usePositions", "x", "y"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.opengl.CGLLayer")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.java2d.opengl.CGLLayer", "drawInCGLContext", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.opengl.CGLSurfaceData$CGLLayerSurfaceData")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.opengl.CGLSurfaceData$CGLOffScreenSurfaceData")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.opengl.OGLSurfaceData")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.java2d.opengl.OGLSurfaceData", "isBIOpShaderEnabled", "isFBObjectEnabled", "isGradShaderEnabled", "isLCDShaderEnabled", "nativeHeight", "nativeWidth"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.java2d.opengl.OGLSurfaceData", "dispose", Long.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.opengl.OGLGraphicsConfig"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.LWComponentPeer")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.lwawt.LWComponentPeer", "target"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.LWWindowPeer")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.CAccessibility")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CAccessibility", "getAccessibility", String[].class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CAccessibility", "getAccessibleIndexInParent", JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.accessibility.Accessible"), Component.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CAccessibility", "getAccessibleRole", JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.accessibility.Accessible"), Component.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CAccessibility", "getFocusOwner", Component.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.CAccessible")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CAccessible", "getCAccessible", JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.accessibility.Accessible"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.CDragSourceContextPeer")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CDragSourceContextPeer", "dragMouseMoved", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CDragSourceContextPeer", "resetHovering", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.CDropTargetContextPeer")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CDropTargetContextPeer", "getDropTargetContextPeer", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.CFRetainedResource")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.lwawt.macosx.CFRetainedResource", "ptr"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.CInputMethod")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.lwawt.macosx.CInputMethod", "fCurrentText", "fCurrentTextLength"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CInputMethod", "unmarkText", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformView")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformView", "peer"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformView", "deliverKeyEvent", JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.NSEvent"))});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformView", "deliverMouseEvent", JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.NSEvent"))});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "target"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "deliverIconify", Boolean.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "deliverMoveResizeEvent", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "deliverNCMouseDown", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "deliverWindowClosingEvent", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "deliverWindowFocusEvent", Boolean.TYPE, JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow"))});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "isBlocked", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "isSimpleWindowOwnedByEmbeddedFrame", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "isVisible", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "windowDidBecomeMain", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "windowDidEnterFullScreen", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "windowDidExitFullScreen", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "windowWillEnterFullScreen", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "windowWillExitFullScreen", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "windowWillMiniaturize", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CPlatformWindow", "checkBlockingAndOrder", new Class[0])});
        RuntimeReflection.register((Class[])new Class[]{MouseMotionListener.class});
        ResourcesRegistry resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        resourcesRegistry.addResourceBundles("sun.util.resources.CurrencyNames");
        resourcesRegistry.addResourceBundles("sun.util.resources.CalendarData");
        resourcesRegistry.addResourceBundles("sun.util.resources.LocaleNames");
    }

    private static void registerDarwinMenu(Feature.DuringAnalysisAccess access) {
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.CCheckboxMenuItem")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CCheckboxMenuItem", "handleAction", Boolean.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.CMenuItem")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CMenuItem", "handleAction", Long.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.CTrayIcon")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CTrayIcon", "getPopupMenuModel", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.lwawt.macosx.CTrayIcon", "handleMouseEvent", JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.lwawt.macosx.NSEvent"))});
    }

    private static void registerWindowsClasses(Feature.DuringAnalysisAccess access) {
        JNIRegistrationAwt.registerKeyCodes(access);
        JNIRegistrationAwt.registerJPEGClasses(access);
        JNIRegistrationAwt.registerSystemColor(access);
        JNIRegistrationAwt.registerEvent(access);
        JNIRegistrationAwt.registerWindowsMenu(access);
        JNIRegistrationAwt.registerTrayIcon(access);
        RuntimeJNIAccess.register((Class[])new Class[]{HashMap.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.util.HashMap", "containsKey", Object.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.util.HashMap", "put", Object.class, Object.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{MouseEvent.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.event.MouseEvent", "x", "y", "button", "causedByTouchEvent"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.event.MouseEvent", JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.Component"), Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.event.MouseWheelEvent", Component.class, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Double.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.event.FocusEvent")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.event.FocusEvent", Component.class, Integer.TYPE, Boolean.TYPE, Component.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.UngrabEvent")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.awt.UngrabEvent", Component.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Component", "getFont_NoClientCode", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Component", "getToolkitImpl", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Component", "isEnabledImpl", new Class[0])});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Container", "layoutMgr"));
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Cursor", "pData", "type"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Cursor", "setPData", Long.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{Dialog.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Dialog", "title", "undecorated"));
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Point", "x", "y"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.Point", Integer.TYPE, Integer.TYPE)});
        RuntimeReflection.register((Class[])new Class[]{MouseMotionListener.class});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.sun.java.swing.plaf.windows.WindowsPopupWindow")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.swing.Popup$HeavyWeightWindow")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WDesktopProperties", "setColorProperty", String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{FontMetrics.class});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.IntegerComponentRaster")});
        JNIRegistrationAwt.registerDNDClasses(access);
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WDragSourceContextPeer")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WDropTargetContextPeer")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WDropTargetContextPeer", "getWDropTargetContextPeer", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WDropTargetContextPeer", "getFileStream", String.class, Long.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WDropTargetContextPeer", "getIStream", Long.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.im.InputMethodWindow")});
        RuntimeJNIAccess.register((Class[])new Class[]{UserSessionEvent.Reason.class});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.FontDescriptor")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WDesktopProperties", "setFontProperty", String.class, String.class, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WDesktopProperties", "setIntegerProperty", String.class, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WComponentPeer", "disposeLater", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WComponentPeer", "handleExpose", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Component", "appContext", "background", "cursor", "enabled", "focusable", "foreground", "graphicsConfig", "height", "parent", "peer", "visible", "width", "x", "y"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WComponentPeer")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.PlatformFont", "componentFonts", "fontConfig"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.ExtendedKeyCodes", "getExtendedKeyCodeForChar", Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.event.InputEvent", "getButtonDownMasks", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.Win32GraphicsConfig")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.Win32GraphicsConfig", "visual"));
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.Win32GraphicsDevice", "dynamicColorModel"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.Win32GraphicsDevice")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.awt.TimedWindowEvent", Window.class, Integer.TYPE, Window.class, Integer.TYPE, Integer.TYPE, Long.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Font", "getFont", String.class)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Font", "name", "pData", "size", "style"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WWindowPeer", "setBackground", Color.class)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.event.KeyEvent", "extendedKeyCode", "keyChar", "keyCode", "primaryLevelUnicode", "rawCode", "scancode"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.event.MouseEvent", Component.class, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.desktop.UserSessionEvent$Reason", "CONSOLE", "LOCK", "REMOTE", "UNSPECIFIED"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.lang.Boolean", "getBoolean", String.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{MouseWheelEvent.class});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WFramePeer")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.event.MouseWheelEvent", Component.class, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Double.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WDesktopPeer", "userSessionCallback", Boolean.TYPE, UserSessionEvent.Reason.class)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.windows.WDesktopProperties", "pData"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.image.DirectColorModel", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.event.MouseEvent", "button", "causedByTouchEvent", "x", "y"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.TimedWindowEvent")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WDesktopProperties", "setStringProperty", String.class, String.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WComponentPeer", "postEvent", AWTEvent.class)});
        JNIRegistrationAwt.registerJNIAccessForClassMembers(access, new ClassJavaAwtWindowRegistration());
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WGlobalCursorManager")});
        RuntimeJNIAccess.register((Class[])new Class[]{Cursor.class});
        RuntimeJNIAccess.register((Class[])new Class[]{Frame.class});
        RuntimeJNIAccess.register((Class[])new Class[]{Window.Type.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.windows.WPanelPeer", "insets_"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.PlatformFont", "makeConvertedMultiFontString", String.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WFramePeer", "getExtendedState", new Class[0])});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.windows.WFramePeer", "keepOnMinimize"));
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.FontDescriptor", "nativeName", "useUnicode"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.PlatformFont")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WComponentPeer", "replaceSurfaceData", new Class[0])});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Frame", "undecorated"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WFontPeer")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.windows.WComponentPeer", "hwnd", "winGraphicsConfig"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.SunToolkit", "isTouchKeyboardAutoShowEnabled", new Class[0])});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.windows.WFontPeer", "textComponentFontName"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.FontDesignMetrics")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.font.FontDesignMetrics", "getHeight", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WDesktopProperties")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.windows.WObjectPeer", "createError", "destroyed", "pData", "target"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WComponentPeer", "replaceSurfaceDataLater", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WWindowPeer", "draggedToNewScreen", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.EmbeddedFrame")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WObjectPeer", "getPeerForTarget", Object.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.lang.Thread", "currentThread", new Class[0])});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.FontMetrics", "font"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.FontMetrics", "getHeight", new Class[0])});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.image.IndexColorModel", "allgrayopaque", "colorData", "lookupcache", "map_size", "rgb", "transparent_index"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WDesktopProperties", "setBooleanProperty", String.class, Boolean.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.lang.Enum", "name", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WPanelPeer")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.windows.WWindowPeer", "windowType"));
        RuntimeJNIAccess.register((Class[])new Class[]{ComponentEvent.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WGlobalCursorManager", "nativeUpdateCursor", Component.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{Container.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.Rectangle", "height", "width", "x", "y"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.event.ComponentEvent", Component.class, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{Point.class});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WObjectPeer")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.ExtendedKeyCodes")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WDesktopProperties", "setSoundProperty", String.class, String.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.LightweightFrame")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.util.Locale", "forLanguageTag", String.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WWindowPeer")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WWindowPeer", "notifyWindowStateChanged", Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WDesktopPeer")});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WFileDialogPeer")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WWindowPeer", "getActiveWindowHandles", Component.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WFileDialogPeer", "checkFilenameFilter", String.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WClipboard")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WFileDialogPeer", "handleSelected", char[].class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WClipboard", "lostSelectionOwnershipImpl", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "java.awt.event.KeyEvent", Component.class, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Character.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WFileDialogPeer", "isMultipleMode", new Class[0])});
        RuntimeJNIAccess.register((Class[])new Class[]{FileDialog.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "java.awt.FileDialog", "dir", "file", "filter", "mode"));
        RuntimeJNIAccess.register((Class[])new Class[]{Toolkit.class});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WInputMethod")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WFileDialogPeer", "setHWnd", Long.TYPE)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WFileDialogPeer", "handleCancel", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "sun.awt.windows.WInputMethod", "inquireCandidatePosition", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.Toolkit", "getFontMetrics", Font.class)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.awt.windows.WFileDialogPeer", "fileFilter", "parent"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.windows.WDialogPeer")});
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.Symbol")});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.awt.windows.WingDings", new Class[0])});
    }

    private static void registerJNIAccessForClassMembers(Feature.DuringAnalysisAccess access, BaseClassMemberRegistration memberRegistration) {
        String className = memberRegistration.getClassName();
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, className)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationUtil.fields((Feature.FeatureAccess)access, className, memberRegistration.getFields()));
        for (BaseClassMemberRegistration.MethodSignature m : memberRegistration.getMethods()) {
            String methodName = m.name();
            String methodSignature = m.signature();
            RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, className, methodName, JNIRegistrationAwt.readMethodSignature(methodSignature))});
        }
    }

    private static Class<?>[] readMethodSignature(String methodSignature) {
        SnippetSignature snippetSignature = new SnippetSignature(methodSignature);
        int parameterCount = snippetSignature.getParameterCount(false);
        Class[] paramTypes = new Class[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            JavaKind parameterKind = snippetSignature.getParameterKind(i);
            paramTypes[i] = parameterKind.toJavaClass();
        }
        return paramTypes;
    }
}

