/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.junit;

import com.oracle.mxtool.junit.MxJUnitRequest;
import com.oracle.svm.junit.SVMJUnitRunner;
import com.oracle.svm.util.ModuleSupport;
import java.util.function.BooleanSupplier;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Parameterized;
import org.junit.runners.ParentRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public final class JUnitFeature
implements Feature {
    public String getURL() {
        return "https://github.com/oracle/graal/blob/master/substratevm/src/com.oracle.svm.junit/src/com/oracle/svm/junit/JUnitFeature.java";
    }

    public String getDescription() {
        return "Enables JUnit support";
    }

    public static boolean isEnabledAndIncludesClass(Class<?> clazz) {
        if (ImageSingletons.contains(SVMJUnitRunner.class)) {
            Request request = ((SVMJUnitRunner)ImageSingletons.lookup(SVMJUnitRunner.class)).getJUnitRequest();
            return JUnitFeature.includesClass(request.getRunner().getDescription(), clazz);
        }
        return false;
    }

    private static boolean includesClass(Description dn, Class<?> clazz) {
        return clazz.equals(dn.getTestClass()) || dn.getChildren().stream().anyMatch(child -> JUnitFeature.includesClass(child, clazz));
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.EXPORT, null, (boolean)true, (String)"org.graalvm.nativeimage.builder", (String[])new String[0]);
        SVMJUnitRunner svmRunner = new SVMJUnitRunner((Feature.FeatureAccess)access);
        ImageSingletons.add(SVMJUnitRunner.class, (Object)svmRunner);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{SVMJUnitRunner.class});
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{Description.class});
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{ParentRunner.class});
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{Parameterized.class});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"jcp.xml.dsig.internal.dom.XMLDSigRI"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.runners.ParentRunner$1"});
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{Request.class});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.runner.Request$1"});
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{Runner.class});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"org.junit.runner.Runner$1"});
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{JUnitCore.class});
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{Suite.class});
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{BlockJUnit4ClassRunner.class});
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{FrameworkMethod.class});
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{TestClass.class});
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{FrameworkField.class});
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{Assert.class});
        RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{MxJUnitRequest.class});
    }

    public static class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(JUnitFeature.class);
        }
    }
}

