/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.junit;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.junit.JUnitFeature;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.junit.Assert;
import org.junit.runners.model.TestClass;

@TargetClass(className="org.junit.runners.model.TestClass", onlyWith={JUnitFeature.IsEnabled.class})
public final class Target_org_junit_runners_model_TestClass {
    @Alias
    Class<?> clazz;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=OnlyConstructorComputer.class)
    Constructor<?> onlyConstructor;

    @Substitute
    public Constructor<?> getOnlyConstructor() {
        if (this.onlyConstructor == null && this.clazz != null) {
            Constructor<?>[] constructors = this.clazz.getConstructors();
            Assert.assertEquals((long)1L, (long)constructors.length);
            return constructors[0];
        }
        return this.onlyConstructor;
    }

    public static final class OnlyConstructorComputer
    implements FieldValueTransformer {
        public Object transform(Object receiver, Object originalValue) {
            TestClass testClass = (TestClass)receiver;
            if (testClass.getJavaClass() != null) {
                RuntimeReflection.register((Class[])new Class[]{testClass.getJavaClass()});
                Constructor constructor = testClass.getOnlyConstructor();
                RuntimeReflection.register((Executable[])new Executable[]{constructor});
                return constructor;
            }
            return null;
        }
    }
}

