/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.dwarf;

import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.dwarf.DwarfSectionImpl;
import org.graalvm.compiler.debug.DebugContext;

public class DwarfAbbrevSectionImpl
extends DwarfSectionImpl {
    private final LayoutDecision.Kind[] targetSectionKinds = new LayoutDecision.Kind[]{LayoutDecision.Kind.CONTENT, LayoutDecision.Kind.SIZE};

    public DwarfAbbrevSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections);
    }

    @Override
    public String getSectionName() {
        return this.dwarfSections.abbrevSectionName();
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        int pos = 0;
        pos = this.writeAbbrevs(null, null, pos);
        byte[] buffer = new byte[pos];
        super.setContent(buffer);
    }

    @Override
    public void writeContent(DebugContext context) {
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int size = buffer.length;
        int pos = 0;
        this.enableLog(context, pos);
        pos = this.writeAbbrevs(context, buffer, pos);
        assert (pos == size);
    }

    public int writeAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeClassUnitAbbrev(context, buffer, pos);
        pos = this.writePrimitiveTypeAbbrev(context, buffer, pos);
        pos = this.writeVoidTypeAbbrev(context, buffer, pos);
        pos = this.writeObjectHeaderAbbrev(context, buffer, pos);
        pos = this.writeNamespaceAbbrev(context, buffer, pos);
        pos = this.writeClassLayoutAbbrevs(context, buffer, pos);
        pos = this.writeClassReferenceAbbrev(context, buffer, pos);
        pos = this.writeMethodDeclarationAbbrevs(context, buffer, pos);
        pos = this.writeFieldDeclarationAbbrevs(context, buffer, pos);
        pos = this.writeClassConstantAbbrev(context, buffer, pos);
        pos = this.writeArrayLayoutAbbrev(context, buffer, pos);
        pos = this.writeArrayReferenceAbbrev(context, buffer, pos);
        pos = this.writeInterfaceLayoutAbbrev(context, buffer, pos);
        pos = this.writeInterfaceReferenceAbbrev(context, buffer, pos);
        pos = this.writeHeaderFieldAbbrev(context, buffer, pos);
        pos = this.writeArrayDataTypeAbbrev(context, buffer, pos);
        pos = this.writeMethodLocationAbbrev(context, buffer, pos);
        pos = this.writeStaticFieldLocationAbbrev(context, buffer, pos);
        pos = this.writeSuperReferenceAbbrev(context, buffer, pos);
        pos = this.writeInterfaceImplementorAbbrev(context, buffer, pos);
        pos = this.writeInlinedSubroutineAbbrev(buffer, pos, false);
        pos = this.writeInlinedSubroutineAbbrev(buffer, pos, true);
        if (this.dwarfSections.useHeapBase()) {
            pos = this.writeIndirectLayoutAbbrev(context, buffer, pos);
            pos = this.writeIndirectReferenceAbbrev(context, buffer, pos);
        }
        pos = this.writeParameterDeclarationAbbrevs(context, buffer, pos);
        pos = this.writeLocalDeclarationAbbrevs(context, buffer, pos);
        pos = this.writeParameterLocationAbbrevs(context, buffer, pos);
        pos = this.writeLocalLocationAbbrevs(context, buffer, pos);
        pos = this.writeNullAbbrev(context, buffer, pos);
        return pos;
    }

    private int writeAttrType(long code, byte[] buffer, int pos) {
        return this.writeSLEB(code, buffer, pos);
    }

    private int writeAttrForm(long code, byte[] buffer, int pos) {
        return this.writeSLEB(code, buffer, pos);
    }

    private int writeClassUnitAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(1L, buffer, pos);
        pos = this.writeTag(17L, buffer, pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        pos = this.writeAttrType(19L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(83L, buffer, pos);
        pos = this.writeAttrForm(12L, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(27L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(17L, buffer, pos);
        pos = this.writeAttrForm(1L, buffer, pos);
        pos = this.writeAttrType(18L, buffer, pos);
        pos = this.writeAttrForm(1L, buffer, pos);
        pos = this.writeAttrType(16L, buffer, pos);
        pos = this.writeAttrForm(23L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writePrimitiveTypeAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(2L, buffer, pos);
        pos = this.writeTag(36L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(11L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(13L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(62L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeVoidTypeAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(3L, buffer, pos);
        pos = this.writeTag(59L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeObjectHeaderAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(4L, buffer, pos);
        pos = this.writeTag(19L, buffer, pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(11L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeNamespaceAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(5L, buffer, pos);
        pos = this.writeTag(57L, buffer, pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeClassLayoutAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeClassLayoutAbbrev(context, 6, buffer, pos);
        if (!this.dwarfSections.useHeapBase()) {
            pos = this.writeClassLayoutAbbrev(context, 7, buffer, pos);
        }
        return pos;
    }

    private int writeClassLayoutAbbrev(DebugContext context, int abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(2L, buffer, pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(11L, buffer, pos);
        pos = this.writeAttrForm(5L, buffer, pos);
        pos = this.writeAttrType(58L, buffer, pos);
        pos = this.writeAttrForm(5L, buffer, pos);
        if (abbrevCode == 7) {
            pos = this.writeAttrType(80L, buffer, pos);
            pos = this.writeAttrForm(24L, buffer, pos);
        }
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeClassReferenceAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(8L, buffer, pos);
        pos = this.writeTag(15L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(11L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(73L, buffer, pos);
        pos = this.writeAttrForm(16L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeMethodDeclarationAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeMethodDeclarationAbbrev(context, 17, buffer, pos);
        pos = this.writeMethodDeclarationAbbrev(context, 18, buffer, pos);
        return pos;
    }

    private int writeMethodDeclarationAbbrev(DebugContext context, int abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(46L, buffer, pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        pos = this.writeAttrType(63L, buffer, pos);
        pos = this.writeAttrForm(12L, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(58L, buffer, pos);
        pos = this.writeAttrForm(5L, buffer, pos);
        pos = this.writeAttrType(59L, buffer, pos);
        pos = this.writeAttrForm(5L, buffer, pos);
        pos = this.writeAttrType(110L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(73L, buffer, pos);
        pos = this.writeAttrForm(16L, buffer, pos);
        pos = this.writeAttrType(52L, buffer, pos);
        pos = this.writeAttrForm(12L, buffer, pos);
        pos = this.writeAttrType(50L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(60L, buffer, pos);
        pos = this.writeAttrForm(12L, buffer, pos);
        pos = this.writeAttrType(29L, buffer, pos);
        pos = this.writeAttrForm(16L, buffer, pos);
        if (abbrevCode == 17) {
            pos = this.writeAttrType(100L, buffer, pos);
            pos = this.writeAttrForm(16L, buffer, pos);
        }
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeFieldDeclarationAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeFieldDeclarationAbbrev(context, 19, buffer, pos);
        pos = this.writeFieldDeclarationAbbrev(context, 20, buffer, pos);
        pos = this.writeFieldDeclarationAbbrev(context, 21, buffer, pos);
        pos = this.writeFieldDeclarationAbbrev(context, 22, buffer, pos);
        return pos;
    }

    private int writeFieldDeclarationAbbrev(DebugContext context, int abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(13L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        if (abbrevCode == 20 || abbrevCode == 22) {
            pos = this.writeAttrType(58L, buffer, pos);
            pos = this.writeAttrForm(5L, buffer, pos);
        }
        pos = this.writeAttrType(73L, buffer, pos);
        pos = this.writeAttrForm(16L, buffer, pos);
        if (abbrevCode == 19 || abbrevCode == 20) {
            pos = this.writeAttrType(56L, buffer, pos);
            pos = this.writeAttrForm(5L, buffer, pos);
        }
        pos = this.writeAttrType(50L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        if (abbrevCode == 21 || abbrevCode == 22) {
            pos = this.writeAttrType(63L, buffer, pos);
            pos = this.writeAttrForm(12L, buffer, pos);
            pos = this.writeAttrType(60L, buffer, pos);
            pos = this.writeAttrForm(12L, buffer, pos);
        }
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeClassConstantAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(23L, buffer, pos);
        pos = this.writeTag(39L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(73L, buffer, pos);
        pos = this.writeAttrForm(16L, buffer, pos);
        pos = this.writeAttrType(50L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(63L, buffer, pos);
        pos = this.writeAttrForm(12L, buffer, pos);
        pos = this.writeAttrType(60L, buffer, pos);
        pos = this.writeAttrForm(12L, buffer, pos);
        pos = this.writeAttrType(2L, buffer, pos);
        pos = this.writeAttrForm(24L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeArrayLayoutAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(11L, buffer, pos);
        pos = this.writeTag(2L, buffer, pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(11L, buffer, pos);
        pos = this.writeAttrForm(5L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeArrayReferenceAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(12L, buffer, pos);
        pos = this.writeTag(15L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(11L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(73L, buffer, pos);
        pos = this.writeAttrForm(16L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeInterfaceLayoutAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(13L, buffer, pos);
        pos = this.writeTag(23L, buffer, pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeInterfaceReferenceAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(14L, buffer, pos);
        pos = this.writeTag(15L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(11L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(73L, buffer, pos);
        pos = this.writeAttrForm(16L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeInterfaceImplementorAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(27L, buffer, pos);
        pos = this.writeTag(13L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(73L, buffer, pos);
        pos = this.writeAttrForm(16L, buffer, pos);
        pos = this.writeAttrType(50L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeHeaderFieldAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(24L, buffer, pos);
        pos = this.writeTag(13L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(73L, buffer, pos);
        pos = this.writeAttrForm(16L, buffer, pos);
        pos = this.writeAttrType(56L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(50L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeArrayDataTypeAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(25L, buffer, pos);
        pos = this.writeTag(1L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(11L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(73L, buffer, pos);
        pos = this.writeAttrForm(16L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeMethodLocationAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(9L, buffer, pos);
        pos = this.writeTag(46L, buffer, pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        pos = this.writeAttrType(17L, buffer, pos);
        pos = this.writeAttrForm(1L, buffer, pos);
        pos = this.writeAttrType(18L, buffer, pos);
        pos = this.writeAttrForm(1L, buffer, pos);
        pos = this.writeAttrType(63L, buffer, pos);
        pos = this.writeAttrForm(12L, buffer, pos);
        pos = this.writeAttrType(71L, buffer, pos);
        pos = this.writeAttrForm(16L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeStaticFieldLocationAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(10L, buffer, pos);
        pos = this.writeTag(52L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(71L, buffer, pos);
        pos = this.writeAttrForm(19L, buffer, pos);
        pos = this.writeAttrType(2L, buffer, pos);
        pos = this.writeAttrForm(24L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeSuperReferenceAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(26L, buffer, pos);
        pos = this.writeTag(28L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(73L, buffer, pos);
        pos = this.writeAttrForm(16L, buffer, pos);
        pos = this.writeAttrType(56L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(50L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeIndirectLayoutAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(15L, buffer, pos);
        pos = this.writeTag(2L, buffer, pos);
        pos = this.writeFlag((byte)1, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        pos = this.writeAttrType(11L, buffer, pos);
        pos = this.writeAttrForm(5L, buffer, pos);
        pos = this.writeAttrType(80L, buffer, pos);
        pos = this.writeAttrForm(24L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeIndirectReferenceAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(16L, buffer, pos);
        pos = this.writeTag(15L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(11L, buffer, pos);
        pos = this.writeAttrForm(11L, buffer, pos);
        pos = this.writeAttrType(73L, buffer, pos);
        pos = this.writeAttrForm(16L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeParameterDeclarationAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeParameterDeclarationAbbrev(context, 30, buffer, pos);
        pos = this.writeParameterDeclarationAbbrev(context, 31, buffer, pos);
        pos = this.writeParameterDeclarationAbbrev(context, 32, buffer, pos);
        return pos;
    }

    private int writeParameterDeclarationAbbrev(DebugContext context, int abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(5L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        if (abbrevCode == 31) {
            pos = this.writeAttrType(58L, buffer, pos);
            pos = this.writeAttrForm(5L, buffer, pos);
            pos = this.writeAttrType(59L, buffer, pos);
            pos = this.writeAttrForm(5L, buffer, pos);
        }
        pos = this.writeAttrType(73L, buffer, pos);
        pos = this.writeAttrForm(16L, buffer, pos);
        if (abbrevCode == 30) {
            pos = this.writeAttrType(52L, buffer, pos);
            pos = this.writeAttrForm(12L, buffer, pos);
        }
        pos = this.writeAttrType(60L, buffer, pos);
        pos = this.writeAttrForm(12L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeLocalDeclarationAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeLocalDeclarationAbbrev(context, 33, buffer, pos);
        pos = this.writeLocalDeclarationAbbrev(context, 34, buffer, pos);
        return pos;
    }

    private int writeLocalDeclarationAbbrev(DebugContext context, int abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(52L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(3L, buffer, pos);
        pos = this.writeAttrForm(14L, buffer, pos);
        if (abbrevCode == 33) {
            pos = this.writeAttrType(58L, buffer, pos);
            pos = this.writeAttrForm(5L, buffer, pos);
            pos = this.writeAttrType(59L, buffer, pos);
            pos = this.writeAttrForm(5L, buffer, pos);
        }
        pos = this.writeAttrType(73L, buffer, pos);
        pos = this.writeAttrForm(16L, buffer, pos);
        pos = this.writeAttrType(60L, buffer, pos);
        pos = this.writeAttrForm(12L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeParameterLocationAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeParameterLocationAbbrev(context, 35, buffer, pos);
        pos = this.writeParameterLocationAbbrev(context, 36, buffer, pos);
        return pos;
    }

    private int writeLocalLocationAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeLocalLocationAbbrev(context, 37, buffer, pos);
        pos = this.writeLocalLocationAbbrev(context, 38, buffer, pos);
        return pos;
    }

    private int writeParameterLocationAbbrev(DebugContext context, int abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(5L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(49L, buffer, pos);
        pos = this.writeAttrForm(19L, buffer, pos);
        if (abbrevCode == 36) {
            pos = this.writeAttrType(2L, buffer, pos);
            pos = this.writeAttrForm(23L, buffer, pos);
        }
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeLocalLocationAbbrev(DebugContext context, int abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(52L, buffer, pos);
        pos = this.writeFlag((byte)0, buffer, pos);
        pos = this.writeAttrType(49L, buffer, pos);
        pos = this.writeAttrForm(19L, buffer, pos);
        if (abbrevCode == 38) {
            pos = this.writeAttrType(2L, buffer, pos);
            pos = this.writeAttrForm(23L, buffer, pos);
        }
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    private int writeNullAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(0L, buffer, pos);
        return pos;
    }

    private int writeInlinedSubroutineAbbrev(byte[] buffer, int p, boolean withChildren) {
        int pos = p;
        pos = this.writeAbbrevCode(withChildren ? 29L : 28L, buffer, pos);
        pos = this.writeTag(29L, buffer, pos);
        pos = this.writeFlag(withChildren ? (byte)1 : 0, buffer, pos);
        pos = this.writeAttrType(49L, buffer, pos);
        pos = this.writeAttrForm(19L, buffer, pos);
        pos = this.writeAttrType(17L, buffer, pos);
        pos = this.writeAttrForm(1L, buffer, pos);
        pos = this.writeAttrType(18L, buffer, pos);
        pos = this.writeAttrForm(1L, buffer, pos);
        pos = this.writeAttrType(88L, buffer, pos);
        pos = this.writeAttrForm(6L, buffer, pos);
        pos = this.writeAttrType(89L, buffer, pos);
        pos = this.writeAttrForm(6L, buffer, pos);
        pos = this.writeAttrType(0L, buffer, pos);
        pos = this.writeAttrForm(0L, buffer, pos);
        return pos;
    }

    @Override
    public String targetSectionName() {
        return this.dwarfSections.arangesSectionName();
    }

    @Override
    public LayoutDecision.Kind[] targetSectionKinds() {
        return this.targetSectionKinds;
    }
}

