/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.dwarf;

import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.debugentry.CompiledMethodEntry;
import com.oracle.objectfile.debugentry.DirEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.range.PrimaryRange;
import com.oracle.objectfile.debugentry.range.SubRange;
import com.oracle.objectfile.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.dwarf.DwarfSectionImpl;
import java.util.Iterator;
import java.util.Map;
import org.graalvm.compiler.debug.DebugContext;

public class DwarfLineSectionImpl
extends DwarfSectionImpl {
    private static final int DW_LN_HEADER_SIZE = 28;
    private static final int DW_LN_LINE_BASE = -5;
    private static final int DW_LN_LINE_RANGE = 14;
    private static final int DW_LN_OPCODE_BASE = 13;
    private static final byte DW_LNS_undefined = 0;
    private static final byte DW_LNS_extended_prefix = 0;
    private static final byte DW_LNS_copy = 1;
    private static final byte DW_LNS_advance_pc = 2;
    private static final byte DW_LNS_advance_line = 3;
    private static final byte DW_LNS_set_file = 4;
    private static final byte DW_LNS_set_column = 5;
    private static final byte DW_LNS_negate_stmt = 6;
    private static final byte DW_LNS_set_basic_block = 7;
    private static final byte DW_LNS_const_add_pc = 8;
    private static final byte DW_LNS_fixed_advance_pc = 9;
    private static final byte DW_LNS_set_prologue_end = 10;
    private static final byte DW_LNS_set_epilogue_begin = 11;
    private static final byte DW_LNE_undefined = 0;
    private static final byte DW_LNE_end_sequence = 1;
    private static final byte DW_LNE_set_address = 2;
    private static final byte DW_LNE_define_file = 3;
    private int linePrologueSize = 0;
    private long debugLine = 1L;
    private int debugCopyCount = 0;
    private static final int MAX_ADDRESS_ONLY_DELTA = 17;
    private static final int MAX_ADDPC_DELTA = 33;
    private final LayoutDecision.Kind[] targetSectionKinds = new LayoutDecision.Kind[]{LayoutDecision.Kind.CONTENT, LayoutDecision.Kind.SIZE};

    public DwarfLineSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections);
    }

    @Override
    public String getSectionName() {
        return this.dwarfSections.lineSectionName();
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        int headerSize = DwarfLineSectionImpl.headerSize();
        int dirTableSize = this.computeDirTableSize();
        int fileTableSize = this.computeFileTableSize();
        int prologueSize = headerSize + dirTableSize + fileTableSize;
        this.setLinePrologueSize(prologueSize);
        int lineNumberTableSize = this.computeLineNUmberTableSize();
        int totalSize = prologueSize + lineNumberTableSize;
        byte[] buffer = new byte[totalSize];
        super.setContent(buffer);
    }

    private static int headerSize() {
        return 28;
    }

    private int computeDirTableSize() {
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this);
        this.dirStream().forEach(dirEntry -> {
            if (dirEntry.getIdx() > 0) {
                cursor.add(DwarfLineSectionImpl.countUTF8Bytes(dirEntry.getPathString()) + 1);
            }
        });
        cursor.add(1);
        return cursor.get();
    }

    private int computeFileTableSize() {
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this);
        this.fileStream().forEach(fileEntry -> {
            String baseName = fileEntry.getFileName();
            int length = DwarfLineSectionImpl.countUTF8Bytes(baseName);
            assert (length > 0);
            cursor.add(length + 1);
            int dirIdx = fileEntry.getDirEntry().getIdx();
            cursor.add(this.writeULEB(dirIdx, scratch, 0));
            cursor.add(2);
        });
        cursor.add(1);
        return cursor.get();
    }

    private int computeLineNUmberTableSize() {
        return this.writeLineNumberTable(null, null, 0);
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        Object valueObj;
        ObjectFile.Element textElement = this.getElement().getOwner().elementForName(this.dwarfSections.textSectionName());
        LayoutDecisionMap decisionMap = alreadyDecided.get(textElement);
        if (decisionMap != null && (valueObj = decisionMap.getDecidedValue(LayoutDecision.Kind.VADDR)) != null && valueObj instanceof Number) {
            this.debugTextBase = ((Number)valueObj).longValue();
        }
        return super.getOrDecideContent(alreadyDecided, contentHint);
    }

    @Override
    public void writeContent(DebugContext context) {
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int pos = 0;
        this.enableLog(context, pos);
        this.log(context, "  [0x%08x] DEBUG_LINE", pos);
        pos = this.writeHeader(buffer, pos);
        this.log(context, "  [0x%08x] headerSize = 0x%08x", pos, pos);
        int dirTablePos = pos;
        pos = this.writeDirTable(context, buffer, pos);
        this.log(context, "  [0x%08x] dirTableSize = 0x%08x", pos, pos - dirTablePos);
        int fileTablePos = pos;
        pos = this.writeFileTable(context, buffer, pos);
        this.log(context, "  [0x%08x] fileTableSize = 0x%08x", pos, pos - fileTablePos);
        int lineNumberTablePos = pos;
        pos = this.writeLineNumberTable(context, buffer, pos);
        this.log(context, "  [0x%08x] lineNumberTableSize = 0x%x", pos, pos - lineNumberTablePos);
        this.log(context, "  [0x%08x] size = 0x%x", pos, pos);
        assert (pos == buffer.length);
    }

    private int writeHeader(byte[] buffer, int p) {
        int pos = p;
        pos = this.writeInt(buffer.length - 4, buffer, pos);
        pos = this.writeShort((short)4, buffer, pos);
        int prologueSize = this.getLinePrologueSize() - 10;
        pos = this.writeInt(prologueSize, buffer, pos);
        pos = this.writeByte((byte)1, buffer, pos);
        pos = this.writeByte((byte)1, buffer, pos);
        pos = this.writeByte((byte)1, buffer, pos);
        pos = this.writeByte((byte)-5, buffer, pos);
        pos = this.writeByte((byte)14, buffer, pos);
        pos = this.writeByte((byte)13, buffer, pos);
        this.writeByte((byte)0, buffer, pos);
        this.writeByte((byte)1, buffer, pos + 1);
        this.writeByte((byte)1, buffer, pos + 2);
        this.writeByte((byte)1, buffer, pos + 3);
        this.writeByte((byte)1, buffer, pos + 4);
        this.writeByte((byte)0, buffer, pos + 5);
        this.writeByte((byte)0, buffer, pos + 6);
        this.writeByte((byte)0, buffer, pos + 7);
        this.writeByte((byte)1, buffer, pos + 8);
        this.writeByte((byte)0, buffer, pos + 9);
        this.writeByte((byte)0, buffer, pos + 10);
        pos = this.writeByte((byte)1, buffer, pos + 11);
        return pos;
    }

    private int writeDirTable(DebugContext context, byte[] buffer, int p) {
        this.verboseLog(context, "  [0x%08x] Dir Name", p);
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this, p);
        this.dirStream().forEach(dirEntry -> {
            int dirIdx = dirEntry.getIdx();
            if (dirIdx > 0) {
                String dirPath = dirEntry.getPathString();
                this.verboseLog(context, "  [0x%08x] %-4d %s", cursor.get(), dirIdx, dirPath);
                cursor.set(this.writeUTF8StringBytes(dirPath, buffer, cursor.get()));
            }
        });
        cursor.set(this.writeByte((byte)0, buffer, cursor.get()));
        return cursor.get();
    }

    private int writeFileTable(DebugContext context, byte[] buffer, int p) {
        this.verboseLog(context, "  [0x%08x] Entry Dir  Name", p);
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this, p);
        this.fileStream().forEach(fileEntry -> {
            int pos = cursor.get();
            String baseName = fileEntry.getFileName();
            DirEntry dirEntry = fileEntry.getDirEntry();
            int fileIdx = fileEntry.getIdx();
            int dirIdx = dirEntry.getIdx();
            this.verboseLog(context, "  [0x%08x] %-5d %-5d %s", pos, fileIdx, dirIdx, baseName);
            pos = this.writeUTF8StringBytes(baseName, buffer, pos);
            pos = this.writeULEB(dirIdx, buffer, pos);
            pos = this.writeULEB(0L, buffer, pos);
            pos = this.writeULEB(0L, buffer, pos);
            cursor.set(pos);
        });
        cursor.set(this.writeByte((byte)0, buffer, cursor.get()));
        return cursor.get();
    }

    private int writeCompiledMethodLineInfo(DebugContext context, CompiledMethodEntry compiledEntry, byte[] buffer, int p) {
        FileEntry firstFileEntry;
        int pos = p;
        PrimaryRange primaryRange = compiledEntry.getPrimary();
        FileEntry fileEntry = primaryRange.getFileEntry();
        if (fileEntry == null) {
            this.log(context, "  [0x%08x] primary range [0x%08x, 0x%08x] skipped (no file) %s", pos, this.debugTextBase + primaryRange.getLo(), this.debugTextBase + primaryRange.getHi(), primaryRange.getFullMethodNameWithParams());
            return pos;
        }
        String file = fileEntry.getFileName();
        int fileIdx = fileEntry.getIdx();
        long line = primaryRange.getLine();
        long address = primaryRange.getLo();
        SubRange prologueRange = DwarfLineSectionImpl.prologueLeafRange(compiledEntry);
        if (prologueRange != null && (line = (long)prologueRange.getLine()) > 0L && (firstFileEntry = prologueRange.getFileEntry()) != null) {
            fileIdx = firstFileEntry.getIdx();
        }
        if (line < 0L) {
            line = 0L;
        }
        this.log(context, "  [0x%08x] primary range [0x%08x, 0x%08x] %s %s:%d", pos, this.debugTextBase + primaryRange.getLo(), this.debugTextBase + primaryRange.getHi(), primaryRange.getFullMethodNameWithParams(), file, primaryRange.getLine());
        pos = this.writeSetFileOp(context, file, fileIdx, buffer, pos);
        pos = this.writeSetBasicBlockOp(context, buffer, pos);
        pos = this.writeSetAddressOp(context, address, buffer, pos);
        if (line != 1L) {
            pos = this.writeAdvanceLineOp(context, line - 1L, buffer, pos);
        }
        pos = this.writeCopyOp(context, buffer, pos);
        Iterator<SubRange> iterator = compiledEntry.leafRangeIterator();
        if (prologueRange != null) {
            SubRange first = iterator.next();
            assert (first == prologueRange);
        }
        while (iterator.hasNext()) {
            long lineDelta;
            long addressDelta;
            byte opcode;
            SubRange subrange = iterator.next();
            assert (subrange.getLo() >= primaryRange.getLo());
            assert (subrange.getHi() <= primaryRange.getHi());
            FileEntry subFileEntry = subrange.getFileEntry();
            if (subFileEntry == null) continue;
            String subfile = subFileEntry.getFileName();
            int subFileIdx = subFileEntry.getIdx();
            assert (subFileIdx > 0);
            long subLine = subrange.getLine();
            long subAddressLo = subrange.getLo();
            long subAddressHi = subrange.getHi();
            this.log(context, "  [0x%08x] sub range [0x%08x, 0x%08x] %s %s:%d", pos, this.debugTextBase + subAddressLo, this.debugTextBase + subAddressHi, subrange.getFullMethodNameWithParams(), subfile, subLine);
            if (subLine < 0L) {
                subLine = line;
                subfile = file;
                subFileIdx = fileIdx;
                this.verboseLog(context, "  [0x%08x] missing line info - staying put at %s:%d", pos, file, line);
            }
            if (subFileIdx != fileIdx) {
                pos = this.writeSetFileOp(context, subfile, subFileIdx, buffer, pos);
                file = subfile;
                fileIdx = subFileIdx;
            }
            if ((opcode = DwarfLineSectionImpl.isSpecialOpcode(addressDelta = subAddressLo - address, lineDelta = subLine - line)) != 0) {
                if (addressDelta != 0L || lineDelta != 0L) {
                    pos = this.writeSpecialOpcode(context, opcode, buffer, pos);
                }
            } else {
                int remainder = DwarfLineSectionImpl.isConstAddPC(addressDelta);
                if (remainder > 0) {
                    pos = this.writeConstAddPCOp(context, buffer, pos);
                    opcode = DwarfLineSectionImpl.isSpecialOpcode(remainder, lineDelta);
                    if (opcode != 0) {
                        pos = this.writeSpecialOpcode(context, opcode, buffer, pos);
                    } else {
                        opcode = DwarfLineSectionImpl.isSpecialOpcode(remainder, 0L);
                        assert (opcode != 0);
                        pos = this.writeAdvanceLineOp(context, lineDelta, buffer, pos);
                        pos = this.writeSpecialOpcode(context, opcode, buffer, pos);
                    }
                } else {
                    if (lineDelta != 0L) {
                        pos = this.writeAdvanceLineOp(context, lineDelta, buffer, pos);
                    }
                    if (addressDelta > 0L) {
                        pos = DwarfLineSectionImpl.isFixedAdvancePC(addressDelta) ? this.writeFixedAdvancePCOp(context, (short)addressDelta, buffer, pos) : this.writeAdvancePCOp(context, addressDelta, buffer, pos);
                    }
                    pos = this.writeCopyOp(context, buffer, pos);
                }
            }
            line += lineDelta;
            address += addressDelta;
        }
        if (address < primaryRange.getHi()) {
            long addressDelta = primaryRange.getHi() - address;
            pos = this.writeAdvancePCOp(context, addressDelta, buffer, pos);
        }
        pos = this.writeEndSequenceOp(context, buffer, pos);
        return pos;
    }

    private int writeLineNumberTable(DebugContext context, byte[] buffer, int p) {
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this, p);
        this.compiledMethodsStream().forEach(compiledMethod -> {
            int pos = cursor.get();
            String methodName = compiledMethod.getPrimary().getFullMethodNameWithParams();
            String fileName = compiledMethod.getClassEntry().getFullFileName();
            this.log(context, "  [0x%08x] %s %s", pos, methodName, fileName);
            pos = this.writeCompiledMethodLineInfo(context, (CompiledMethodEntry)compiledMethod, buffer, pos);
            cursor.set(pos);
        });
        return cursor.get();
    }

    private static SubRange prologueLeafRange(CompiledMethodEntry compiledEntry) {
        SubRange range;
        Iterator<SubRange> iterator = compiledEntry.leafRangeIterator();
        if (iterator.hasNext() && (range = iterator.next()).getLo() == compiledEntry.getPrimary().getLo()) {
            return range;
        }
        return null;
    }

    private int writeCopyOp(DebugContext context, byte[] buffer, int p) {
        byte opcode = 1;
        int pos = p;
        ++this.debugCopyCount;
        this.verboseLog(context, "  [0x%08x] Copy %d", pos, this.debugCopyCount);
        return this.writeByte(opcode, buffer, pos);
    }

    private int writeAdvancePCOp(DebugContext context, long uleb, byte[] buffer, int p) {
        byte opcode = 2;
        int pos = p;
        this.debugAddress += uleb;
        this.verboseLog(context, "  [0x%08x] Advance PC by %d to 0x%08x", pos, uleb, this.debugAddress);
        pos = this.writeByte(opcode, buffer, pos);
        return this.writeULEB(uleb, buffer, pos);
    }

    private int writeAdvanceLineOp(DebugContext context, long sleb, byte[] buffer, int p) {
        byte opcode = 3;
        int pos = p;
        this.debugLine += sleb;
        this.verboseLog(context, "  [0x%08x] Advance Line by %d to %d", pos, sleb, this.debugLine);
        pos = this.writeByte(opcode, buffer, pos);
        return this.writeSLEB(sleb, buffer, pos);
    }

    private int writeSetFileOp(DebugContext context, String file, long uleb, byte[] buffer, int p) {
        byte opcode = 4;
        int pos = p;
        this.verboseLog(context, "  [0x%08x] Set File Name to entry %d in the File Name Table (%s)", pos, uleb, file);
        pos = this.writeByte(opcode, buffer, pos);
        return this.writeULEB(uleb, buffer, pos);
    }

    private int writeSetColumnOp(DebugContext context, long uleb, byte[] buffer, int p) {
        byte opcode = 5;
        int pos = p;
        pos = this.writeByte(opcode, buffer, pos);
        return this.writeULEB(uleb, buffer, pos);
    }

    private int writeNegateStmtOp(DebugContext context, byte[] buffer, int p) {
        byte opcode = 6;
        int pos = p;
        return this.writeByte(opcode, buffer, pos);
    }

    private int writeSetBasicBlockOp(DebugContext context, byte[] buffer, int p) {
        byte opcode = 7;
        int pos = p;
        this.verboseLog(context, "  [0x%08x] Set basic block", pos);
        return this.writeByte(opcode, buffer, pos);
    }

    private int writeConstAddPCOp(DebugContext context, byte[] buffer, int p) {
        byte opcode = 8;
        int pos = p;
        int advance = DwarfLineSectionImpl.opcodeAddress((byte)-1);
        this.debugAddress += (long)advance;
        this.verboseLog(context, "  [0x%08x] Advance PC by constant %d to 0x%08x", pos, advance, this.debugAddress);
        return this.writeByte(opcode, buffer, pos);
    }

    private int writeFixedAdvancePCOp(DebugContext context, short arg, byte[] buffer, int p) {
        byte opcode = 9;
        int pos = p;
        this.debugAddress += (long)arg;
        this.verboseLog(context, "  [0x%08x] Fixed advance Address by %d to 0x%08x", pos, arg, this.debugAddress);
        pos = this.writeByte(opcode, buffer, pos);
        return this.writeShort(arg, buffer, pos);
    }

    private int writeEndSequenceOp(DebugContext context, byte[] buffer, int p) {
        byte opcode = 1;
        int pos = p;
        this.verboseLog(context, "  [0x%08x] Extended opcode 1: End sequence", pos);
        this.debugAddress = this.debugTextBase;
        this.debugLine = 1L;
        this.debugCopyCount = 0;
        pos = this.writeByte((byte)0, buffer, pos);
        pos = this.writeULEB(1L, buffer, pos);
        return this.writeByte(opcode, buffer, pos);
    }

    private int writeSetAddressOp(DebugContext context, long arg, byte[] buffer, int p) {
        byte opcode = 2;
        int pos = p;
        this.debugAddress = this.debugTextBase + (long)((int)arg);
        this.verboseLog(context, "  [0x%08x] Extended opcode 2: Set Address to 0x%08x", pos, this.debugAddress);
        pos = this.writeByte((byte)0, buffer, pos);
        pos = this.writeULEB(9L, buffer, pos);
        pos = this.writeByte(opcode, buffer, pos);
        return this.writeRelocatableCodeOffset(arg, buffer, pos);
    }

    private int writeDefineFileOp(DebugContext context, String file, long uleb1, long uleb2, long uleb3, byte[] buffer, int p) {
        byte opcode = 3;
        int pos = p;
        int fileBytes = DwarfLineSectionImpl.countUTF8Bytes(file) + 1;
        long insnBytes = 1L;
        insnBytes += (long)fileBytes;
        insnBytes += (long)this.writeULEB(uleb1, scratch, 0);
        insnBytes += (long)this.writeULEB(uleb2, scratch, 0);
        this.verboseLog(context, "  [0x%08x] Extended opcode 3: Define File %s idx %d ts1 %d ts2 %d", pos, file, uleb1, uleb2, uleb3);
        pos = this.writeByte((byte)0, buffer, pos);
        pos = this.writeULEB(insnBytes += (long)this.writeULEB(uleb3, scratch, 0), buffer, pos);
        pos = this.writeByte(opcode, buffer, pos);
        pos = this.writeUTF8StringBytes(file, buffer, pos);
        pos = this.writeULEB(uleb1, buffer, pos);
        pos = this.writeULEB(uleb2, buffer, pos);
        return this.writeULEB(uleb3, buffer, pos);
    }

    private static int opcodeId(byte opcode) {
        int iopcode = opcode & 0xFF;
        return iopcode - 13;
    }

    private static int opcodeAddress(byte opcode) {
        int iopcode = opcode & 0xFF;
        return (iopcode - 13) / 14;
    }

    private static int opcodeLine(byte opcode) {
        int iopcode = opcode & 0xFF;
        return (iopcode - 13) % 14 + -5;
    }

    private int writeSpecialOpcode(DebugContext context, byte opcode, byte[] buffer, int p) {
        int pos = p;
        if (this.debug && opcode == 0) {
            this.verboseLog(context, "  [0x%08x] ERROR Special Opcode %d: Address 0x%08x Line %d", this.debugAddress, this.debugLine);
        }
        this.debugAddress += (long)DwarfLineSectionImpl.opcodeAddress(opcode);
        this.debugLine += (long)DwarfLineSectionImpl.opcodeLine(opcode);
        this.verboseLog(context, "  [0x%08x] Special Opcode %d: advance Address by %d to 0x%08x and Line by %d to %d", pos, DwarfLineSectionImpl.opcodeId(opcode), DwarfLineSectionImpl.opcodeAddress(opcode), this.debugAddress, DwarfLineSectionImpl.opcodeLine(opcode), this.debugLine);
        return this.writeByte(opcode, buffer, pos);
    }

    private static byte isSpecialOpcode(long addressDelta, long lineDelta) {
        long opcode;
        long offsetLineDelta;
        if (addressDelta < 0L) {
            return 0;
        }
        if (lineDelta >= -5L && (offsetLineDelta = lineDelta - -5L) < 14L && addressDelta <= 17L && (opcode = 13L + addressDelta * 14L + offsetLineDelta) <= 255L) {
            return (byte)opcode;
        }
        return 0;
    }

    private static int isConstAddPC(long addressDelta) {
        if (addressDelta < 17L) {
            return 0;
        }
        if (addressDelta <= 33L) {
            return (int)(addressDelta - 17L);
        }
        return 0;
    }

    private static boolean isFixedAdvancePC(long addressDiff) {
        return addressDiff >= 0L && addressDiff < 65535L;
    }

    protected int getLinePrologueSize() {
        return this.linePrologueSize;
    }

    protected void setLinePrologueSize(int size) {
        assert (this.linePrologueSize == 0) : "prologue size set twice!";
        this.linePrologueSize = size;
    }

    @Override
    public String targetSectionName() {
        return this.dwarfSections.strSectionName();
    }

    @Override
    public LayoutDecision.Kind[] targetSectionKinds() {
        return this.targetSectionKinds;
    }
}

