/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.mxtool.junit;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FindClassesByAnnotatedMethods {
    private static final int MAJOR_VERSION_JAVA6 = 50;
    private static final int MAJOR_VERSION_OFFSET = 44;
    private static final byte CONSTANT_Utf8 = 1;
    private static final byte CONSTANT_Integer = 3;
    private static final byte CONSTANT_Float = 4;
    private static final byte CONSTANT_Long = 5;
    private static final byte CONSTANT_Double = 6;
    private static final byte CONSTANT_Class = 7;
    private static final byte CONSTANT_Fieldref = 9;
    private static final byte CONSTANT_String = 8;
    private static final byte CONSTANT_Methodref = 10;
    private static final byte CONSTANT_InterfaceMethodref = 11;
    private static final byte CONSTANT_NameAndType = 12;
    private static final byte CONSTANT_MethodHandle = 15;
    private static final byte CONSTANT_MethodType = 16;
    private static final byte CONSTANT_Dynamic = 17;
    private static final byte CONSTANT_InvokeDynamic = 18;
    private static final byte CONSTANT_Module = 19;
    private static final byte CONSTANT_Package = 20;

    public static void main(String ... args) throws Throwable {
        HashSet<String> qualifiedAnnotations = new HashSet<String>();
        HashSet<String> unqualifiedAnnotations = new HashSet<String>();
        for (String arg : args) {
            if (!FindClassesByAnnotatedMethods.isAnnotationArg(arg)) continue;
            String annotation = arg.substring(1);
            int lastDot = annotation.lastIndexOf(46);
            if (lastDot != -1) {
                qualifiedAnnotations.add(annotation);
                continue;
            }
            String unqualifed = annotation.substring(lastDot + 1);
            unqualifiedAnnotations.add(unqualifed);
        }
        for (String jarFilePath : args) {
            if (FindClassesByAnnotatedMethods.isSnippetArg(jarFilePath) || FindClassesByAnnotatedMethods.isAnnotationArg(jarFilePath)) continue;
            List<ClassFile> classfiles = FindClassesByAnnotatedMethods.findClassfiles(jarFilePath);
            int unsupportedClasses = 0;
            System.out.print(jarFilePath);
            for (ClassFile cf : classfiles) {
                HashSet<String> methodAnnotationTypes = new HashSet<String>();
                boolean isSupported = true;
                try (DataInputStream stream = new DataInputStream(new ByteArrayInputStream(cf.getBytes()));){
                    FindClassesByAnnotatedMethods.readClassfile(stream, methodAnnotationTypes);
                }
                catch (UnsupportedClassVersionError ucve) {
                    isSupported = false;
                    ++unsupportedClasses;
                }
                catch (Throwable t) {
                    throw new InternalError("Error while parsing class from " + cf + " in " + jarFilePath, t);
                }
                String className = cf.getName().substring(0, cf.getName().length() - ".class".length()).replaceAll("/", ".");
                if (!isSupported) {
                    System.out.print(File.pathSeparator + "!" + className);
                }
                for (String annotationType : methodAnnotationTypes) {
                    int lastDot;
                    if (!qualifiedAnnotations.isEmpty() && qualifiedAnnotations.contains(annotationType)) {
                        System.out.print(File.pathSeparator + className);
                    }
                    if (unqualifiedAnnotations.isEmpty() || (lastDot = annotationType.lastIndexOf(46)) == -1) continue;
                    String simpleName = annotationType.substring(lastDot + 1);
                    int lastDollar = simpleName.lastIndexOf(36);
                    if (lastDollar != -1) {
                        simpleName = simpleName.substring(lastDollar + 1);
                    }
                    if (!unqualifiedAnnotations.contains(simpleName)) continue;
                    System.out.print(File.pathSeparator + className);
                }
            }
            if (unsupportedClasses != 0) {
                System.err.printf("Warning: %d classes in %s skipped as their class file version is not supported by %s%n", unsupportedClasses, jarFilePath, FindClassesByAnnotatedMethods.class.getSimpleName());
            }
            System.out.println();
        }
    }

    private static List<ClassFile> findClassfiles(String jarFilePath) throws IOException {
        ArrayList<ClassFile> classfiles = new ArrayList<ClassFile>();
        if (!new File(jarFilePath).isDirectory()) {
            JarFile jarFile = new JarFile(jarFilePath);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                if (je.isDirectory() || !je.getName().endsWith(".class") || je.getName().equals("module-info.class")) continue;
                classfiles.add(new JarClassFile(jarFile, je));
            }
        } else {
            Path root = Paths.get(jarFilePath, new String[0]);
            Files.walk(root, new FileVisitOption[0]).forEach(p -> {
                String name = p.toString();
                if (name.endsWith(".class") && !name.equals("module-info.class")) {
                    classfiles.add(new DirClassFile(jarFilePath, root.relativize((Path)p).toString()));
                }
            });
        }
        return classfiles;
    }

    private static boolean isAnnotationArg(String arg) {
        return arg.charAt(0) == '@';
    }

    private static boolean isSnippetArg(String arg) {
        return arg.startsWith("snippetsPattern:");
    }

    private static void readClassfile(DataInputStream stream, Collection<String> methodAnnotationTypes) throws IOException {
        int majorJavaVersion;
        int magic = stream.readInt();
        assert (magic == -889275714);
        int minor = stream.readUnsignedShort();
        int major = stream.readUnsignedShort();
        if (major < 50) {
            throw new UnsupportedClassVersionError("Unsupported class file version: " + major + "." + minor);
        }
        String javaVersion = System.getProperties().get("java.specification.version").toString();
        if (javaVersion.startsWith("1.")) {
            javaVersion = javaVersion.substring(2);
            majorJavaVersion = Integer.parseInt(javaVersion);
        } else {
            majorJavaVersion = Integer.parseInt(javaVersion);
        }
        if (major > 44 + majorJavaVersion) {
            throw new UnsupportedClassVersionError("Unsupported class file version: " + major + "." + minor);
        }
        String[] cp = FindClassesByAnnotatedMethods.readConstantPool(stream, major, minor);
        stream.skipBytes(6);
        stream.skipBytes(stream.readUnsignedShort() * 2);
        FindClassesByAnnotatedMethods.skipFields(stream);
        FindClassesByAnnotatedMethods.readMethods(stream, cp, methodAnnotationTypes);
    }

    private static void skipFully(DataInputStream stream, int n) throws IOException {
        long skipped = 0L;
        do {
            long s;
            if ((s = stream.skip((long)n - skipped)) != 0L || (skipped += s) == (long)n) continue;
            if (stream.read() == -1) {
                throw new IOException("truncated stream");
            }
            ++skipped;
        } while (skipped != (long)n);
    }

    private static String[] readConstantPool(DataInputStream stream, int major, int minor) throws IOException {
        int count = stream.readUnsignedShort();
        String[] cp = new String[count];
        int i = 1;
        while (i < count) {
            byte tag = stream.readByte();
            switch (tag) {
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    FindClassesByAnnotatedMethods.skipFully(stream, 2);
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 17: 
                case 18: {
                    FindClassesByAnnotatedMethods.skipFully(stream, 4);
                    break;
                }
                case 5: 
                case 6: {
                    FindClassesByAnnotatedMethods.skipFully(stream, 8);
                    break;
                }
                case 1: {
                    cp[i] = stream.readUTF();
                    break;
                }
                case 15: {
                    FindClassesByAnnotatedMethods.skipFully(stream, 3);
                    break;
                }
                default: {
                    throw new InternalError(String.format("Invalid constant pool tag: " + tag + ". Maybe %s needs updating for changes introduced by class file version %d.%d?", FindClassesByAnnotatedMethods.class, major, minor));
                }
            }
            if (tag == 6 || tag == 5) {
                i += 2;
                continue;
            }
            ++i;
        }
        return cp;
    }

    private static void skipAttributes(DataInputStream stream) throws IOException {
        int attributesCount = stream.readUnsignedShort();
        for (int i = 0; i < attributesCount; ++i) {
            stream.skipBytes(2);
            int attributeLength = stream.readInt();
            FindClassesByAnnotatedMethods.skipFully(stream, attributeLength);
        }
    }

    private static void readMethodAttributes(DataInputStream stream, String[] cp, Collection<String> methodAnnotationTypes) throws IOException {
        int attributesCount = stream.readUnsignedShort();
        for (int i = 0; i < attributesCount; ++i) {
            String attributeName = cp[stream.readUnsignedShort()];
            int attributeLength = stream.readInt();
            if (attributeName.equals("RuntimeVisibleAnnotations")) {
                int numAnnotations = stream.readUnsignedShort();
                for (int a = 0; a != numAnnotations; ++a) {
                    FindClassesByAnnotatedMethods.readAnnotation(stream, cp, methodAnnotationTypes);
                }
                continue;
            }
            FindClassesByAnnotatedMethods.skipFully(stream, attributeLength);
        }
    }

    private static void readAnnotation(DataInputStream stream, String[] cp, Collection<String> methodAnnotationTypes) throws IOException {
        int typeIndex = stream.readUnsignedShort();
        int pairs = stream.readUnsignedShort();
        String type = cp[typeIndex];
        String className = type.substring(1, type.length() - 1).replace('/', '.');
        methodAnnotationTypes.add(className);
        FindClassesByAnnotatedMethods.readAnnotationElements(stream, cp, pairs, true, methodAnnotationTypes);
    }

    private static void readAnnotationElements(DataInputStream stream, String[] cp, int pairs, boolean withElementName, Collection<String> methodAnnotationTypes) throws IOException {
        block6: for (int p = 0; p < pairs; ++p) {
            if (withElementName) {
                FindClassesByAnnotatedMethods.skipFully(stream, 2);
            }
            byte tag = stream.readByte();
            switch (tag) {
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 73: 
                case 74: 
                case 83: 
                case 90: 
                case 99: 
                case 115: {
                    FindClassesByAnnotatedMethods.skipFully(stream, 2);
                    continue block6;
                }
                case 101: {
                    FindClassesByAnnotatedMethods.skipFully(stream, 4);
                    continue block6;
                }
                case 64: {
                    FindClassesByAnnotatedMethods.readAnnotation(stream, cp, methodAnnotationTypes);
                    continue block6;
                }
                case 91: {
                    int numValues = stream.readUnsignedShort();
                    FindClassesByAnnotatedMethods.readAnnotationElements(stream, cp, numValues, false, methodAnnotationTypes);
                    continue block6;
                }
            }
        }
    }

    private static void skipFields(DataInputStream stream) throws IOException {
        int count = stream.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            stream.skipBytes(6);
            FindClassesByAnnotatedMethods.skipAttributes(stream);
        }
    }

    private static void readMethods(DataInputStream stream, String[] cp, Collection<String> methodAnnotationTypes) throws IOException {
        int count = stream.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            FindClassesByAnnotatedMethods.skipFully(stream, 6);
            FindClassesByAnnotatedMethods.readMethodAttributes(stream, cp, methodAnnotationTypes);
        }
    }

    static interface ClassFile {
        public byte[] getBytes() throws IOException;

        public String getName();

        default public byte[] readFully(InputStream in, byte[] bytes) throws IOException {
            new DataInputStream(in).readFully(bytes);
            return bytes;
        }
    }

    static class JarClassFile
    implements ClassFile {
        private final JarFile jarFile;
        private final JarEntry je;

        JarClassFile(JarFile jarFile, JarEntry je) {
            this.jarFile = jarFile;
            this.je = je;
        }

        @Override
        public byte[] getBytes() throws IOException {
            try (InputStream in = this.jarFile.getInputStream(this.je);){
                byte[] byArray = this.readFully(in, new byte[(int)this.je.getSize()]);
                return byArray;
            }
        }

        @Override
        public String getName() {
            return this.je.getName();
        }
    }

    static class DirClassFile
    implements ClassFile {
        private final String name;
        private final File file;

        DirClassFile(String directory, String name) {
            this.name = name;
            this.file = new File(directory, name);
        }

        @Override
        public byte[] getBytes() throws IOException {
            try (FileInputStream in = new FileInputStream(this.file);){
                byte[] byArray = this.readFully(in, new byte[(int)this.file.length()]);
                return byArray;
            }
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

