/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.mxtool.junit;

import com.oracle.mxtool.junit.MxRunListener;
import com.oracle.mxtool.junit.MxRunListenerDecorator;
import com.oracle.mxtool.junit.TimingAndDiskUsageDecorator;
import java.io.PrintStream;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.junit.runner.notification.Failure;

public class FullThreadDumpDecorator
extends MxRunListenerDecorator {
    private static final String TEST_TIMED_OUT = "test timed out";

    FullThreadDumpDecorator(MxRunListener l) {
        super(l);
    }

    @Override
    public void testFailed(Failure failure) {
        super.testFailed(failure);
        String message = failure.getMessage();
        if (message != null && message.startsWith(TEST_TIMED_OUT)) {
            FullThreadDumpDecorator.printFullThreadDump(this.getWriter());
        }
    }

    static void printFullThreadDump(PrintStream out) {
        long[] threadIds;
        ThreadInfo[] allThreads;
        out.println("\nDUMPING ALL THREADS ON TIMEOUT:\n");
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo ti : allThreads = threadBean.dumpAllThreads(true, true)) {
            FullThreadDumpDecorator.dumpThread(threadBean, ti, out);
        }
        if (threadBean.isSynchronizerUsageSupported() && (threadIds = threadBean.findDeadlockedThreads()) != null) {
            ThreadInfo[] deadlockedThreads;
            out.println("Found Java-level deadlock:");
            for (ThreadInfo ti : deadlockedThreads = threadBean.getThreadInfo(threadIds)) {
                FullThreadDumpDecorator.dumpThread(threadBean, ti, out);
            }
        }
    }

    private static void dumpThread(ThreadMXBean threadBean, ThreadInfo ti, PrintStream out) {
        long id = ti.getThreadId();
        Thread.State state = ti.getThreadState();
        boolean haveCPUTime = threadBean.isThreadCpuTimeSupported() && threadBean.isThreadCpuTimeEnabled();
        boolean haveElapsedTime = haveCPUTime && threadBean.isThreadContentionMonitoringSupported() && threadBean.isThreadContentionMonitoringEnabled();
        String threadHeader = String.format("\"%s\" %s prio=%d cpu=%s elapsed=%s tid=%d %s\n   java.lang.Thread.State: %s", ti.getThreadName(), ti.isDaemon() ? "daemon" : "", ti.getPriority(), haveCPUTime ? TimingAndDiskUsageDecorator.valueToString(threadBean.getThreadCpuTime(id)) : "N/A", haveElapsedTime ? TimingAndDiskUsageDecorator.valueToString(threadBean.getThreadCpuTime(id) + (ti.getBlockedTime() + ti.getWaitedTime()) * 1000000L) : "N/A", id, state.name().toLowerCase(), state.name());
        out.println(threadHeader);
        StackTraceElement[] stackTrace = ti.getStackTrace();
        MonitorInfo[] monitors = ti.getLockedMonitors();
        LockInfo[] synchronizers = ti.getLockedSynchronizers();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String frame = String.format("\tat %s", stackTraceElement);
            out.println(frame);
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != i) continue;
                out.println("\t- locked " + mi);
            }
        }
        if (synchronizers.length > 0) {
            out.println("\n   Locked ownable synchronizers:");
            for (LockInfo li : synchronizers) {
                out.println("\t- " + li);
            }
        }
        out.println();
    }
}

