/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.mxtool.junit;

import com.oracle.mxtool.junit.MxRunListener;
import com.oracle.mxtool.junit.MxRunListenerDecorator;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class JsonResultsDecorator
extends MxRunListenerDecorator {
    private final PrintStream output;
    private boolean hasContent;
    private long startTime;
    private final List<TestResult> testResults = new ArrayList<TestResult>();

    JsonResultsDecorator(MxRunListener l, PrintStream output) {
        super(l);
        this.output = output;
    }

    @Override
    public void testRunStarted(Description description) {
        super.testRunStarted(description);
    }

    @Override
    public void testRunFinished(Result result) {
        super.testRunFinished(result);
        this.outputTestResults();
        this.output.close();
    }

    @Override
    public void testSucceeded(Description description) {
        super.testSucceeded(description);
        String result = "SUCCESS";
        long duration = System.nanoTime() - this.startTime;
        this.testResults.add(new TestResult(description.getDisplayName(), result, duration));
    }

    @Override
    public void testFailed(Failure failure) {
        super.testFailed(failure);
        String result = "FAILED";
        long duration = System.nanoTime() - this.startTime;
        this.testResults.add(new TestResult(failure.getDescription().getDisplayName(), result, duration));
    }

    @Override
    public void testIgnored(Description description) {
        super.testIgnored(description);
        String result = "IGNORED";
        long duration = System.nanoTime() - this.startTime;
        this.testResults.add(new TestResult(description.getDisplayName(), result, duration));
    }

    @Override
    public void testStarted(Description description) {
        super.testStarted(description);
        this.startTime = System.nanoTime();
    }

    @Override
    public void testClassStarted(Class<?> clazz) {
        super.testClassStarted(clazz);
    }

    private void outputTestResults() {
        if (this.hasContent) {
            this.output.print(',');
        }
        this.output.print("[");
        for (int i = 0; i < this.testResults.size(); ++i) {
            this.output.print("{\"name\":\"");
            this.output.print(JsonResultsDecorator.escape(this.testResults.get((int)i).description));
            this.output.print("\", \"status\":\"");
            this.output.print(this.testResults.get((int)i).result);
            this.output.print("\", \"duration\":\"");
            this.output.print(String.format("%.2f", Float.valueOf((float)this.testResults.get((int)i).duration / 1000000.0f)));
            if (i == this.testResults.size() - 1) {
                this.output.print("\"}");
                break;
            }
            this.output.print("\"},");
        }
        this.output.print("]");
        this.hasContent = true;
    }

    private static String escape(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c != '\\' && c != '\"' && c <= '\u007f') continue;
            return JsonResultsDecorator.escape(s, i);
        }
        return s;
    }

    private static String escape(String s, int start) {
        int lengthEstimate = (int)((float)s.length() * 1.1f) + 5;
        StringBuilder sb = new StringBuilder(lengthEstimate);
        sb.append(s, 0, start);
        block9: for (int i = start; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c > '\u007f') {
                        sb.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static class TestResult {
        final String description;
        final String result;
        final long duration;

        TestResult(String description, String result, long duration) {
            this.description = description;
            this.result = result;
            this.duration = duration;
        }
    }
}

