/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.mxtool.junit;

import com.oracle.mxtool.junit.MxRunListener;
import com.oracle.mxtool.junit.MxRunListenerDecorator;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.runner.Description;

class TimingAndDiskUsageDecorator
extends MxRunListenerDecorator {
    private long startTime;
    private long classStartTime;
    private Description currentTest;
    final Map<Class<?>, Long> classTimes = new ConcurrentHashMap();
    final Map<Description, Long> testTimes = new ConcurrentHashMap<Description, Long>();
    private final FileStore fileStore;
    private final String totalDiskSpace;
    private static final String[] SIZE_UNITS = new String[]{"", "K", "M", "G"};

    TimingAndDiskUsageDecorator(MxRunListener l) {
        super(l);
        FileStore fs;
        this.fileStore = fs = TimingAndDiskUsageDecorator.initFileStore();
        this.totalDiskSpace = fs == null ? null : TimingAndDiskUsageDecorator.initTotalDiskSpace(fs);
    }

    @Override
    public void testClassStarted(Class<?> clazz) {
        this.classStartTime = System.nanoTime();
        super.testClassStarted(clazz);
    }

    @Override
    public void testClassFinished(Class<?> clazz, int numPassed, int numFailed, int numIgnored, int numAssumptionFailed) {
        long totalTime = System.nanoTime() - this.classStartTime;
        super.testClassFinished(clazz, numPassed, numFailed, numIgnored, numAssumptionFailed);
        if (this.beVerbose()) {
            this.getWriter().print(' ' + TimingAndDiskUsageDecorator.valueToString(totalTime) + this.getDiskStats());
        }
        this.classTimes.put(clazz, totalTime / 1000000L);
    }

    @Override
    public void testStarted(Description description) {
        this.currentTest = description;
        this.startTime = System.nanoTime();
        super.testStarted(description);
    }

    @Override
    public void testFinished(Description description) {
        long totalTime = System.nanoTime() - this.startTime;
        super.testFinished(description);
        if (this.beVerbose()) {
            this.getWriter().print(" " + TimingAndDiskUsageDecorator.valueToString(totalTime));
        }
        this.currentTest = null;
        this.testTimes.put(description, totalTime / 1000000L);
    }

    static String valueToString(long valueNS) {
        long timeWholeMS = valueNS / 1000000L;
        long timeFractionMS = valueNS / 100000L % 10L;
        return String.format("%d.%d ms", timeWholeMS, timeFractionMS);
    }

    public Object[] getCurrentTestDuration() {
        Description current = this.currentTest;
        if (current != null) {
            long timeMS = (System.nanoTime() - this.startTime) / 1000000L;
            return new Object[]{current, timeMS};
        }
        return null;
    }

    static String humanFormat(long num) {
        double n = num;
        for (String unit : SIZE_UNITS) {
            if (Math.abs(n) < 1024.0) {
                return String.format("%3.1f%sB", n, unit);
            }
            n /= 1024.0;
        }
        return String.format("%.1fTB", n);
    }

    private String getDiskStats() {
        String diskStats = "";
        if (this.fileStore != null) {
            try {
                diskStats = String.format(", [disk (free/total): %s/%s]", TimingAndDiskUsageDecorator.humanFormat(this.fileStore.getUnallocatedSpace()), this.totalDiskSpace);
            }
            catch (IOException e) {
                diskStats = String.format(", [disk (free/total): %s]", e);
            }
        }
        return diskStats;
    }

    private static FileStore initFileStore() {
        FileStore fs = null;
        try {
            fs = Files.getFileStore(Paths.get(".", new String[0]));
        }
        catch (IOException e) {
            System.err.printf("Could not obtain FileStore for %s: %s%n", Paths.get(".", new String[0]).toAbsolutePath(), e);
        }
        return fs;
    }

    private static String initTotalDiskSpace(FileStore fs) {
        try {
            return TimingAndDiskUsageDecorator.humanFormat(fs.getTotalSpace());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

