// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: SerialGCOptions.java
package com.oracle.svm.core.genscavenge;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;

public class SerialGCOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "CollectYoungGenerationSeparately": {
            return OptionDescriptor.create(
                /*name*/ "CollectYoungGenerationSeparately",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if a full GC collects the young generation separately or together with the old generation. Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "CollectYoungGenerationSeparately",
                /*option*/ SerialGCOptions.CollectYoungGenerationSeparately,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CountWriteBarriers": {
            return OptionDescriptor.create(
                /*name*/ "CountWriteBarriers",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Instrument write barriers with counters. Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "CountWriteBarriers",
                /*option*/ SerialGCOptions.CountWriteBarriers,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GreyToBlackObjRefDemographics": {
            return OptionDescriptor.create(
                /*name*/ "GreyToBlackObjRefDemographics",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Develop demographics of the object references visited. Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "GreyToBlackObjRefDemographics",
                /*option*/ SerialGCOptions.GreyToBlackObjRefDemographics,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ImageHeapCardMarking": {
            return OptionDescriptor.create(
                /*name*/ "ImageHeapCardMarking",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables card marking for image heap objects, which arranges them in chunks. Automatically enabled when supported. Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "ImageHeapCardMarking",
                /*option*/ SerialGCOptions.ImageHeapCardMarking,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InitialCollectionPolicy": {
            return OptionDescriptor.create(
                /*name*/ "InitialCollectionPolicy",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "The garbage collection policy, either Adaptive (default) or BySpaceAndTime. Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "InitialCollectionPolicy",
                /*option*/ SerialGCOptions.InitialCollectionPolicy,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxHeapFree": {
            return OptionDescriptor.create(
                /*name*/ "MaxHeapFree",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Long.class,
                /*help*/ "The maximum free bytes reserved for allocations, in bytes (0 for automatic according to GC policy). Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "MaxHeapFree",
                /*option*/ SerialGCOptions.MaxHeapFree,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxSurvivorSpaces": {
            return OptionDescriptor.create(
                /*name*/ "MaxSurvivorSpaces",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of survivor spaces. Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "MaxSurvivorSpaces",
                /*option*/ SerialGCOptions.MaxSurvivorSpaces,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PercentTimeInIncrementalCollection": {
            return OptionDescriptor.create(
                /*name*/ "PercentTimeInIncrementalCollection",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "Percentage of total collection time that should be spent on young generation collections. Serial and parallel GC only, if the collection policy 'BySpaceAndTime' is used.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "PercentTimeInIncrementalCollection",
                /*option*/ SerialGCOptions.PercentTimeInIncrementalCollection,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGCSummary": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCSummary",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print summary GC information after application main method returns. Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "PrintGCSummary",
                /*option*/ SerialGCOptions.PrintGCSummary,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGCTimeStamps": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCTimeStamps",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print a time stamp at each collection, if +PrintGC or +VerboseGC. Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "PrintGCTimeStamps",
                /*option*/ SerialGCOptions.PrintGCTimeStamps,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGCTimes": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCTimes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print the time for each of the phases of each collection, if +VerboseGC. Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "PrintGCTimes",
                /*option*/ SerialGCOptions.PrintGCTimes,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintHeapShape": {
            return OptionDescriptor.create(
                /*name*/ "PrintHeapShape",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print the shape of the heap before and after each collection, if +VerboseGC. Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "PrintHeapShape",
                /*option*/ SerialGCOptions.PrintHeapShape,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SoftRefLRUPolicyMSPerMB": {
            return OptionDescriptor.create(
                /*name*/ "SoftRefLRUPolicyMSPerMB",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "This number of milliseconds multiplied by the free heap memory in MByte is the time span for which a soft reference will keep its referent alive after its last access. Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "SoftRefLRUPolicyMSPerMB",
                /*option*/ SerialGCOptions.SoftRefLRUPolicyMSPerMB,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "TraceHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace heap chunks during collections, if +VerboseGC and +PrintHeapShape. Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "TraceHeapChunks",
                /*option*/ SerialGCOptions.TraceHeapChunks,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyReferences": {
            return OptionDescriptor.create(
                /*name*/ "VerifyReferences",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify all object references if VerifyHeap is enabled. Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "VerifyReferences",
                /*option*/ SerialGCOptions.VerifyReferences,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyRememberedSet": {
            return OptionDescriptor.create(
                /*name*/ "VerifyRememberedSet",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify the remembered set if VerifyHeap is enabled. Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "VerifyRememberedSet",
                /*option*/ SerialGCOptions.VerifyRememberedSet,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyWriteBarriers": {
            return OptionDescriptor.create(
                /*name*/ "VerifyWriteBarriers",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify write barriers. Serial and parallel GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "VerifyWriteBarriers",
                /*option*/ SerialGCOptions.VerifyWriteBarriers,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 17;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("CollectYoungGenerationSeparately");
                    case 1: return get("CountWriteBarriers");
                    case 2: return get("GreyToBlackObjRefDemographics");
                    case 3: return get("ImageHeapCardMarking");
                    case 4: return get("InitialCollectionPolicy");
                    case 5: return get("MaxHeapFree");
                    case 6: return get("MaxSurvivorSpaces");
                    case 7: return get("PercentTimeInIncrementalCollection");
                    case 8: return get("PrintGCSummary");
                    case 9: return get("PrintGCTimeStamps");
                    case 10: return get("PrintGCTimes");
                    case 11: return get("PrintHeapShape");
                    case 12: return get("SoftRefLRUPolicyMSPerMB");
                    case 13: return get("TraceHeapChunks");
                    case 14: return get("VerifyReferences");
                    case 15: return get("VerifyRememberedSet");
                    case 16: return get("VerifyWriteBarriers");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
