// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: LinkAtBuildTimeSupport.java
package com.oracle.svm.hosted;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;

public class LinkAtBuildTimeSupport_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "LinkAtBuildTime": {
            return OptionDescriptor.create(
                /*name*/ "LinkAtBuildTime",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Require types to be fully defined at image build-time. If used without args, all classes in scope of the option are required to be fully defined.",
                /*extraHelp*/ new String[] {
                         "",
                         "Using --link-at-build-time without arguments is only allowed on command line or when embedded in a",
                         "native-image.properties file of some zip/jar file on the module-path (but not on class-path).",
                         "",
                         "In the module path case, the option will cause all classes of the module to be required to be",
                         "fully defined at image build-time. If used without arguments on command line all classes are",
                         "required to be fully defined at image build-time.",
                         "",
                         "Using --link-at-build-time with arguments is allowed in every scope:",
                         "",
                         "  1. On command line",
                         "  2. Embedded in a native-image.properties file of some zip/jar file on module-path",
                         "  3. Embedded in a native-image.properties file of some zip/jar file on class-path",
                         "",
                         "If the option is embedded in native-image.properties file in some zip/jar file all class-names",
                         "and package-names passed to the option have to be found in the zip/jar files the option is embedded",
                         "in. Using --link-at-build-time with arguments on command line does not have that restriction.",
                         "",
                              },
                /*declaringClass*/ LinkAtBuildTimeSupport.Options.class,
                /*fieldName*/ "LinkAtBuildTime",
                /*option*/ LinkAtBuildTimeSupport.Options.LinkAtBuildTime,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LinkAtBuildTimePaths": {
            return OptionDescriptor.create(
                /*name*/ "LinkAtBuildTimePaths",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Require all types in given class or module-path entries to be fully defined at image build-time.",
                /*extraHelp*/ new String[] {
                         "",
                         "This option requires arguments that are of the same type as the",
                         "arguments passed via -p (--module-path) or -cp (--class-path):",
                         "",
                         "  --link-at-build-time-paths <class search path of directories and zip/jar files>",
                         "",
                         "The given entries are searched and all classes inside are registered as --link-at-build-time classes.",
                         "",
                         "This option is only allowed to be used on command line. I.e. the option will be rejected if it is provided",
                         "by Args of a native-image.properties file embedded in a zip/jar file.",
                              },
                /*declaringClass*/ LinkAtBuildTimeSupport.Options.class,
                /*fieldName*/ "LinkAtBuildTimePaths",
                /*option*/ LinkAtBuildTimeSupport.Options.LinkAtBuildTimePaths,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 2;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("LinkAtBuildTime");
                    case 1: return get("LinkAtBuildTimePaths");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
