/*
 * Copyright (c) 2022, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package sun.awt;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.Files;
import java.io.IOException;

public class FontPropertiesLoader {

    static final boolean IS_SUPPORTED = isSupported();
    static final byte[] PROPERTIES;

    static {

        byte[] properties = null;
        String javaHome = System.getProperty("java.home");

        if (IS_SUPPORTED && javaHome != null) {
            try {
                Path fontPropertryFile = Paths.get(javaHome, "lib", "fontconfig.bfc");
                if (Files.exists(fontPropertryFile)) {
                    properties = Files.readAllBytes(fontPropertryFile);
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        PROPERTIES = properties;
    }

    private static boolean isSupported() {
        @SuppressWarnings("removal")
        String osName = java.security.AccessController.doPrivileged(
                new java.security.PrivilegedAction<String>() {
                    public String run() {
                        return System.getProperty("os.name");
                    }
                });
        return osName != null && (osName.contains("Windows") || osName.contains("OS X"));
    }
}