/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.driver.NativeImage;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

class WindowsBuildEnvironmentUtil {
    private static final String PROGRAM_FILES_x86_ENV_KEY = "ProgramFiles(x86)";
    private static final String VCVARSALL = "vcvarsall.bat";
    private static final String VSWHERE = "vswhere.exe";
    private static final Path VCVARSALL_SUBPATH = Paths.get("VC", "Auxiliary", "Build", "vcvarsall.bat");
    private static final String VISUAL_STUDIO_MINIMUM_REQUIRED_VERSION = "17.6";
    private static final String VISUAL_STUDIO_MINIMUM_REQUIRED_VERSION_TEXT = CCompilerInvoker.VISUAL_STUDIO_MINIMUM_REQUIRED_VERSION_TEXT;

    WindowsBuildEnvironmentUtil() {
    }

    static void propagateEnv(Map<String, String> environment) {
        if (WindowsBuildEnvironmentUtil.isCCompilerOnPath()) {
            return;
        }
        Path vcVarsAllLocation = WindowsBuildEnvironmentUtil.findVCVarsallWithVSWhereOrFail();
        HashMap originalEnv = new HashMap();
        int numSeenOutputSeparators = 0;
        String outputSeparator = "!NEXTCOMMAND!";
        try {
            String commandSequence = "cmd.exe /c set && echo %s && \"%s\" x64 && echo %s && set".formatted(outputSeparator, vcVarsAllLocation, outputSeparator);
            Process p = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", commandSequence});
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith(outputSeparator)) {
                        ++numSeenOutputSeparators;
                        continue;
                    }
                    if (numSeenOutputSeparators == 0) {
                        WindowsBuildEnvironmentUtil.processLineWithKeyValue(line, originalEnv::put);
                        continue;
                    }
                    if (numSeenOutputSeparators != 2) continue;
                    WindowsBuildEnvironmentUtil.processLineWithKeyValue(line, (key, value) -> {
                        boolean isNewOrModifiedEnvVar;
                        boolean bl = isNewOrModifiedEnvVar = !originalEnv.getOrDefault(key, "").equals(value);
                        if (isNewOrModifiedEnvVar) {
                            environment.put((String)key, (String)value);
                        }
                    });
                }
            }
            p.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw WindowsBuildEnvironmentUtil.fail("Failed to detect variables of Windows build environment.", e);
        }
        if (!environment.containsKey("VSINSTALLDIR")) {
            throw WindowsBuildEnvironmentUtil.fail("Failed to automatically set up Windows build environment.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Path findVCVarsallWithVSWhereOrFail() {
        String programFilesX86 = System.getenv(PROGRAM_FILES_x86_ENV_KEY);
        if (programFilesX86 == null) {
            throw WindowsBuildEnvironmentUtil.fail("Variable '%s' is not defined in the system environment.".formatted(PROGRAM_FILES_x86_ENV_KEY));
        }
        Path vsWhereExe = Paths.get(programFilesX86, "Microsoft Visual Studio", "Installer", VSWHERE);
        if (!Files.exists(vsWhereExe, new LinkOption[0])) {
            throw WindowsBuildEnvironmentUtil.fail("Failed to find '%s' for locating Visual Studio installations.".formatted(VSWHERE));
        }
        try {
            Process p = Runtime.getRuntime().exec(new String[]{vsWhereExe.toAbsolutePath().toString(), "-version", VISUAL_STUDIO_MINIMUM_REQUIRED_VERSION, "-products", "*", "-requires", "Microsoft.VisualStudio.Component.VC.Tools.x86.x64", "-property", "installationPath"});
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                Path installationPath;
                Path possibleLocation;
                String installationPathLine = reader.readLine();
                if (installationPathLine == null || !WindowsBuildEnvironmentUtil.isRegularReadableFile(possibleLocation = (installationPath = Paths.get(installationPathLine, new String[0])).resolve(VCVARSALL_SUBPATH))) throw WindowsBuildEnvironmentUtil.fail("Failed to find a suitable version of Visual Studio with '%s'.".formatted(VSWHERE));
                Path path = possibleLocation;
                return path;
            }
        }
        catch (IOException e) {
            throw WindowsBuildEnvironmentUtil.fail("Failed to process output of '%s'.".formatted(VSWHERE), e);
        }
    }

    private static boolean isCCompilerOnPath() {
        try {
            return Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "where", "cl.exe"}).waitFor() == 0;
        }
        catch (IOException | InterruptedException e) {
            throw NativeImage.showError("Failed to check for 'cl.exe'.", e);
        }
    }

    private static boolean isRegularReadableFile(Path location) {
        return Files.isRegularFile(location, new LinkOption[0]) && Files.isReadable(location);
    }

    private static void processLineWithKeyValue(String line, BiConsumer<String, String> consumeKeyValue) {
        String[] parts = line.split("=");
        if (parts.length == 2) {
            consumeKeyValue.accept(parts[0], parts[1]);
        }
    }

    private static Error fail(String reason) {
        return WindowsBuildEnvironmentUtil.fail(reason, null);
    }

    private static Error fail(String reason, Throwable e) {
        throw NativeImage.showError(String.format("%s%nPlease make sure that %s or later is installed on your system. You can download it at https://visualstudio.microsoft.com/downloads/. If this error persists, please try and run GraalVM Native Image in an x64 Native Tools Command Prompt or file a ticket.", reason, VISUAL_STUDIO_MINIMUM_REQUIRED_VERSION_TEXT), e);
    }
}

