/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.attributes;

import com.oracle.svm.espresso.classfile.ConstantPool;
import com.oracle.svm.espresso.classfile.attributes.Attribute;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import java.util.HashSet;
import java.util.Set;

public class NestMembersAttribute
extends Attribute {
    public static final Symbol<Name> NAME = ParserSymbols.ParserNames.NestMembers;
    private final int[] classes;

    public NestMembersAttribute(Symbol<Name> name, int[] classes) {
        assert (name == NAME);
        this.classes = classes;
    }

    public int[] getClasses() {
        return this.classes;
    }

    @Override
    public boolean isSame(Attribute other, ConstantPool thisPool, ConstantPool otherPool) {
        if (!super.isSame(other, thisPool, otherPool)) {
            return false;
        }
        NestMembersAttribute otherNestHostAttribute = (NestMembersAttribute)other;
        Set<Symbol<Name>> thisSymbols = NestMembersAttribute.fillConstants(this.classes, thisPool);
        Set<Symbol<Name>> otherSymbols = NestMembersAttribute.fillConstants(otherNestHostAttribute.classes, otherPool);
        return thisSymbols.equals(otherSymbols);
    }

    private static Set<Symbol<Name>> fillConstants(int[] classIndices, ConstantPool pool) {
        HashSet<Symbol<Name>> symbols = new HashSet<Symbol<Name>>();
        for (int classIndex : classIndices) {
            symbols.add(pool.className(classIndex));
        }
        return symbols;
    }

    @Override
    public Symbol<Name> getName() {
        return NAME;
    }
}

