/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.attributes;

import com.oracle.svm.espresso.classfile.ConstantPool;
import com.oracle.svm.espresso.classfile.attributes.Attribute;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;

public class RecordAttribute
extends Attribute {
    public static final Symbol<Name> NAME = ParserSymbols.ParserNames.Record;
    private final RecordComponentInfo[] components;

    public RecordAttribute(Symbol<Name> name, RecordComponentInfo[] components) {
        assert (name == NAME);
        this.components = components;
    }

    public RecordComponentInfo[] getComponents() {
        return this.components;
    }

    @Override
    public boolean isSame(Attribute other, ConstantPool thisPool, ConstantPool otherPool) {
        if (!super.isSame(other, thisPool, otherPool)) {
            return false;
        }
        RecordAttribute otherRecordAttribute = (RecordAttribute)other;
        if (this.components.length != otherRecordAttribute.components.length) {
            return false;
        }
        return this.allSame(otherRecordAttribute.components, thisPool, otherPool);
    }

    private boolean allSame(RecordComponentInfo[] otherComponents, ConstantPool thisPool, ConstantPool otherPool) {
        for (int i = 0; i < this.components.length; ++i) {
            RecordComponentInfo component = this.components[i];
            if (component.isSame(otherComponents[i], thisPool, otherPool)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Symbol<Name> getName() {
        return NAME;
    }

    public static class RecordComponentInfo {
        final char name;
        final char descriptor;
        final Attribute[] attributes;

        public char getNameIndex() {
            return this.name;
        }

        public char getDescriptorIndex() {
            return this.descriptor;
        }

        public RecordComponentInfo(int name, int descriptor, Attribute[] attributes) {
            this.name = (char)name;
            this.descriptor = (char)descriptor;
            this.attributes = attributes;
        }

        public Attribute getAttribute(Symbol<Name> attributeName) {
            for (Attribute attr : this.attributes) {
                if (!attr.getName().equals(attributeName)) continue;
                return attr;
            }
            return null;
        }

        public boolean isSame(RecordComponentInfo otherComponent, ConstantPool pool, ConstantPool otherPool) {
            if (pool.isSame(this.name, otherComponent.name, otherPool)) {
                return false;
            }
            return !pool.isSame(this.descriptor, otherComponent.descriptor, otherPool);
        }
    }
}

