/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.descriptors;

import com.oracle.svm.espresso.classfile.descriptors.ModifiedUTF8;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public abstract class ByteSequence {
    protected final int hashCode;
    protected final byte[] value;
    public static final ByteSequence EMPTY = ByteSequence.create("");
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    ByteSequence(byte[] underlyingBytes, int hashCode) {
        this.value = Objects.requireNonNull(underlyingBytes);
        this.hashCode = hashCode;
    }

    static int hashOfRange(byte[] bytes, int offset, int length) {
        int h = 0;
        if (length > 0) {
            h = 1;
            for (int i = 0; i < length; ++i) {
                h = 31 * h + bytes[offset + i];
            }
        }
        return h;
    }

    public static ByteSequence wrap(byte[] underlyingBytes) {
        return ByteSequence.wrap(underlyingBytes, 0, underlyingBytes.length);
    }

    public static ByteSequence wrap(byte[] underlyingBytes, final int offset, final int length) {
        if (length > 0 && offset >= underlyingBytes.length || (long)offset + (long)length > (long)underlyingBytes.length || length < 0 || offset < 0) {
            throw new IndexOutOfBoundsException("ByteSequence illegal bounds: offset: " + offset + " length: " + length + " bytes length: " + underlyingBytes.length);
        }
        return new ByteSequence(underlyingBytes, ByteSequence.hashOfRange(underlyingBytes, offset, length)){

            @Override
            public int length() {
                return length;
            }

            @Override
            int offset() {
                return offset;
            }
        };
    }

    public static ByteSequence create(String str) {
        byte[] bytes = ModifiedUTF8.fromJavaString(str);
        return ByteSequence.wrap(bytes, 0, bytes.length);
    }

    public static ByteSequence create(String str, int start) {
        byte[] bytes = ModifiedUTF8.fromJavaString(str, start, str.length() - start, false);
        return ByteSequence.wrap(bytes, 0, bytes.length);
    }

    public static ByteSequence createTypeFromName(String str) {
        byte[] bytes = ModifiedUTF8.fromJavaString(str, 0, str.length(), false, true);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 46) continue;
            bytes[i] = 47;
        }
        return ByteSequence.wrap(bytes, 0, bytes.length);
    }

    public static ByteSequence createReplacingDot(String str, int start) {
        byte[] bytes = ModifiedUTF8.fromJavaString(str, start, str.length() - start, false);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 46) continue;
            bytes[i] = 47;
        }
        return ByteSequence.wrap(bytes, 0, bytes.length);
    }

    public static ByteSequence from(ByteBuffer buffer) {
        int length = buffer.remaining();
        if (buffer.hasArray()) {
            int offset = buffer.position() + buffer.arrayOffset();
            byte[] array = buffer.array();
            return ByteSequence.wrap(array, offset, length);
        }
        byte[] data = new byte[length];
        buffer.get(data);
        return ByteSequence.wrap(data);
    }

    public abstract int length();

    abstract int offset();

    public byte byteAt(int index) {
        return this.value[index + this.offset()];
    }

    public int unsignedByteAt(int index) {
        return this.byteAt(index) & 0xFF;
    }

    final byte[] getUnderlyingBytes() {
        return this.value;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public ByteSequence subSequence(int from) {
        return this.subSequence(from, this.length());
    }

    public ByteSequence subSequence(int startInclusive, int endExclusive) {
        assert (0 <= startInclusive && startInclusive <= endExclusive && endExclusive <= this.length());
        if (startInclusive == 0 && endExclusive == this.length()) {
            return this;
        }
        return ByteSequence.wrap(this.getUnderlyingBytes(), this.offset() + startInclusive, endExclusive - startInclusive);
    }

    public final boolean contentEquals(ByteSequence other) {
        if (this.length() != other.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.byteAt(i) == other.byteAt(i)) continue;
            return false;
        }
        return true;
    }

    public final boolean contentStartsWith(ByteSequence other) {
        if (this.length() < other.length()) {
            return false;
        }
        for (int i = 0; i < other.length(); ++i) {
            if (this.byteAt(i) == other.byteAt(i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        try {
            return ModifiedUTF8.toJavaString(this.getUnderlyingBytes(), this.offset(), this.length());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toHexString() {
        StringBuilder r = new StringBuilder(this.length() * 2);
        for (int i = 0; i < this.length(); ++i) {
            byte b = this.byteAt(i);
            r.append(HEX[b >> 4 & 0xF]);
            r.append(HEX[b & 0xF]);
        }
        return r.toString();
    }

    public int lastIndexOf(byte b) {
        for (int i = this.length() - 1; i >= 0; --i) {
            if (this.byteAt(i) != b) continue;
            return i;
        }
        return -1;
    }

    public void writeTo(byte[] dest, int index) {
        System.arraycopy(this.getUnderlyingBytes(), this.offset(), dest, index, this.length());
    }

    static void writePositiveLongString(long v, byte[] dest, int offset, int length) {
        assert (length == ByteSequence.positiveLongStringSize(v));
        long i = v;
        int digit = length;
        while (i >= 10L) {
            long q = i / 10L;
            long r = i - 10L * q;
            dest[offset + --digit] = (byte)(48L + r);
            i = q;
        }
        assert (digit == 1);
        dest[offset] = (byte)(48L + i);
    }

    static int positiveLongStringSize(long x) {
        assert (x >= 0L);
        long p = 10L;
        for (int i = 1; i < 10; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 10;
    }

    public void writeTo(ByteBuffer bb) {
        bb.put(this.getUnderlyingBytes(), this.offset(), this.length());
    }

    public ByteSequence concat(ByteSequence next) {
        byte[] data = new byte[this.length() + next.length()];
        this.writeTo(data, 0);
        next.writeTo(data, this.length());
        return ByteSequence.wrap(data);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ByteSequence)) {
            return false;
        }
        ByteSequence that = (ByteSequence)other;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        return Arrays.equals(this.value, this.offset(), this.offset() + this.length(), that.value, that.offset(), that.offset() + that.length());
    }
}

