/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.resolver;

import com.oracle.svm.espresso.classfile.bytecode.Bytecodes;

public enum FieldAccessType {
    GetStatic(true, false),
    PutStatic(true, true),
    GetInstance(false, false),
    PutInstance(false, true);

    private final boolean isStatic;
    private final boolean isPut;

    private FieldAccessType(boolean isStatic, boolean isPut) {
        this.isStatic = isStatic;
        this.isPut = isPut;
    }

    public static FieldAccessType fromOpCode(int opcode) {
        return switch (opcode) {
            case 178 -> GetStatic;
            case 179 -> PutStatic;
            case 180 -> GetInstance;
            case 181 -> PutInstance;
            default -> throw new IllegalArgumentException(FieldAccessType.unexpectedBytecodeError(opcode));
        };
    }

    private static String unexpectedBytecodeError(int opcode) {
        return "Unexpected bytecode " + Bytecodes.nameOf(opcode);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isPut() {
        return this.isPut;
    }
}

