/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.resolver;

import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.Signature;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.shared.meta.ErrorType;
import com.oracle.svm.espresso.shared.meta.FieldAccess;
import com.oracle.svm.espresso.shared.meta.MethodAccess;
import com.oracle.svm.espresso.shared.meta.RuntimeAccess;
import com.oracle.svm.espresso.shared.meta.TypeAccess;
import com.oracle.svm.espresso.shared.resolver.CallKind;
import com.oracle.svm.espresso.shared.resolver.CallSiteType;
import com.oracle.svm.espresso.shared.resolver.FieldAccessType;
import com.oracle.svm.espresso.shared.resolver.ResolvedCall;

public final class LinkResolver {
    private static final String AN_INTERFACE = "an interface";
    private static final String A_CLASS = "a class";
    private static final String STATIC = "static";
    private static final String NON_STATIC = "non-static";
    private static final String INIT = "<init>";
    private static final String CLINIT = "<clinit>";

    public static <R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> F resolveFieldSymbolOrThrow(R runtime, C accessingKlass, Symbol<Name> name, Symbol<Type> type, C symbolicHolder, boolean accessCheck, boolean loadingConstraints) {
        return LinkResolver.resolveFieldSymbolImpl(runtime, accessingKlass, name, type, symbolicHolder, accessCheck, loadingConstraints, true);
    }

    public static <R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> F resolveFieldSymbolOrNull(R runtime, C accessingKlass, Symbol<Name> name, Symbol<Type> type, C symbolicHolder, boolean accessCheck, boolean loadingConstraints) {
        try {
            return LinkResolver.resolveFieldSymbolImpl(runtime, accessingKlass, name, type, symbolicHolder, accessCheck, loadingConstraints, false);
        }
        catch (Throwable e) {
            if (runtime.getErrorType(e) != null) {
                throw runtime.fatal(e, "No exception was expected", new Object[0]);
            }
            throw e;
        }
    }

    public static <R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> void checkFieldAccessOrThrow(R runtime, F symbolicResolution, FieldAccessType fieldAccessType, C currentKlass, M currentMethod) {
        LinkResolver.checkFieldAccessImpl(runtime, symbolicResolution, fieldAccessType, currentKlass, currentMethod, true);
    }

    public static <R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> boolean checkFieldAccess(R runtime, F symbolicResolution, FieldAccessType fieldAccessType, C currentKlass, M currentMethod) {
        return LinkResolver.checkFieldAccessImpl(runtime, symbolicResolution, fieldAccessType, currentKlass, currentMethod, false);
    }

    public static <R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> M resolveMethodSymbol(R runtime, C accessingKlass, Symbol<Name> name, Symbol<Signature> signature, C symbolicHolder, boolean interfaceLookup, boolean accessCheck, boolean loadingConstraints) {
        return LinkResolver.resolveMethodSymbolImpl(runtime, accessingKlass, name, signature, symbolicHolder, interfaceLookup, accessCheck, loadingConstraints, true);
    }

    public static <R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> M resolveMethodSymbolOrNull(R runtime, C accessingKlass, Symbol<Name> name, Symbol<Signature> signature, C symbolicHolder, boolean interfaceLookup, boolean accessCheck, boolean loadingConstraints) {
        try {
            return LinkResolver.resolveMethodSymbolImpl(runtime, accessingKlass, name, signature, symbolicHolder, interfaceLookup, accessCheck, loadingConstraints, false);
        }
        catch (Throwable e) {
            if (runtime.getErrorType(e) != null) {
                throw runtime.fatal(e, "No exception was expected", new Object[0]);
            }
            throw e;
        }
    }

    public static <R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> ResolvedCall<C, M, F> resolveCallSiteOrThrow(R runtime, C currentKlass, M symbolicResolution, CallSiteType callSiteType, C symbolicHolder) {
        return LinkResolver.resolveCallSiteImpl(runtime, currentKlass, symbolicResolution, callSiteType, symbolicHolder, true);
    }

    public static <R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> ResolvedCall<C, M, F> resolveCallSiteOrNull(R runtime, C currentKlass, M symbolicResolution, CallSiteType callSiteType, C symbolicHolder) {
        try {
            return LinkResolver.resolveCallSiteImpl(runtime, currentKlass, symbolicResolution, callSiteType, symbolicHolder, false);
        }
        catch (Throwable e) {
            if (runtime.getErrorType(e) != null) {
                throw runtime.fatal(e, "No exception was expected", new Object[0]);
            }
            throw e;
        }
    }

    private LinkResolver() {
    }

    private static <R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> F resolveFieldSymbolImpl(R runtime, C accessingKlass, Symbol<Name> name, Symbol<Type> type, C symbolicHolder, boolean accessCheck, boolean loadingConstraints, boolean throwExceptions) {
        F f = symbolicHolder.lookupField(name, type);
        if (f == null) {
            if (throwExceptions) {
                throw runtime.throwError(ErrorType.NoSuchFieldError, "%s", name);
            }
            return null;
        }
        if (accessCheck && !f.accessChecks(accessingKlass, symbolicHolder)) {
            if (throwExceptions) {
                throw runtime.throwError(ErrorType.IllegalAccessError, "Class %s cannot access field %s#%s", accessingKlass.getJavaName(), f.getDeclaringClass().getJavaName(), name);
            }
            return null;
        }
        if (loadingConstraints) {
            try {
                f.loadingConstraints(accessingKlass, m -> {
                    throw runtime.throwError(ErrorType.LinkageError, (String)m, new Object[0]);
                });
            }
            catch (Throwable e) {
                if (runtime.getErrorType(e) != ErrorType.LinkageError) {
                    throw runtime.fatal(e, "Unexpected exception", new Object[0]);
                }
                if (throwExceptions) {
                    throw e;
                }
                return null;
            }
        }
        return f;
    }

    private static <R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> boolean checkFieldAccessImpl(R runtime, F field, FieldAccessType fieldAccessType, C currentKlass, M currentMethod, boolean throwExceptions) {
        if (fieldAccessType.isStatic() != field.isStatic()) {
            if (throwExceptions) {
                throw runtime.throwError(ErrorType.IncompatibleClassChangeError, "Expected %s field %s.%s", fieldAccessType.isStatic() ? STATIC : NON_STATIC, field.getDeclaringClass().getJavaName(), field.getSymbolicName());
            }
            return false;
        }
        if (fieldAccessType.isPut() && field.isFinalFlagSet()) {
            if (field.getDeclaringClass() != currentKlass) {
                if (throwExceptions) {
                    throw runtime.throwError(ErrorType.IllegalAccessError, "Update to %s final field %s.%s attempted from a different class (%s) than the field's declaring class", fieldAccessType.isStatic() ? STATIC : NON_STATIC, field.getDeclaringClass().getJavaName(), field.getSymbolicName(), currentKlass.getJavaName());
                }
                return false;
            }
            boolean enforceInitializerCheck = field.shouldEnforceInitializerCheck();
            if (!(!enforceInitializerCheck || fieldAccessType.isStatic() && currentMethod.isClassInitializer() || !fieldAccessType.isStatic() && currentMethod.isConstructor())) {
                if (throwExceptions) {
                    throw runtime.throwError(ErrorType.IllegalAccessError, "Update to %s final field %s.%s attempted from a different method (%s) than the initializer method %s ", fieldAccessType.isStatic() ? STATIC : NON_STATIC, field.getDeclaringClass().getJavaName(), field.getSymbolicName(), currentMethod.getSymbolicName(), fieldAccessType.isStatic() ? CLINIT : INIT);
                }
                return false;
            }
        }
        return true;
    }

    private static <R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> M resolveMethodSymbolImpl(R runtime, C accessingKlass, Symbol<Name> name, Symbol<Signature> signature, C symbolicHolder, boolean interfaceLookup, boolean accessCheck, boolean loadingConstraints, boolean throwExceptions) {
        if (interfaceLookup != symbolicHolder.isInterface()) {
            if (throwExceptions) {
                String expected = interfaceLookup ? AN_INTERFACE : A_CLASS;
                String found = interfaceLookup ? A_CLASS : AN_INTERFACE;
                throw runtime.throwError(ErrorType.IncompatibleClassChangeError, "Resolution failure for %s.\nIs %s, but %s was expected", symbolicHolder.getJavaName(), found, expected);
            }
            return null;
        }
        M resolved = symbolicHolder.isInterface() ? symbolicHolder.lookupInterfaceMethod(name, signature) : symbolicHolder.lookupMethod(name, signature);
        if (resolved == null) {
            if (throwExceptions) {
                throw runtime.throwError(ErrorType.NoSuchMethodError, "%s.%s%s", symbolicHolder.getJavaName(), name, signature);
            }
            return null;
        }
        if (accessCheck && !resolved.accessChecks(accessingKlass, symbolicHolder)) {
            if (throwExceptions) {
                throw runtime.throwError(ErrorType.IllegalAccessError, "Class %s cannot access method %s#%s", accessingKlass.getJavaName(), resolved.getDeclaringClass().getJavaName(), name);
            }
            return null;
        }
        if (loadingConstraints && !resolved.shouldSkipLoadingConstraints()) {
            try {
                resolved.loadingConstraints(accessingKlass, m -> {
                    throw runtime.throwError(ErrorType.LinkageError, (String)m, new Object[0]);
                });
            }
            catch (Throwable e) {
                if (runtime.getErrorType(e) != ErrorType.LinkageError) {
                    throw runtime.fatal(e, "Unexpected exception", new Object[0]);
                }
                if (throwExceptions) {
                    throw e;
                }
                return null;
            }
        }
        return resolved;
    }

    private static <R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> ResolvedCall<C, M, F> resolveCallSiteImpl(R runtime, C currentKlass, M symbolicResolution, CallSiteType callSiteType, C symbolicHolder, boolean throwExceptions) {
        CallKind callKind;
        M resolved = symbolicResolution;
        switch (callSiteType) {
            case Static: {
                if (!resolved.isStatic()) {
                    if (throwExceptions) {
                        throw runtime.throwError(ErrorType.IncompatibleClassChangeError, "Expected static method '%s.%s%s'", resolved.getDeclaringClass().getJavaName(), resolved.getSymbolicName(), resolved.getSymbolicSignature());
                    }
                    return null;
                }
                callKind = CallKind.STATIC;
                break;
            }
            case Interface: {
                if (resolved.isStatic() || runtime.getJavaVersion().java8OrEarlier() && resolved.isPrivate()) {
                    if (throwExceptions) {
                        throw runtime.throwError(ErrorType.IncompatibleClassChangeError, "Expected instance not static method '%s.%s%s'", resolved.getDeclaringClass().getJavaName(), resolved.getSymbolicName(), resolved.getSymbolicSignature());
                    }
                    return null;
                }
                if (resolved.isPrivate()) {
                    assert (runtime.getJavaVersion().java9OrLater()) : "Should have thrown in previous check.";
                    callKind = CallKind.DIRECT;
                    break;
                }
                if (resolved.getDeclaringClass().isJavaLangObject()) {
                    callKind = CallKind.VTABLE_LOOKUP;
                    break;
                }
                callKind = CallKind.ITABLE_LOOKUP;
                break;
            }
            case Virtual: {
                if (resolved.isStatic()) {
                    if (throwExceptions) {
                        throw runtime.throwError(ErrorType.IncompatibleClassChangeError, "Expected instance method '%s.%s%s'", resolved.getDeclaringClass().getJavaName(), resolved.getSymbolicName(), resolved.getSymbolicSignature());
                    }
                    return null;
                }
                if (resolved.isFinalFlagSet() || resolved.getDeclaringClass().isFinalFlagSet() || resolved.isPrivate()) {
                    callKind = CallKind.DIRECT;
                    break;
                }
                if (resolved.hasVTableIndex()) {
                    callKind = CallKind.VTABLE_LOOKUP;
                    break;
                }
                assert (resolved.getDeclaringClass().isInterface());
                callKind = CallKind.ITABLE_LOOKUP;
                break;
            }
            case Special: {
                if (resolved.isConstructor() && resolved.getDeclaringClass().getSymbolicName() != symbolicHolder.getSymbolicName()) {
                    if (throwExceptions) {
                        throw runtime.throwError(ErrorType.NoSuchMethodError, "%s.%s%s", resolved.getDeclaringClass().getJavaName(), resolved.getSymbolicName(), resolved.getSymbolicSignature());
                    }
                    return null;
                }
                if (resolved.isStatic()) {
                    if (throwExceptions) {
                        throw runtime.throwError(ErrorType.IncompatibleClassChangeError, "Expected instance not static method '%s.%s%s'", resolved.getDeclaringClass().getJavaName(), resolved.getSymbolicName(), resolved.getSymbolicSignature());
                    }
                    return null;
                }
                if (!resolved.isConstructor() && !symbolicHolder.isInterface() && currentKlass != null && symbolicHolder != currentKlass && currentKlass.getSuperClass() != null && symbolicHolder != currentKlass.getSuperClass() && symbolicHolder.isAssignableFrom(currentKlass)) {
                    resolved = currentKlass.getSuperClass().lookupInstanceMethod(resolved.getSymbolicName(), resolved.getSymbolicSignature());
                }
                callKind = CallKind.DIRECT;
                break;
            }
            default: {
                throw runtime.fatal("Resolution for %s", new Object[]{callSiteType});
            }
        }
        return new ResolvedCall(callKind, resolved);
    }
}

