/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.MultiLayeredStaticFieldsBase;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.util.VMError;
import java.util.function.Function;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class StaticFieldsSupport {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private StaticFieldsSupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setData(Object[] staticObjectFields, byte[] staticPrimitiveFields) {
        MultiLayeredStaticFieldsBase singleton = MultiLayeredStaticFieldsBase.currentLayer();
        singleton.setData(staticObjectFields, staticPrimitiveFields);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Object getCurrentLayerStaticObjectFields() {
        Object[] result = MultiLayeredStaticFieldsBase.currentLayer().getObjectFields();
        VMError.guarantee(result != null, "arrays that hold static fields are only available after static analysis");
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Object getCurrentLayerStaticPrimitiveFields() {
        byte[] result = MultiLayeredStaticFieldsBase.currentLayer().getPrimitiveFields();
        VMError.guarantee(result != null, "arrays that hold static fields are only available after static analysis");
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static JavaConstant getStaticFieldsConstant(ResolvedJavaField field, Function<Object, JavaConstant> toConstant) {
        HostedStaticFieldSupport hostedSupport = HostedStaticFieldSupport.singleton();
        boolean primitive = hostedSupport.isPrimitive(field);
        int layerNum = StaticFieldsSupport.getInstalledLayerNum(field);
        return hostedSupport.getStaticFieldsBaseConstant(layerNum, primitive, toConstant);
    }

    public static int getInstalledLayerNum(ResolvedJavaField field) {
        if (!ImageLayerBuildingSupport.buildingImageLayer()) {
            return -1;
        }
        if (field instanceof SharedField) {
            SharedField sField = (SharedField)field;
            return sField.getInstalledLayerNum();
        }
        return HostedStaticFieldSupport.singleton().getInstalledLayerNum(field);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Object getStaticObjectFieldsAtRuntime(int layerNum) {
        return StaticFieldBaseProxyNode.staticFieldBaseProxyNode(MultiLayeredStaticFieldsBase.forLayer(layerNum).getObjectFields());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Object getStaticPrimitiveFieldsAtRuntime(int layerNum) {
        return StaticFieldBaseProxyNode.staticFieldBaseProxyNode(MultiLayeredStaticFieldsBase.forLayer(layerNum).getPrimitiveFields());
    }

    public static FloatingNode createStaticFieldBaseNode(ResolvedJavaField field) {
        if (field instanceof SharedField) {
            SharedField sField = (SharedField)field;
            boolean primitive = sField.getStorageKind().isPrimitive();
            return new StaticFieldResolvedBaseNode(primitive, sField.getInstalledLayerNum());
        }
        if (!SubstrateUtil.HOSTED) {
            throw VMError.shouldNotReachHere("Not possible at runtime");
        }
        boolean primitive = HostedStaticFieldSupport.singleton().isPrimitive(field);
        int layerNumber = StaticFieldsSupport.getInstalledLayerNum(field);
        return new StaticFieldResolvedBaseNode(primitive, layerNumber);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface HostedStaticFieldSupport {
        public static HostedStaticFieldSupport singleton() {
            return (HostedStaticFieldSupport)ImageSingletons.lookup(HostedStaticFieldSupport.class);
        }

        public JavaConstant getStaticFieldsBaseConstant(int var1, boolean var2, Function<Object, JavaConstant> var3);

        public FloatingNode getStaticFieldsBaseReplacement(int var1, boolean var2, LoweringTool var3, StructuredGraph var4);

        public boolean isPrimitive(ResolvedJavaField var1);

        public int getInstalledLayerNum(ResolvedJavaField var1);
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
    static final class StaticFieldBaseProxyNode
    extends ValueNode
    implements Lowerable {
        public static final NodeClass<StaticFieldBaseProxyNode> TYPE = NodeClass.create(StaticFieldBaseProxyNode.class);
        @Node.Input
        ValueNode staticFieldsArray;

        protected StaticFieldBaseProxyNode(ValueNode staticFieldsArray) {
            super(TYPE, StampFactory.objectNonNull());
            assert (ImageLayerBuildingSupport.buildingImageLayer());
            this.staticFieldsArray = staticFieldsArray;
        }

        public void lower(LoweringTool tool) {
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            this.replaceAtUsagesAndDelete((Node)this.staticFieldsArray);
        }

        @Node.NodeIntrinsic
        public static native Object staticFieldBaseProxyNode(Object var0);
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_1)
    public static final class StaticFieldResolvedBaseNode
    extends FloatingNode
    implements Lowerable {
        public static final NodeClass<StaticFieldResolvedBaseNode> TYPE = NodeClass.create(StaticFieldResolvedBaseNode.class);
        public final boolean primitive;
        public final int layerNum;

        protected StaticFieldResolvedBaseNode(boolean primitive, int layerNum) {
            super(TYPE, StampFactory.objectNonNull());
            this.primitive = primitive;
            this.layerNum = layerNum;
        }

        public void lower(LoweringTool tool) {
            FloatingNode replacement;
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            if (SubstrateUtil.HOSTED) {
                HostedStaticFieldSupport hostedSupport = HostedStaticFieldSupport.singleton();
                replacement = hostedSupport.getStaticFieldsBaseReplacement(this.layerNum, this.primitive, tool, this.graph());
            } else {
                JavaConstant constant = tool.getSnippetReflection().forObject(this.primitive ? StaticFieldsSupport.getStaticPrimitiveFieldsAtRuntime(this.layerNum) : StaticFieldsSupport.getStaticObjectFieldsAtRuntime(this.layerNum));
                replacement = ConstantNode.forConstant((JavaConstant)constant, (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)this.graph());
            }
            this.replaceAndDelete(this.graph().addOrUniqueWithInputs((Node)replacement));
        }
    }

    public static interface StaticFieldValidator {
        public static void checkFieldOffsetAllowed(ResolvedJavaField field) {
            if (field.isStatic()) {
                if (SubstrateUtil.HOSTED) {
                    ((StaticFieldValidator)ImageSingletons.lookup(StaticFieldValidator.class)).hostedCheckFieldOffsetAllowed(field);
                } else {
                    SharedField sField = (SharedField)field;
                    boolean wordType = ((SharedType)sField.getType()).isWordType();
                    VMError.guarantee(!wordType, "static Word field offsets cannot be queried");
                }
            }
        }

        public void hostedCheckFieldOffsetAllowed(ResolvedJavaField var1);
    }
}

