/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.CalleeSavedRegisters;
import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.FrameInfoVerifier;
import com.oracle.svm.core.code.ReusableTypeReader;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.encoder.SymbolEncoder;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.type.CompressibleConstant;
import jdk.graal.compiler.core.common.util.FrequencyEncoder;
import jdk.graal.compiler.core.common.util.TypeConversion;
import jdk.graal.compiler.core.common.util.UnsafeArrayTypeWriter;
import jdk.graal.compiler.nodes.FrameState;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackLockValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.VirtualObject;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.nativeimage.ImageSingletons;

public class FrameInfoEncoder {
    private static final int UNCOMPRESSED_FRAME_SLICE_INDEX = -1;
    private final Customization customization;
    private final List<FrameData> allDebugInfos;
    private final CodeInfoEncoder.Encoders encoders;
    private final CompressedFrameInfoEncodingMetadata frameMetadata;
    private final FrameInfoDecoder.ConstantAccess constantAccess;
    private final CalleeSavedRegisters calleeSavedRegisters;
    private static final FrameInfoQueryResult.ValueInfo[] MARKER = new FrameInfoQueryResult.ValueInfo[0];

    protected FrameInfoEncoder(Customization customization, CodeInfoEncoder.Encoders encoders, FrameInfoDecoder.ConstantAccess constantAccess) {
        this.customization = customization;
        this.encoders = encoders;
        this.allDebugInfos = new ArrayList<FrameData>();
        this.frameMetadata = new CompressedFrameInfoEncodingMetadata();
        this.constantAccess = constantAccess;
        this.calleeSavedRegisters = CalleeSavedRegisters.supportedByPlatform() ? CalleeSavedRegisters.singleton() : null;
    }

    public FrameInfoDecoder.ConstantAccess getConstantAccess() {
        return this.constantAccess;
    }

    protected FrameData addDebugInfo(ResolvedJavaMethod method, CompilationResult compilation, Infopoint infopoint, int totalFrameSize) {
        boolean isDeoptEntry = this.customization.isDeoptEntry(method, compilation, infopoint);
        this.customization.recordFrame(method, infopoint, isDeoptEntry);
        boolean includeLocalValues = this.customization.includeLocalValues(method, infopoint, isDeoptEntry);
        DebugInfo debugInfo = infopoint.debugInfo;
        FrameData data = new FrameData(debugInfo, totalFrameSize, new FrameInfoQueryResult.ValueInfo[FrameInfoEncoder.countVirtualObjects(debugInfo)][], false);
        this.initializeFrameInfo(data.frame, data, debugInfo.frame(), isDeoptEntry, includeLocalValues);
        ArrayList<CompressedFrameData> frameSlice = includeLocalValues ? null : new ArrayList<CompressedFrameData>();
        BytecodeFrame bytecodeFrame = data.debugInfo.frame();
        FrameInfoQueryResult resultFrame = data.frame;
        while (resultFrame != null) {
            assert (bytecodeFrame != null);
            this.customization.fillSourceFields(bytecodeFrame.getMethod(), resultFrame);
            if (resultFrame.getSourceMethod() != null) {
                assert (resultFrame.sourceMethodId == 0);
                this.encoders.addMethod(resultFrame.getSourceMethod(), resultFrame.getSourceClass(), resultFrame.getSourceMethodName(), resultFrame.getSourceMethodSignature(), resultFrame.getSourceMethodModifiers());
            }
            assert (resultFrame.hasLocalValueInfo() == includeLocalValues) : resultFrame;
            if (!includeLocalValues) {
                CompressedFrameData frame = new CompressedFrameData(resultFrame.sourceMethodId, resultFrame.getSourceMethod(), resultFrame.getSourceClass(), resultFrame.getSourceMethodName(), resultFrame.getSourceMethodSignature(), resultFrame.getSourceMethodModifiers(), resultFrame.sourceLineNumber, resultFrame.encodedBci, resultFrame.caller == null);
                frameSlice.add(frame);
            }
            bytecodeFrame = bytecodeFrame.caller();
            resultFrame = resultFrame.caller;
        }
        if (!includeLocalValues) {
            this.frameMetadata.addFrameSlice(data, frameSlice);
        }
        this.allDebugInfos.add(data);
        return data;
    }

    protected FrameData addDefaultDebugInfo(ResolvedJavaMethod method, int totalFrameSize) {
        FrameData data = new FrameData(null, totalFrameSize, null, true);
        data.frame.encodedBci = FrameInfoEncoder.encodeBci(0, FrameState.StackState.BeforePop);
        this.customization.fillSourceFields(method, data.frame);
        data.frame.sourceLineNumber = -1;
        if (data.frame.getSourceMethod() != null) {
            assert (data.frame.sourceMethodId == 0);
            this.encoders.addMethod(data.frame.getSourceMethod(), data.frame.getSourceClass(), data.frame.getSourceMethodName(), data.frame.getSourceMethodSignature(), data.frame.getSourceMethodModifiers());
        }
        CompressedFrameData frame = new CompressedFrameData(data.frame.sourceMethodId, data.frame.getSourceMethod(), data.frame.getSourceClass(), data.frame.getSourceMethodName(), data.frame.getSourceMethodSignature(), data.frame.getSourceMethodModifiers(), data.frame.sourceLineNumber, data.frame.encodedBci, true);
        this.frameMetadata.addFrameSlice(data, List.of(frame));
        this.allDebugInfos.add(data);
        return data;
    }

    private static int countVirtualObjects(DebugInfo debugInfo) {
        BitSet visitedVirtualObjects = new BitSet();
        for (BytecodeFrame frame = debugInfo.frame(); frame != null; frame = frame.caller()) {
            FrameInfoEncoder.countVirtualObjects(frame.values, visitedVirtualObjects);
        }
        return visitedVirtualObjects.length();
    }

    private static void countVirtualObjects(JavaValue[] values, BitSet visitedVirtualObjects) {
        for (JavaValue value : values) {
            VirtualObject virtualObject;
            if (!(value instanceof VirtualObject) || visitedVirtualObjects.get((virtualObject = (VirtualObject)value).getId())) continue;
            visitedVirtualObjects.set(virtualObject.getId());
            FrameInfoEncoder.countVirtualObjects(virtualObject.getValues(), visitedVirtualObjects);
        }
    }

    private void initializeFrameInfo(FrameInfoQueryResult frameInfo, FrameData data, BytecodeFrame frame, boolean isDeoptEntry, boolean needLocalValues) {
        if (frame.caller() != null) {
            assert (!isDeoptEntry) : "Deoptimization entry point information for caller frames is not encoded";
            frameInfo.caller = new FrameInfoQueryResult();
            this.initializeFrameInfo(frameInfo.caller, data, frame.caller(), false, needLocalValues);
        }
        frameInfo.virtualObjects = data.virtualObjects;
        frameInfo.encodedBci = FrameInfoEncoder.encodeBci(frame.getBCI(), FrameState.StackState.of((BytecodeFrame)frame));
        frameInfo.isDeoptEntry = isDeoptEntry;
        FrameInfoQueryResult.ValueInfo[] valueInfos = null;
        SharedMethod method = (SharedMethod)frame.getMethod();
        if (needLocalValues) {
            frameInfo.deoptMethodOffset = method.getImageCodeDeoptOffset();
            if (frameInfo.deoptMethodOffset != 0 && this.customization.storeDeoptTargetMethod()) {
                frameInfo.deoptMethod = method;
                this.encoders.objectConstants.addObject((Object)this.constantAccess.forObject(method, false));
            }
            frameInfo.numLocals = frame.numLocals;
            frameInfo.numStack = frame.numStack;
            frameInfo.numLocks = frame.numLocks;
            JavaValue[] values = frame.values;
            int numValues = 0;
            int i = values.length;
            while (--i >= 0) {
                if (ValueUtil.isIllegalJavaValue((JavaValue)values[i])) continue;
                numValues = i + 1;
                break;
            }
            valueInfos = new FrameInfoQueryResult.ValueInfo[numValues];
            for (i = 0; i < numValues; ++i) {
                valueInfos[i] = this.makeValueInfo(data, FrameInfoEncoder.getFrameValueKind(frame, i), values[i], isDeoptEntry);
            }
        }
        frameInfo.valueInfos = valueInfos;
        ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).frameCount.inc();
    }

    public static JavaKind getFrameValueKind(BytecodeFrame frame, int valueIndex) {
        if (valueIndex < frame.numLocals) {
            return frame.getLocalValueKind(valueIndex);
        }
        if (valueIndex - frame.numLocals < frame.numStack) {
            return frame.getStackValueKind(valueIndex - frame.numLocals);
        }
        assert (valueIndex - frame.numLocals - frame.numStack < frame.numLocks) : frame;
        return JavaKind.Object;
    }

    private FrameInfoQueryResult.ValueInfo makeValueInfo(FrameData data, JavaKind kind, JavaValue v, boolean isDeoptEntry) {
        JavaValue value = v;
        FrameInfoQueryResult.ValueInfo result = new FrameInfoQueryResult.ValueInfo();
        result.kind = kind;
        if (value instanceof StackLockValue) {
            StackLockValue lock = (StackLockValue)value;
            assert (ValueUtil.isIllegal((Value)lock.getSlot())) : value;
            if (isDeoptEntry && lock.isEliminated()) {
                throw VMError.shouldNotReachHere("Cannot have an eliminated monitor in a deoptimization entry point: value " + String.valueOf(value) + " in method " + data.debugInfo.getBytecodePosition().getMethod().format("%H.%n(%p)"));
            }
            result.isEliminatedMonitor = lock.isEliminated();
            value = lock.getOwner();
        }
        if (ValueUtil.isIllegalJavaValue((JavaValue)value)) {
            result.type = FrameInfoQueryResult.ValueType.Illegal;
            assert (result.kind == JavaKind.Illegal) : value;
        } else if (value instanceof StackSlot) {
            StackSlot stackSlot = (StackSlot)value;
            result.type = FrameInfoQueryResult.ValueType.StackSlot;
            result.data = stackSlot.getOffset(data.totalFrameSize);
            result.isCompressedReference = stackSlot.getPlatformKind().getVectorLength() == 1 && FrameInfoEncoder.isCompressedReference((AllocatableValue)stackSlot);
            ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).stackValueCount.inc();
        } else if (ReservedRegisters.singleton().isAllowedInFrameState(value)) {
            RegisterValue register = (RegisterValue)value;
            result.type = FrameInfoQueryResult.ValueType.ReservedRegister;
            result.data = ValueUtil.asRegister((Value)register).number;
            result.isCompressedReference = FrameInfoEncoder.isCompressedReference((AllocatableValue)register);
            ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).registerValueCount.inc();
        } else if (this.calleeSavedRegisters != null && value instanceof RegisterValue) {
            RegisterValue registerValue = (RegisterValue)value;
            if (isDeoptEntry) {
                throw VMError.shouldNotReachHere("Cannot encode registers in deoptimization entry point: value " + String.valueOf(value) + " in method " + data.debugInfo.getBytecodePosition().getMethod().format("%H.%n(%p)"));
            }
            Register register = ValueUtil.asRegister((Value)registerValue);
            if (!this.calleeSavedRegisters.calleeSaveable(register)) {
                throw VMError.shouldNotReachHere("Register is not calleeSaveable: register " + String.valueOf(registerValue) + " in method " + data.debugInfo.getBytecodePosition().getMethod().format("%H.%n(%p)"));
            }
            result.type = FrameInfoQueryResult.ValueType.Register;
            result.data = this.calleeSavedRegisters.getOffsetInFrame(register);
            result.isCompressedReference = registerValue.getPlatformKind().getVectorLength() == 1 && FrameInfoEncoder.isCompressedReference((AllocatableValue)registerValue);
            ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).registerValueCount.inc();
        } else if (value instanceof JavaConstant) {
            JavaConstant constant;
            result.value = constant = (JavaConstant)value;
            if (constant instanceof CompressibleConstant) {
                result.isCompressedReference = ((CompressibleConstant)constant).isCompressed();
            }
            if (constant.isDefaultForKind()) {
                result.type = FrameInfoQueryResult.ValueType.DefaultConstant;
            } else {
                result.type = FrameInfoQueryResult.ValueType.Constant;
                if (constant.getJavaKind() == JavaKind.Object) {
                    this.encoders.objectConstants.addObject((Object)constant);
                }
            }
            ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).constantValueCount.inc();
        } else if (ValueUtil.isVirtualObject((JavaValue)value)) {
            VirtualObject virtualObject = (VirtualObject)value;
            result.type = FrameInfoQueryResult.ValueType.VirtualObject;
            result.data = virtualObject.getId();
            this.makeVirtualObject(data, virtualObject, isDeoptEntry);
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput(value);
        }
        return result;
    }

    private static boolean isCompressedReference(AllocatableValue value) {
        assert (value.getPlatformKind().getVectorLength() == 1) : "Only scalar types supported";
        return ((LIRKind)value.getValueKind(LIRKind.class)).isCompressedReference(0);
    }

    private void makeVirtualObject(FrameData data, VirtualObject virtualObject, boolean isDeoptEntry) {
        int id = virtualObject.getId();
        if (data.virtualObjects[id] != null) {
            return;
        }
        data.virtualObjects[id] = MARKER;
        ArrayList<FrameInfoQueryResult.ValueInfo> valueList = new ArrayList<FrameInfoQueryResult.ValueInfo>(virtualObject.getValues().length + 4);
        SharedType type = (SharedType)virtualObject.getType();
        valueList.add(this.makeValueInfo(data, JavaKind.Object, (JavaValue)this.constantAccess.forObject(type.getHub(), false), isDeoptEntry));
        ObjectLayout objectLayout = ConfigurationValues.getObjectLayout();
        assert (type.isArray() == LayoutEncoding.isArray(type.getHub().getLayoutEncoding())) : "deoptimization code uses layout encoding to determine if type is an array";
        if (type.isArray()) {
            valueList.add(null);
            int length = 0;
            JavaKind kind = ((SharedType)type.getComponentType()).getStorageKind();
            for (int i = 0; i < virtualObject.getValues().length; ++i) {
                JavaValue value = virtualObject.getValues()[i];
                JavaKind valueKind = virtualObject.getSlotKind(i);
                if (objectLayout.sizeInBytes(kind) == 4 && objectLayout.sizeInBytes(valueKind) == 8) {
                    valueList.add(this.makeValueInfo(data, valueKind, value, isDeoptEntry));
                    length += 2;
                    continue;
                }
                if (kind == JavaKind.Byte) {
                    int byteCount = FrameInfoEncoder.restoreByteArrayEntryByteCount(virtualObject, i);
                    valueKind = FrameInfoEncoder.restoreByteArrayEntryValueKind(valueKind, byteCount);
                    valueList.add(this.makeValueInfo(data, valueKind, value, isDeoptEntry));
                    length += byteCount;
                    i += byteCount - 1;
                    continue;
                }
                assert (objectLayout.sizeInBytes(valueKind.getStackKind()) <= objectLayout.sizeInBytes(kind.getStackKind())) : String.valueOf(valueKind) + ", " + String.valueOf(kind);
                valueList.add(this.makeValueInfo(data, kind, value, isDeoptEntry));
                ++length;
                assert (objectLayout.getArrayElementOffset(kind, length) == (long)(objectLayout.getArrayBaseOffset(kind) + FrameInfoEncoder.computeOffset(valueList, 2))) : valueList;
            }
            assert (valueList.get(1) == null);
            valueList.set(1, this.makeValueInfo(data, JavaKind.Int, (JavaValue)JavaConstant.forInt((int)length), isDeoptEntry));
        } else {
            SharedField[] fields = (SharedField[])type.getInstanceFields(true);
            long curOffset = objectLayout.getFirstFieldOffset();
            int fieldIdx = 0;
            int valueIdx = 0;
            while (valueIdx < virtualObject.getValues().length) {
                SharedField field = fields[fieldIdx];
                ++fieldIdx;
                JavaValue value = virtualObject.getValues()[valueIdx];
                JavaKind valueKind = virtualObject.getSlotKind(valueIdx);
                ++valueIdx;
                JavaKind kind = field.getStorageKind();
                if (objectLayout.sizeInBytes(kind) == 4 && objectLayout.sizeInBytes(valueKind) == 8) {
                    kind = valueKind;
                    assert (fields[fieldIdx].getJavaKind() == field.getJavaKind()) : field;
                    ++fieldIdx;
                }
                if (field.getLocation() < 0) continue;
                assert (curOffset <= (long)field.getLocation()) : field;
                while (curOffset + 7L < (long)field.getLocation()) {
                    valueList.add(this.makeValueInfo(data, JavaKind.Long, (JavaValue)JavaConstant.LONG_0, isDeoptEntry));
                    curOffset += 8L;
                }
                if (curOffset + 3L < (long)field.getLocation()) {
                    valueList.add(this.makeValueInfo(data, JavaKind.Int, (JavaValue)JavaConstant.INT_0, isDeoptEntry));
                    curOffset += 4L;
                }
                if (curOffset + 1L < (long)field.getLocation()) {
                    valueList.add(this.makeValueInfo(data, JavaKind.Short, (JavaValue)JavaConstant.forShort((short)0), isDeoptEntry));
                    curOffset += 2L;
                }
                if (curOffset < (long)field.getLocation()) {
                    valueList.add(this.makeValueInfo(data, JavaKind.Byte, (JavaValue)JavaConstant.forByte((byte)0), isDeoptEntry));
                    ++curOffset;
                }
                assert (curOffset == (long)field.getLocation()) : field;
                assert (curOffset - (long)objectLayout.getFirstFieldOffset() == (long)FrameInfoEncoder.computeOffset(valueList, 1)) : field;
                valueList.add(this.makeValueInfo(data, kind, value, isDeoptEntry));
                curOffset += (long)objectLayout.sizeInBytes(kind);
            }
        }
        data.virtualObjects[id] = valueList.toArray(new FrameInfoQueryResult.ValueInfo[0]);
        ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).virtualObjectsCount.inc();
    }

    private static int restoreByteArrayEntryByteCount(VirtualObject vObject, int curIdx) {
        int pos;
        for (pos = curIdx + 1; pos < vObject.getValues().length && vObject.getSlotKind(pos) == JavaKind.Illegal; ++pos) {
        }
        return pos - curIdx;
    }

    private static JavaKind restoreByteArrayEntryValueKind(JavaKind kind, int byteCount) {
        switch (byteCount) {
            case 1: {
                return JavaKind.Byte;
            }
            case 2: {
                return JavaKind.Short;
            }
            case 4: {
                if (kind.isNumericFloat()) {
                    return JavaKind.Float;
                }
                return JavaKind.Int;
            }
            case 8: {
                if (kind.isNumericFloat()) {
                    return JavaKind.Double;
                }
                return JavaKind.Long;
            }
        }
        throw VMError.shouldNotReachHereUnexpectedInput(byteCount);
    }

    private static int computeOffset(ArrayList<FrameInfoQueryResult.ValueInfo> valueInfos, int startIndex) {
        int result = 0;
        for (int i = startIndex; i < valueInfos.size(); ++i) {
            result += ConfigurationValues.getObjectLayout().sizeInBytes(valueInfos.get((int)i).kind);
        }
        return result;
    }

    protected void encodeAllAndInstall(CodeInfo target, Runnable recordActivity) {
        NonmovableArray<Byte> frameInfoEncodings = this.encodeFrameDatas(recordActivity);
        FrameInfoEncoder.install(target, frameInfoEncodings);
    }

    @Uninterruptible(reason="Nonmovable object arrays are not visible to GC until installed in target.")
    private static void install(CodeInfo target, NonmovableArray<Byte> frameInfoEncodings) {
        CodeInfoAccess.setFrameInfo(target, frameInfoEncodings);
        FrameInfoEncoder.afterInstallation(target);
    }

    @Uninterruptible(reason="Safe for GC, but called from uninterruptible code.", calleeMustBe=false)
    private static void afterInstallation(CodeInfo info) {
        ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).frameInfoSize.add(ConfigurationValues.getObjectLayout().getArrayElementOffset(JavaKind.Byte, NonmovableArrays.lengthOf(CodeInfoAccess.getFrameInfoEncodings(info))) + ConfigurationValues.getObjectLayout().getArrayElementOffset(JavaKind.Object, NonmovableArrays.lengthOf(CodeInfoAccess.getObjectConstants(info))));
    }

    private NonmovableArray<Byte> encodeFrameDatas(Runnable recordActivity) {
        UnsafeArrayTypeWriter encodingBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        this.frameMetadata.encodeCompressedData(recordActivity, encodingBuffer, this.encoders);
        for (FrameData data : this.allDebugInfos) {
            if (data.frameSliceIndex == -1) {
                data.encodedFrameInfoIndex = encodingBuffer.getBytesWritten();
                this.encodeUncompressedFrameData(data, encodingBuffer);
            } else {
                data.encodedFrameInfoIndex = this.frameMetadata.getEncodingOffset(data.frameSliceIndex);
                assert (this.frameMetadata.writeFrameVerificationInfo(data, this.encoders));
            }
            recordActivity.run();
        }
        NonmovableArray<Byte> frameInfoEncodings = NonmovableArrays.createByteArray(TypeConversion.asS4((long)encodingBuffer.getBytesWritten()), NmtCategory.Code);
        encodingBuffer.toByteBuffer(NonmovableArrays.asByteBuffer(frameInfoEncodings));
        return frameInfoEncodings;
    }

    private void encodeUncompressedFrameData(FrameData data, UnsafeArrayTypeWriter encodingBuffer) {
        encodingBuffer.putSV(-1L);
        FrameInfoQueryResult cur = data.frame;
        while (cur != null) {
            int deoptMethodIndex;
            assert (cur.encodedBci != 3L) : "used as the end marker during decoding";
            assert (cur.hasLocalValueInfo()) : "Compressed frame info must be used when no local values are needed";
            assert (cur == data.frame || !cur.isDeoptEntry) : "Deoptimization entry information for caller frames is not persisted";
            encodingBuffer.putUV(cur.encodedBci);
            encodingBuffer.putUV((long)cur.numLocks);
            encodingBuffer.putUV((long)cur.numLocals);
            encodingBuffer.putUV((long)cur.numStack);
            if (cur.deoptMethod != null) {
                deoptMethodIndex = -1 - this.encoders.objectConstants.getIndex((Object)this.constantAccess.forObject(cur.deoptMethod, false));
                assert (deoptMethodIndex < 0) : cur;
                assert (cur.getDeoptMethodOffset() == cur.deoptMethod.getImageCodeDeoptOffset()) : cur;
            } else {
                deoptMethodIndex = cur.deoptMethodOffset;
                assert (deoptMethodIndex >= 0) : cur;
            }
            encodingBuffer.putSV((long)deoptMethodIndex);
            this.encodeValues(cur.valueInfos, encodingBuffer);
            if (cur == data.frame) {
                encodingBuffer.putUV((long)cur.virtualObjects.length);
                for (FrameInfoQueryResult.ValueInfo[] virtualObject : cur.virtualObjects) {
                    this.encodeValues(virtualObject, encodingBuffer);
                }
            }
            if (cur.getSourceMethod() != null) {
                assert (cur.sourceMethodId == 0);
                cur.sourceMethodId = this.encoders.findMethodIndex(cur.getSourceMethod(), cur.getSourceClass(), cur.getSourceMethodName(), cur.getSourceMethodSignature(), cur.getSourceMethodModifiers(), false);
            }
            encodingBuffer.putSV((long)cur.sourceMethodId);
            encodingBuffer.putSV((long)cur.sourceLineNumber);
            cur = cur.caller;
        }
        encodingBuffer.putUV(3L);
    }

    private void encodeValues(FrameInfoQueryResult.ValueInfo[] valueInfos, UnsafeArrayTypeWriter encodingBuffer) {
        encodingBuffer.putUV((long)valueInfos.length);
        for (FrameInfoQueryResult.ValueInfo valueInfo : valueInfos) {
            if (valueInfo.type == FrameInfoQueryResult.ValueType.Constant) {
                valueInfo.data = valueInfo.kind == JavaKind.Object ? (long)this.encoders.objectConstants.getIndex((Object)valueInfo.value) : FrameInfoEncoder.encodePrimitiveConstant(valueInfo.value);
            }
            encodingBuffer.putU1((long)FrameInfoEncoder.encodeFlags(valueInfo.type, valueInfo.kind, valueInfo.isCompressedReference, valueInfo.isEliminatedMonitor));
            if (!valueInfo.type.hasData) continue;
            encodingBuffer.putSV(valueInfo.data);
        }
    }

    protected static long encodePrimitiveConstant(JavaConstant constant) {
        return switch (constant.getJavaKind()) {
            case JavaKind.Float -> Float.floatToRawIntBits(constant.asFloat());
            case JavaKind.Double -> Double.doubleToRawLongBits(constant.asDouble());
            default -> constant.asLong();
        };
    }

    private static int encodeFlags(FrameInfoQueryResult.ValueType type, JavaKind kind, boolean isCompressedReference, boolean isEliminatedMonitor) {
        int kindIndex;
        int n = kindIndex = isEliminatedMonitor ? 15 : kind.ordinal();
        assert (FrameInfoDecoder.KIND_VALUES[kindIndex] == kind) : kind;
        return type.ordinal() << 0 | kindIndex << 3 | (isCompressedReference ? 1 : 0) << 7;
    }

    public static long encodeBci(int bci, FrameState.StackState stackState) {
        long result = (long)bci + 4L << 2 | (long)(stackState.duringCall ? 2 : 0) | (long)(stackState.rethrowException ? 1 : 0);
        VMError.guarantee(result >= 0L, "encoded bci is stored as an unsigned value");
        VMError.guarantee(result != 3L, "Encoding must not return marker value");
        return result;
    }

    private static int encodeCompressedFirstEntry(int value, boolean isMethodId) {
        VMError.guarantee(value >= 0);
        int encodedValue = isMethodId ? value : -(value + 2);
        VMError.guarantee(encodedValue != -1);
        return encodedValue;
    }

    private static long encodeCompressedEncodedBci(long encodedBci, boolean hasUniqueSharedFrameSuccessor) {
        VMError.guarantee(encodedBci >= 0L);
        if (!hasUniqueSharedFrameSuccessor) {
            return encodedBci;
        }
        return -(encodedBci + 1L);
    }

    private static int encodeCompressedSourceLineNumber(int sourceLineNumber, boolean isSliceEnd) {
        int lineNumberWithAddend = sourceLineNumber + 3;
        VMError.guarantee(lineNumberWithAddend > 0);
        return isSliceEnd ? -lineNumberWithAddend : lineNumberWithAddend;
    }

    void verifyEncoding(CodeInfo info) {
        for (FrameData expectedData : this.allDebugInfos) {
            ReusableTypeReader reader = new ReusableTypeReader(CodeInfoAccess.getFrameInfoEncodings(info), expectedData.encodedFrameInfoIndex);
            FrameInfoQueryResult actualFrame = FrameInfoDecoder.decodeFrameInfo(expectedData.frame.isDeoptEntry, reader, info, this.constantAccess);
            FrameInfoVerifier.verifyFrames(expectedData, expectedData.frame, actualFrame, info);
        }
    }

    public static abstract class Customization {
        protected void recordFrame(ResolvedJavaMethod method, Infopoint infopoint, boolean isDeoptEntry) {
        }

        protected abstract boolean storeDeoptTargetMethod();

        protected abstract boolean includeLocalValues(ResolvedJavaMethod var1, Infopoint var2, boolean var3);

        protected abstract boolean isDeoptEntry(ResolvedJavaMethod var1, CompilationResult var2, Infopoint var3);

        protected abstract void fillSourceFields(ResolvedJavaMethod var1, FrameInfoQueryResult var2);
    }

    private static final class CompressedFrameInfoEncodingMetadata {
        final List<CompressedFrameData> framesToEncode = new ArrayList<CompressedFrameData>();
        final EconomicMap<CompressedFrameData, Integer> framesToEncodeIndexMap = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        final List<List<CompressedFrameData>> frameSlices = new ArrayList<List<CompressedFrameData>>();
        final EconomicMap<List<CompressedFrameData>, Integer> frameSliceIndexMap = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        final FrequencyEncoder<Integer> sliceFrequency = FrequencyEncoder.createEqualityEncoder();
        final Map<CompressedFrameData, Integer> frameSliceFrequency = new HashMap<CompressedFrameData, Integer>();
        final Map<CompressedFrameData, Set<CompressedFrameData>> frameSuccessorMap = new HashMap<CompressedFrameData, Set<CompressedFrameData>>();
        final Map<CompressedFrameData, Integer> frameMaxHeight = new HashMap<CompressedFrameData, Integer>();
        boolean sealed = false;
        EconomicMap<Integer, Long> encodedSliceIndexMap = EconomicMap.create((Equivalence)Equivalence.DEFAULT);

        private CompressedFrameInfoEncodingMetadata() {
        }

        void addFrameSlice(FrameData data, List<CompressedFrameData> slice) {
            assert (!this.sealed) : "already sealed";
            ArrayList<CompressedFrameData> frameSliceToEncode = new ArrayList<CompressedFrameData>();
            for (CompressedFrameData curFrame : slice) {
                if (!this.framesToEncodeIndexMap.containsKey((Object)curFrame)) {
                    int frameIndex = this.framesToEncode.size();
                    this.framesToEncode.add(curFrame);
                    this.framesToEncodeIndexMap.put((Object)curFrame, (Object)frameIndex);
                }
                CompressedFrameData frame = this.framesToEncode.get((Integer)this.framesToEncodeIndexMap.get((Object)curFrame));
                frameSliceToEncode.add(frame);
            }
            if (!this.frameSliceIndexMap.containsKey(frameSliceToEncode)) {
                int frameSliceIndex = this.frameSlices.size();
                this.frameSlices.add(frameSliceToEncode);
                this.frameSliceIndexMap.put(frameSliceToEncode, (Object)frameSliceIndex);
                CompressedFrameData prevFrame = null;
                int height = 0;
                for (CompressedFrameData frame : frameSliceToEncode) {
                    this.frameSliceFrequency.merge(frame, 1, Integer::sum);
                    if (prevFrame != null) {
                        this.frameSuccessorMap.compute(prevFrame, (k, v) -> {
                            HashSet<CompressedFrameData> callers = v == null ? new HashSet<CompressedFrameData>() : v;
                            callers.add(frame);
                            return callers;
                        });
                    }
                    prevFrame = frame;
                    this.frameMaxHeight.put(frame, Integer.max(height, this.frameMaxHeight.getOrDefault(frame, 0)));
                    ++height;
                }
            }
            Integer frameSliceIndex = (Integer)this.frameSliceIndexMap.get(frameSliceToEncode);
            data.frameSliceIndex = frameSliceIndex;
            this.sliceFrequency.addObject((Object)frameSliceIndex);
        }

        void encodeCompressedData(Runnable recordActivity, UnsafeArrayTypeWriter encodingBuffer, CodeInfoEncoder.Encoders encoders) {
            Integer[] sliceOrder;
            assert (!this.sealed) : "already sealed";
            this.sealed = true;
            EconomicMap sharedEncodedFrameIndexMap = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            this.framesToEncode.stream().filter(f -> this.frameSliceFrequency.get(f) > 1).sorted((f1, f2) -> {
                int result = -Integer.compare(this.frameSliceFrequency.get(f1), this.frameSliceFrequency.get(f2));
                if (result == 0) {
                    result = -Integer.compare(this.frameMaxHeight.get(f1), this.frameMaxHeight.get(f2));
                }
                recordActivity.run();
                return result;
            }).forEachOrdered(sharedFrame -> {
                int uniqueSuccessorIndex;
                assert (!sharedEncodedFrameIndexMap.containsKey(sharedFrame)) : sharedFrame;
                sharedEncodedFrameIndexMap.put(sharedFrame, (Object)encodingBuffer.getBytesWritten());
                CompressedFrameData uniqueSuccessor = this.getUniqueSuccessor((CompressedFrameData)sharedFrame);
                if (uniqueSuccessor != null) {
                    assert (sharedEncodedFrameIndexMap.containsKey((Object)uniqueSuccessor)) : uniqueSuccessor;
                    uniqueSuccessorIndex = NumUtil.safeToInt((long)((Long)sharedEncodedFrameIndexMap.get((Object)uniqueSuccessor)));
                } else {
                    uniqueSuccessorIndex = -1;
                }
                CompressedFrameInfoEncodingMetadata.encodeCompressedFrame(encodingBuffer, encoders, sharedFrame, uniqueSuccessorIndex);
                recordActivity.run();
            });
            for (Integer sliceIdx : sliceOrder = (Integer[])this.sliceFrequency.encodeAll((Object[])new Integer[this.sliceFrequency.getLength()])) {
                assert (!this.encodedSliceIndexMap.containsKey((Object)sliceIdx)) : sliceIdx;
                List<CompressedFrameData> slice = this.frameSlices.get(sliceIdx);
                assert (slice.size() > 0) : sliceIdx;
                boolean directlyPointToSharedFrame = slice.stream().allMatch(frame -> {
                    Set<CompressedFrameData> frameSuccessors = this.frameSuccessorMap.get(frame);
                    return sharedEncodedFrameIndexMap.containsKey(frame) && (frameSuccessors == null || frameSuccessors.size() == 1);
                });
                if (directlyPointToSharedFrame) {
                    CompressedFrameData frame2 = slice.getFirst();
                    assert (sharedEncodedFrameIndexMap.containsKey((Object)frame2)) : frame2;
                    this.encodedSliceIndexMap.put((Object)sliceIdx, (Object)((Long)sharedEncodedFrameIndexMap.get((Object)frame2)));
                    continue;
                }
                this.encodedSliceIndexMap.put((Object)sliceIdx, (Object)encodingBuffer.getBytesWritten());
                CompressedFrameData prevFrame = null;
                boolean prevShared = false;
                for (CompressedFrameData frame3 : slice) {
                    boolean sharedFrame2 = sharedEncodedFrameIndexMap.containsKey((Object)frame3);
                    if (!prevShared || this.getUniqueSuccessor(prevFrame) == null) {
                        if (sharedFrame2) {
                            int framePointer = NumUtil.safeToInt((long)((Long)sharedEncodedFrameIndexMap.get((Object)frame3)));
                            encodingBuffer.putSV((long)FrameInfoEncoder.encodeCompressedFirstEntry(framePointer, false));
                        } else {
                            CompressedFrameInfoEncodingMetadata.encodeCompressedFrame(encodingBuffer, encoders, frame3, -1);
                        }
                    }
                    prevShared = sharedFrame2;
                    prevFrame = frame3;
                }
            }
        }

        private CompressedFrameData getUniqueSuccessor(CompressedFrameData frame) {
            Set<CompressedFrameData> frameSuccessors = this.frameSuccessorMap.get(frame);
            if (frameSuccessors != null && frameSuccessors.size() == 1) {
                return frameSuccessors.iterator().next();
            }
            return null;
        }

        private static void encodeCompressedFrame(UnsafeArrayTypeWriter encodingBuffer, CodeInfoEncoder.Encoders encoders, CompressedFrameData frame, int uniqueSuccessorIndex) {
            int methodId = frame.methodId;
            if (frame.sourceMethod != null) {
                assert (methodId == 0);
                methodId = encoders.findMethodIndex(frame.sourceMethod, frame.sourceClass, frame.sourceMethodName, frame.sourceMethodSignature, frame.sourceMethodModifier, false);
            }
            encodingBuffer.putSV((long)FrameInfoEncoder.encodeCompressedFirstEntry(methodId, true));
            boolean encodeUniqueSuccessor = uniqueSuccessorIndex != -1;
            encodingBuffer.putSV((long)FrameInfoEncoder.encodeCompressedSourceLineNumber(frame.sourceLineNumber, frame.isSliceEnd));
            encodingBuffer.putSV(FrameInfoEncoder.encodeCompressedEncodedBci(frame.encodedBci, encodeUniqueSuccessor));
            if (encodeUniqueSuccessor) {
                encodingBuffer.putSV((long)uniqueSuccessorIndex);
            }
        }

        long getEncodingOffset(int sliceIndex) {
            assert (this.sealed) : this;
            Long encodedSliceIndex = (Long)this.encodedSliceIndexMap.get((Object)sliceIndex);
            assert (encodedSliceIndex != null);
            return encodedSliceIndex;
        }

        boolean writeFrameVerificationInfo(FrameData data, CodeInfoEncoder.Encoders encoders) {
            int curIdx = 0;
            List<CompressedFrameData> slice = this.frameSlices.get(data.frameSliceIndex);
            FrameInfoQueryResult cur = data.frame;
            while (cur != null) {
                assert (cur == data.frame || !cur.isDeoptEntry) : "Deoptimization entry information for caller frames is not persisted";
                int previousMethodId = cur.sourceMethodId;
                if (cur.getSourceMethod() != null) {
                    cur.sourceMethodId = encoders.findMethodIndex(cur.getSourceMethod(), cur.getSourceClass(), cur.getSourceMethodName(), cur.getSourceMethodSignature(), cur.getSourceMethodModifiers(), false);
                    assert (previousMethodId == 0 || previousMethodId == cur.sourceMethodId);
                }
                boolean isSliceEnd = cur.caller == null;
                CompressedFrameData expected = new CompressedFrameData(previousMethodId, cur.getSourceMethod(), cur.getSourceClass(), cur.getSourceMethodName(), cur.getSourceMethodSignature(), cur.getSourceMethodModifiers(), cur.sourceLineNumber, cur.encodedBci, isSliceEnd);
                assert (expected.equals(slice.get(curIdx))) : expected;
                ++curIdx;
                cur = cur.caller;
            }
            assert (this.frameSlices.get(data.frameSliceIndex).size() == curIdx) : curIdx;
            return true;
        }
    }

    static class FrameData {
        protected final DebugInfo debugInfo;
        protected final int totalFrameSize;
        protected final FrameInfoQueryResult.ValueInfo[][] virtualObjects;
        protected final FrameInfoQueryResult frame;
        protected long encodedFrameInfoIndex;
        protected boolean isDefaultFrameData;
        protected int frameSliceIndex = -1;

        FrameData(DebugInfo debugInfo, int totalFrameSize, FrameInfoQueryResult.ValueInfo[][] virtualObjects, boolean isDefaultFrameData) {
            assert (virtualObjects != null && debugInfo != null || virtualObjects == null && debugInfo == null) : debugInfo;
            this.debugInfo = debugInfo;
            this.totalFrameSize = totalFrameSize;
            this.virtualObjects = virtualObjects;
            this.isDefaultFrameData = isDefaultFrameData;
            this.frame = new FrameInfoQueryResult();
        }
    }

    record CompressedFrameData(int methodId, ResolvedJavaMethod sourceMethod, Class<?> sourceClass, String sourceMethodName, String sourceMethodSignature, int sourceMethodModifier, int sourceLineNumber, long encodedBci, boolean isSliceEnd) {
    }

    public static abstract class SourceFieldsFromImage
    extends Customization {
        @Override
        protected void fillSourceFields(ResolvedJavaMethod method, FrameInfoQueryResult resultFrameInfo) {
            CodeInfo codeInfo;
            CodeInfoQueryResult targetCodeInfo;
            int deoptOffsetInImage = ((SharedMethod)method).getImageCodeDeoptOffset();
            if (deoptOffsetInImage != 0 && (targetCodeInfo = CodeInfoTable.lookupDeoptimizationEntrypoint(codeInfo = CodeInfoTable.getImageCodeInfo((SharedMethod)method), deoptOffsetInImage, resultFrameInfo.encodedBci)) != null) {
                FrameInfoQueryResult targetFrameInfo = targetCodeInfo.getFrameInfo();
                resultFrameInfo.sourceMethodId = targetFrameInfo.sourceMethodId;
                resultFrameInfo.sourceLineNumber = targetFrameInfo.sourceLineNumber;
            }
        }
    }

    public static abstract class SourceFieldsFromMethod
    extends Customization {
        private final HostedStringDeduplication stringTable = HostedStringDeduplication.singleton();
        private final SymbolEncoder encoder = SymbolEncoder.singleton();

        @Override
        protected void fillSourceFields(ResolvedJavaMethod method, FrameInfoQueryResult resultFrameInfo) {
            resultFrameInfo.setSourceMethod(method);
            StackTraceElement source = method.asStackTraceElement(resultFrameInfo.getBci());
            resultFrameInfo.sourceLineNumber = source.getLineNumber();
            Class<?> sourceClass = this.getDeclaringJavaClass(method);
            int sourceMethodModifiers = method.getModifiers();
            String methodSignature = method.getSignature().toMethodDescriptor();
            String sourceMethodName = this.stringTable.deduplicate(this.encoder.encodeMethod(source.getMethodName(), sourceClass), true);
            String sourceMethodSignature = CodeInfoEncoder.shouldEncodeAllMethodMetadata() ? this.stringTable.deduplicate(methodSignature, true) : methodSignature;
            resultFrameInfo.setSourceFields(sourceClass, sourceMethodName, sourceMethodSignature, sourceMethodModifiers);
        }

        protected abstract Class<?> getDeclaringJavaClass(ResolvedJavaMethod var1);
    }
}

