/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeCache;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.UntetheredCodeInfoAccess;
import com.oracle.svm.core.genscavenge.GreyToBlackObjRefVisitor;
import com.oracle.svm.core.genscavenge.RuntimeCodeCacheReachabilityAnalyzer;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;

final class RuntimeCodeCacheWalker
implements RuntimeCodeCache.CodeInfoVisitor {
    private final RuntimeCodeCacheReachabilityAnalyzer checkForUnreachableObjectsVisitor = new RuntimeCodeCacheReachabilityAnalyzer();
    private final GreyToBlackObjRefVisitor greyToBlackObjectVisitor;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    RuntimeCodeCacheWalker(GreyToBlackObjRefVisitor greyToBlackObjectVisitor) {
        this.greyToBlackObjectVisitor = greyToBlackObjectVisitor;
    }

    @Override
    public void visitCode(CodeInfo codeInfo) {
        if (RuntimeCodeInfoAccess.areAllObjectsOnImageHeap(codeInfo)) {
            return;
        }
        boolean invalidateCodeThatReferencesUnreachableObjects = SubstrateGCOptions.TreatRuntimeCodeInfoReferencesAsWeak.getValue();
        Object tether = UntetheredCodeInfoAccess.getTetherUnsafe(codeInfo);
        if (tether != null && !RuntimeCodeCacheWalker.isReachable(tether)) {
            int state = CodeInfoAccess.getState(codeInfo);
            if (state == 4) {
                RuntimeCodeInfoAccess.walkObjectFields(codeInfo, this.greyToBlackObjectVisitor);
                CodeInfoAccess.setState(codeInfo, 5);
                return;
            }
            if (state == 2 || invalidateCodeThatReferencesUnreachableObjects && state == 1 && this.hasWeakReferenceToUnreachableObject(codeInfo)) {
                RuntimeCodeInfoAccess.walkObjectFields(codeInfo, this.greyToBlackObjectVisitor);
                CodeInfoAccess.setState(codeInfo, 3);
                return;
            }
        }
        RuntimeCodeInfoAccess.walkStrongReferences(codeInfo, this.greyToBlackObjectVisitor);
        RuntimeCodeInfoAccess.walkWeakReferences(codeInfo, this.greyToBlackObjectVisitor);
    }

    private static boolean isReachable(Object possiblyForwardedObject) {
        return RuntimeCodeCacheReachabilityAnalyzer.isReachable((Pointer)Word.objectToUntrackedPointer((Object)possiblyForwardedObject));
    }

    private boolean hasWeakReferenceToUnreachableObject(CodeInfo codeInfo) {
        try {
            RuntimeCodeInfoAccess.walkWeakReferences(codeInfo, this.checkForUnreachableObjectsVisitor);
            return false;
        }
        catch (RuntimeCodeCacheReachabilityAnalyzer.UnreachableObjectsException e) {
            return true;
        }
    }
}

