/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.compacting;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.RuntimeCodeCache;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.compacting.ObjectRefFixupVisitor;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class RuntimeCodeCacheFixupWalker
implements RuntimeCodeCache.CodeInfoVisitor {
    private final ObjectRefFixupVisitor visitor;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public RuntimeCodeCacheFixupWalker(ObjectRefFixupVisitor visitor) {
        assert (SerialGCOptions.useCompactingOldGen());
        this.visitor = visitor;
    }

    @Override
    public void visitCode(CodeInfo codeInfo) {
        if (RuntimeCodeInfoAccess.areAllObjectsOnImageHeap(codeInfo)) {
            return;
        }
        RuntimeCodeInfoAccess.walkStrongReferences(codeInfo, this.visitor);
        RuntimeCodeInfoAccess.walkWeakReferences(codeInfo, this.visitor);
    }
}

