/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.GCAllocationSupport;
import com.oracle.svm.core.heap.Pod;
import com.oracle.svm.core.hub.RuntimeClassLoading;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.ContinuationSupport;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;

public class GenScavengeAllocationSupport
implements GCAllocationSupport {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_NEW_INSTANCE = SnippetRuntime.findForeignCall(GenScavengeAllocationSupport.class, "slowNewInstance", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_NEW_ARRAY = SnippetRuntime.findForeignCall(GenScavengeAllocationSupport.class, "slowNewArray", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_NEW_STORED_CONTINUATION = SnippetRuntime.findForeignCall(GenScavengeAllocationSupport.class, "slowNewStoredContinuation", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_NEW_POD_INSTANCE = SnippetRuntime.findForeignCall(GenScavengeAllocationSupport.class, "slowNewPodInstance", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor NEW_DYNAMICHUB = SnippetRuntime.findForeignCall(GenScavengeAllocationSupport.class, "newDynamicHub", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] UNCONDITIONAL_FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{SLOW_NEW_INSTANCE, SLOW_NEW_ARRAY};

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(UNCONDITIONAL_FOREIGN_CALLS);
        if (ContinuationSupport.isSupported()) {
            foreignCalls.register(SLOW_NEW_STORED_CONTINUATION);
        }
        if (Pod.RuntimeSupport.isPresent()) {
            foreignCalls.register(SLOW_NEW_POD_INSTANCE);
        }
        if (RuntimeClassLoading.isSupported()) {
            foreignCalls.register(NEW_DYNAMICHUB);
        }
    }

    @Override
    public ForeignCallDescriptor getNewInstanceStub() {
        return SLOW_NEW_INSTANCE;
    }

    @Override
    public ForeignCallDescriptor getNewArrayStub() {
        return SLOW_NEW_ARRAY;
    }

    @Override
    public ForeignCallDescriptor getNewStoredContinuationStub() {
        return SLOW_NEW_STORED_CONTINUATION;
    }

    @Override
    public ForeignCallDescriptor getNewPodInstanceStub() {
        return SLOW_NEW_POD_INSTANCE;
    }

    @Override
    public SnippetRuntime.SubstrateForeignCallDescriptor getNewDynamicHub() {
        return NEW_DYNAMICHUB;
    }

    @Override
    public boolean useTLAB() {
        return SubstrateGCOptions.TlabOptions.UseTLAB.getValue();
    }

    @Override
    public boolean shouldAllocateInTLAB(UnsignedWord size, boolean isArray) {
        return !isArray || GenScavengeAllocationSupport.arrayAllocatedInAlignedChunk(size);
    }

    @Override
    public Word getTLABInfo() {
        return ThreadLocalAllocation.getTlabAddress();
    }

    @Override
    public int tlabTopOffset() {
        return ThreadLocalAllocation.Descriptor.offsetOfAllocationTop();
    }

    @Override
    public int tlabEndOffset() {
        return ThreadLocalAllocation.Descriptor.offsetOfAllocationEnd();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean arrayAllocatedInAlignedChunk(UnsignedWord objectSize) {
        return objectSize.belowThan(HeapParameters.getLargeArrayThreshold());
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="The newly allocated object must be young or all its covered cards must be dirty.")
    private static Object slowNewInstance(Word objectHeader) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            Object result = GenScavengeAllocationSupport.slowNewInstanceInterruptibly(objectHeader);
            HeapImpl.getHeap().dirtyAllReferencesOf(result);
            Object object = result;
            return object;
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="The newly allocated object must be young or all its covered cards must be dirty.")
    private static Object slowNewArray(Word objectHeader, int length) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            Object result = GenScavengeAllocationSupport.slowNewArrayLikeObjectInterruptibly(objectHeader, length, null);
            HeapImpl.getHeap().dirtyAllReferencesOf(result);
            Object object = result;
            return object;
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="The newly allocated object must be young or all its covered cards must be dirty.")
    private static Object slowNewPodInstance(Word objectHeader, int arrayLength, byte[] referenceMap) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            Object result = GenScavengeAllocationSupport.slowNewArrayLikeObjectInterruptibly(objectHeader, arrayLength, referenceMap);
            HeapImpl.getHeap().dirtyAllReferencesOf(result);
            Object object = result;
            return object;
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="Just to be consistent with the other allocation slowpath code.")
    private static Object slowNewStoredContinuation(Word objectHeader, int length) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            Object object = GenScavengeAllocationSupport.slowNewArrayLikeObjectInterruptibly(objectHeader, length, null);
            return object;
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object newDynamicHub(int vTableSlots) {
        return HeapImpl.allocateDynamicHub(vTableSlots);
    }

    @Uninterruptible(reason="Switch from uninterruptible to interruptible code.", calleeMustBe=false)
    private static Object slowNewInstanceInterruptibly(Word objectHeader) {
        return ThreadLocalAllocation.slowPathNewInstance(objectHeader);
    }

    @Uninterruptible(reason="Switch from uninterruptible to interruptible code.", calleeMustBe=false)
    private static Object slowNewArrayLikeObjectInterruptibly(Word objectHeader, int length, byte[] podReferenceMap) {
        return ThreadLocalAllocation.slowPathNewArrayLikeObject(objectHeader, length, podReferenceMap);
    }
}

