/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.remset;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.UninterruptibleObjectReferenceVisitor;
import com.oracle.svm.core.heap.UninterruptibleObjectVisitor;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.util.HostedByteBufferPointer;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.util.List;
import jdk.graal.compiler.nodes.gc.BarrierSet;
import jdk.graal.compiler.nodes.gc.NoBarrierSet;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class NoRememberedSet
implements RememberedSet {
    @Override
    public BarrierSet createBarrierSet(MetaAccessProvider metaAccess) {
        return new NoBarrierSet();
    }

    @Override
    public UnsignedWord getHeaderSizeOfAlignedChunk() {
        UnsignedWord headerSize = Word.unsigned((int)SizeOf.get(AlignedHeapChunk.AlignedHeader.class));
        UnsignedWord alignment = Word.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(headerSize, alignment);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getHeaderSizeOfUnalignedChunk(UnsignedWord objectSize) {
        return NoRememberedSet.getHeaderSizeOfUnalignedChunk();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getHeaderSizeOfUnalignedChunk() {
        UnsignedWord headerSize = Word.unsigned((int)SizeOf.get(UnalignedHeapChunk.UnalignedHeader.class));
        UnsignedWord alignment = Word.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(headerSize, alignment);
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setObjectStartOffsetOfUnalignedChunk(HostedByteBufferPointer chunk, UnsignedWord objectStartOffset) {
        assert (objectStartOffset.equal(NoRememberedSet.getHeaderSizeOfUnalignedChunk()));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setObjectStartOffsetOfUnalignedChunk(UnalignedHeapChunk.UnalignedHeader chunk, UnsignedWord objectStartOffset) {
        assert (objectStartOffset.equal(NoRememberedSet.getHeaderSizeOfUnalignedChunk()));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getObjectStartOffsetOfUnalignedChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
        return NoRememberedSet.getHeaderSizeOfUnalignedChunk();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getOffsetForObjectInUnalignedChunk(Pointer objPtr) {
        return NoRememberedSet.getHeaderSizeOfUnalignedChunk();
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void enableRememberedSetForAlignedChunk(HostedByteBufferPointer chunk, int chunkPosition, List<ImageHeapObject> objects) {
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void enableRememberedSetForUnalignedChunk(HostedByteBufferPointer chunk, UnsignedWord objectSize) {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void enableRememberedSetForChunk(AlignedHeapChunk.AlignedHeader chunk) {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void enableRememberedSetForChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void enableRememberedSetForObject(AlignedHeapChunk.AlignedHeader chunk, Object obj, UnsignedWord objSize) {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void clearRememberedSet(AlignedHeapChunk.AlignedHeader chunk) {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void clearRememberedSet(UnalignedHeapChunk.UnalignedHeader chunk) {
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasRememberedSet(UnsignedWord header) {
        return false;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void dirtyCardForAlignedObject(Object object, boolean verifyOnly) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void dirtyCardForUnalignedObject(Object object, Pointer address, boolean verifyOnly) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void dirtyCardRangeForUnalignedObject(Object object, Pointer startAddress, Pointer endAddress) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void dirtyCardIfNecessary(Object holderObject, Object object, Pointer objRef) {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void dirtyAllReferencesIfNecessary(Object obj) {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void walkDirtyObjects(AlignedHeapChunk.AlignedHeader firstAlignedChunk, UnalignedHeapChunk.UnalignedHeader firstUnalignedChunk, UnalignedHeapChunk.UnalignedHeader lastUnalignedChunk, UninterruptibleObjectVisitor visitor, UninterruptibleObjectReferenceVisitor refVisitor, boolean clean) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Override
    public boolean verify(AlignedHeapChunk.AlignedHeader firstAlignedHeapChunk) {
        return true;
    }

    @Override
    public boolean verify(UnalignedHeapChunk.UnalignedHeader firstUnalignedHeapChunk) {
        return true;
    }

    @Override
    public boolean verify(UnalignedHeapChunk.UnalignedHeader firstUnalignedHeapChunk, UnalignedHeapChunk.UnalignedHeader lastUnalignedHeapChunk) {
        return true;
    }

    @Override
    public boolean usePreciseCardMarking(Object obj) {
        throw VMError.shouldNotReachHereAtRuntime();
    }
}

