/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.remset;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.remset.CardTable;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.heap.UninterruptibleObjectReferenceVisitor;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.HostedByteBufferPointer;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.replacements.nodes.AssertionNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

final class UnalignedChunkRememberedSet {
    private UnalignedChunkRememberedSet() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getHeaderSize(UnsignedWord objectSize) {
        UnsignedWord headerSize = UnalignedChunkRememberedSet.getCardTableLimitOffset(objectSize);
        headerSize = headerSize.add(UnalignedChunkRememberedSet.sizeOfObjectStartOffsetField());
        UnsignedWord alignment = Word.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(headerSize, alignment);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setObjectStartOffset(HostedByteBufferPointer chunk, UnsignedWord objectStartOffset) {
        chunk.writeWord((WordBase)objectStartOffset.subtract(UnalignedChunkRememberedSet.sizeOfObjectStartOffsetField()), (WordBase)objectStartOffset);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setObjectStartOffset(UnalignedHeapChunk.UnalignedHeader chunk, UnsignedWord objectStartOffset) {
        HeapChunk.asPointer(chunk).writeWord((WordBase)objectStartOffset.subtract(UnalignedChunkRememberedSet.sizeOfObjectStartOffsetField()), (WordBase)objectStartOffset);
        assert (UnalignedChunkRememberedSet.getObjectStartOffset(chunk).equal(objectStartOffset));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getObjectStartOffset(UnalignedHeapChunk.UnalignedHeader chunk) {
        UnsignedWord alignment = Word.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        UnsignedWord headerSize = UnalignedChunkRememberedSet.getCardTableStartOffset();
        UnsignedWord objectStartOffsetSize = Word.unsigned((int)UnalignedChunkRememberedSet.sizeOfObjectStartOffsetField());
        UnsignedWord alignedObjectStartOffsetSize = UnsignedUtils.roundUp(objectStartOffsetSize, alignment);
        UnsignedWord ctAndObjSize = chunk.getEndOffset().subtract(headerSize).subtract(alignedObjectStartOffsetSize);
        UnsignedWord objSizeWithCtAlignment = ctAndObjSize.multiply(512).unsignedDivide(513);
        UnsignedWord objSize = UnsignedUtils.roundDown(objSizeWithCtAlignment, alignment);
        UnsignedWord objectStartOffset = HeapChunk.getEndOffset(chunk).subtract(objSize);
        assert (objectStartOffset.equal(UnalignedChunkRememberedSet.getOffsetForObject(HeapChunk.asPointer(chunk).add(objectStartOffset))));
        return objectStartOffset;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getOffsetForObject(Pointer objPtr) {
        return (UnsignedWord)objPtr.readWord(-UnalignedChunkRememberedSet.sizeOfObjectStartOffsetField());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void enableRememberedSet(HostedByteBufferPointer chunk, UnsignedWord objectSize) {
        CardTable.cleanTable(UnalignedChunkRememberedSet.getCardTableStart(chunk), UnalignedChunkRememberedSet.getCardTableSize(objectSize));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void enableRememberedSet(UnalignedHeapChunk.UnalignedHeader chunk) {
        CardTable.cleanTable(UnalignedChunkRememberedSet.getCardTableStart(chunk), UnalignedChunkRememberedSet.getCardTableSize(chunk));
        Object obj = UnalignedHeapChunk.getObjectStart(chunk).toObjectNonNull();
        ObjectHeaderImpl.setRememberedSetBit(obj);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void clearRememberedSet(UnalignedHeapChunk.UnalignedHeader chunk) {
        CardTable.cleanTable(UnalignedChunkRememberedSet.getCardTableStart(chunk), UnalignedChunkRememberedSet.getCardTableSize(chunk));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void dirtyCardForObject(Object obj, Pointer address, boolean verifyOnly) {
        UnalignedHeapChunk.UnalignedHeader chunk = UnalignedHeapChunk.getEnclosingChunk(obj);
        Pointer cardTableStart = UnalignedChunkRememberedSet.getCardTableStart(chunk);
        UnsignedWord objectIndex = CardTable.memoryOffsetToIndex((UnsignedWord)address.subtract((UnsignedWord)Word.objectToUntrackedPointer((Object)obj)));
        if (verifyOnly) {
            AssertionNode.assertion((boolean)false, (boolean)CardTable.isDirty(cardTableStart, objectIndex), (String)"card must be dirty", (Object)"", (Object)"", (long)0L, (long)0L);
        } else {
            CardTable.setDirty(cardTableStart, objectIndex);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void dirtyCardRangeForObject(Object obj, Pointer startAddress, Pointer endAddress) {
        UnalignedHeapChunk.UnalignedHeader chunk = UnalignedHeapChunk.getEnclosingChunk(obj);
        Pointer cardTableStart = UnalignedChunkRememberedSet.getCardTableStart(chunk);
        Word objPtr = Word.objectToUntrackedPointer((Object)obj);
        UnsignedWord startIndex = CardTable.memoryOffsetToIndex((UnsignedWord)startAddress.subtract((UnsignedWord)objPtr));
        UnsignedWord endIndex = CardTable.memoryOffsetToIndex((UnsignedWord)endAddress.subtract((UnsignedWord)objPtr));
        UnsignedWord curIndex = startIndex;
        do {
            CardTable.setDirty(cardTableStart, curIndex);
        } while (GraalDirectives.injectIterationCount((double)10.0, (boolean)(curIndex = curIndex.add(1)).belowOrEqual(endIndex)));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void dirtyAllReferencesOf(Object obj) {
        DynamicHub hub = KnownIntrinsics.readHub(obj);
        int hubType = hub.getHubType();
        Word objPtr = Word.objectToUntrackedPointer((Object)obj);
        Pointer chunk = objPtr.subtract(UnalignedChunkRememberedSet.getOffsetForObject((Pointer)objPtr));
        switch (hubType) {
            case 3: {
                if (!ContinuationSupport.isSupported()) {
                    throw VMError.shouldNotReachHere("Stored continuation objects cannot be in the heap if the continuation support is disabled.");
                }
                VMError.guarantee(StoredContinuationAccess.isInitialized((StoredContinuation)obj), "The stored continuation is still being initialized and does not contain valid stack data yet.");
                CardTable.setDirty(UnalignedChunkRememberedSet.getCardTableStart(chunk), (UnsignedWord)Word.zero());
                return;
            }
            case 5: {
                return;
            }
            case 6: {
                CardTable.dirtyTable(UnalignedChunkRememberedSet.getCardTableStart(chunk), UnalignedChunkRememberedSet.getCardTableSize((Pointer)objPtr));
                return;
            }
        }
        throw VMError.shouldNotReachHere("Unexpected hub type.");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void walkDirtyObjects(UnalignedHeapChunk.UnalignedHeader chunk, UninterruptibleObjectReferenceVisitor refVisitor, boolean clean) {
        UnsignedWord objStartOffset = UnalignedChunkRememberedSet.getObjectStartOffset(chunk);
        Object obj = HeapChunk.asPointer(chunk).add(objStartOffset).toObjectNonNull();
        DynamicHub objHub = ObjectHeader.readDynamicHubFromObject(obj);
        if (objHub.getHubType() == 5) {
            return;
        }
        Pointer cardTableStart = UnalignedChunkRememberedSet.getCardTableStart(chunk);
        assert (cardTableStart.unsignedRemainder(UnalignedChunkRememberedSet.wordSize()).equal(0));
        switch (objHub.getHubType()) {
            case 3: {
                UnalignedChunkRememberedSet.walkStoredContinuationImprecise((StoredContinuation)obj, cardTableStart, refVisitor, clean);
                return;
            }
            case 6: {
                UnsignedWord cardTableLimitIdx = objStartOffset.subtract(UnalignedChunkRememberedSet.sizeOfObjectStartOffsetField()).subtract(UnalignedChunkRememberedSet.getCardTableStartOffset());
                UnalignedChunkRememberedSet.walkObjectArrayPrecise(obj, cardTableStart, cardTableLimitIdx, refVisitor, clean);
                return;
            }
        }
        throw VMError.shouldNotReachHere("Unexpected hub type.");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void walkStoredContinuationImprecise(StoredContinuation s, Pointer cardTableStart, UninterruptibleObjectReferenceVisitor refVisitor, boolean clean) {
        if (!ContinuationSupport.isSupported()) {
            throw VMError.shouldNotReachHere("Stored continuation objects cannot be in the heap if the continuation support is disabled.");
        }
        if (StoredContinuationAccess.shouldWalkContinuation(s) && CardTable.isDirty(cardTableStart, (UnsignedWord)Word.zero())) {
            if (clean) {
                CardTable.setClean(cardTableStart, (UnsignedWord)Word.zero());
            }
            InteriorObjRefWalker.walkObjectInline(s, refVisitor);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void walkObjectArrayPrecise(Object obj, Pointer cardTableStart, UnsignedWord cardTableLimitIdx, UninterruptibleObjectReferenceVisitor refVisitor, boolean clean) {
        UnsignedWord dirtyCardEnd;
        UnsignedWord dirtyCardStart;
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        boolean isCompressed = ReferenceAccess.singleton().haveCompressedReferences();
        DynamicHub objHub = ObjectHeader.readDynamicHubFromObject(obj);
        int length = ArrayLengthNode.arrayLength((Object)obj);
        int layoutEncoding = objHub.getLayoutEncoding();
        UnsignedWord elementStartOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, 0);
        UnsignedWord elementEndOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, length);
        UnsignedWord iOffset = elementStartOffset;
        while (iOffset.belowThan(elementEndOffset) && !(dirtyCardStart = UnalignedChunkRememberedSet.findFirstDirtyCard(cardTableStart, CardTable.memoryOffsetToIndex(iOffset), cardTableLimitIdx)).equal(dirtyCardEnd = UnalignedChunkRememberedSet.findFirstCleanCard(cardTableStart, dirtyCardStart, cardTableLimitIdx, clean))) {
            UnsignedWord dirtyStartOffset = dirtyCardStart.multiply(512);
            UnsignedWord dirtyEndOffset = dirtyCardEnd.multiply(512);
            UnsignedWord startOffset = UnsignedUtils.max(dirtyStartOffset, elementStartOffset);
            UnsignedWord endOffset = UnsignedUtils.min(dirtyEndOffset, elementEndOffset);
            Word refPtr = Word.objectToUntrackedPointer((Object)obj).add(startOffset);
            UnsignedWord nReferences = endOffset.subtract(startOffset).unsignedDivide(referenceSize);
            refVisitor.visitObjectReferences((Pointer)refPtr, isCompressed, referenceSize, obj, UnsignedUtils.safeToInt(nReferences));
            iOffset = dirtyEndOffset;
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/hotspot/share/gc/g1/g1RemSet.cpp#L562-L586")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord findFirstDirtyCard(Pointer ctAdr, UnsignedWord startIdx, UnsignedWord endIdx) {
        assert (UnsignedUtils.isAMultiple(endIdx, Word.unsigned((int)UnalignedChunkRememberedSet.wordSize())));
        UnsignedWord wordSize = Word.unsigned((int)UnalignedChunkRememberedSet.wordSize());
        UnsignedWord curIdx = startIdx;
        while (!UnsignedUtils.isAMultiple(curIdx, wordSize)) {
            if (CardTable.isDirty(ctAdr, curIdx)) {
                return curIdx;
            }
            curIdx = curIdx.add(1);
        }
        while (curIdx.belowThan(endIdx)) {
            UnsignedWord wordValue = (UnsignedWord)ctAdr.readWord((WordBase)curIdx);
            if (wordValue.notEqual(CardTable.CLEAN_WORD)) {
                for (int i = 0; i < UnalignedChunkRememberedSet.wordSize(); ++i) {
                    if (CardTable.isDirty(ctAdr, curIdx)) {
                        return curIdx;
                    }
                    curIdx = curIdx.add(1);
                }
                VMError.shouldNotReachHere("should have returned early");
            }
            curIdx = curIdx.add(wordSize);
        }
        return endIdx;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/hotspot/share/gc/g1/g1RemSet.cpp#L588-L612")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord findFirstCleanCard(Pointer ctAdr, UnsignedWord startIdx, UnsignedWord endIdx, boolean clean) {
        assert (UnsignedUtils.isAMultiple(endIdx, Word.unsigned((int)UnalignedChunkRememberedSet.wordSize())));
        UnsignedWord wordSize = Word.unsigned((int)UnalignedChunkRememberedSet.wordSize());
        UnsignedWord curIdx = startIdx;
        while (!UnsignedUtils.isAMultiple(curIdx, wordSize)) {
            if (!CardTable.isDirty(ctAdr, curIdx)) {
                return curIdx;
            }
            if (clean) {
                CardTable.setClean(ctAdr, curIdx);
            }
            curIdx = curIdx.add(1);
        }
        while (curIdx.belowThan(endIdx)) {
            UnsignedWord wordValue = (UnsignedWord)ctAdr.readWord((WordBase)curIdx);
            if (wordValue.notEqual(CardTable.DIRTY_WORD)) {
                for (int i = 0; i < UnalignedChunkRememberedSet.wordSize(); ++i) {
                    if (!CardTable.isDirty(ctAdr, curIdx)) {
                        return curIdx;
                    }
                    curIdx = curIdx.add(1);
                }
                VMError.shouldNotReachHere("should have early-returned");
            }
            if (clean) {
                ctAdr.writeWord((WordBase)curIdx, (WordBase)CardTable.CLEAN_WORD);
            }
            curIdx = curIdx.add(wordSize);
        }
        return endIdx;
    }

    public static boolean verify(UnalignedHeapChunk.UnalignedHeader chunk) {
        return CardTable.verify(UnalignedChunkRememberedSet.getCardTableStart(chunk), UnalignedChunkRememberedSet.getCardTableEnd(chunk), UnalignedHeapChunk.getObjectStart(chunk), HeapChunk.getTopPointer(chunk));
    }

    public static boolean usePreciseCardMarking(Object obj) {
        return !(obj instanceof StoredContinuation);
    }

    @Fold
    static UnsignedWord getCardTableStartOffset() {
        UnsignedWord headerSize = Word.unsigned((int)SizeOf.get(UnalignedHeapChunk.UnalignedHeader.class));
        UnsignedWord alignment = Word.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(headerSize, alignment);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getCardTableSize(UnsignedWord objectSize) {
        UnsignedWord requiredSize = CardTable.tableSizeForMemorySize(objectSize);
        UnsignedWord alignment = Word.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(requiredSize, alignment);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getCardTableSize(UnalignedHeapChunk.UnalignedHeader chunk) {
        return UnalignedChunkRememberedSet.getObjectStartOffset(chunk).subtract(UnalignedChunkRememberedSet.sizeOfObjectStartOffsetField()).subtract(UnalignedChunkRememberedSet.getCardTableStartOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getCardTableSize(Pointer obj) {
        return UnalignedChunkRememberedSet.getOffsetForObject(obj).subtract(UnalignedChunkRememberedSet.sizeOfObjectStartOffsetField()).subtract(UnalignedChunkRememberedSet.getCardTableStartOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getCardTableLimitOffset(UnsignedWord objectSize) {
        UnsignedWord tableStart = UnalignedChunkRememberedSet.getCardTableStartOffset();
        UnsignedWord tableSize = UnalignedChunkRememberedSet.getCardTableSize(objectSize);
        UnsignedWord tableLimit = tableStart.add(tableSize);
        UnsignedWord alignment = Word.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(tableLimit, alignment);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer getCardTableStart(UnalignedHeapChunk.UnalignedHeader chunk) {
        return UnalignedChunkRememberedSet.getCardTableStart(HeapChunk.asPointer(chunk));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer getCardTableStart(Pointer chunk) {
        return chunk.add(UnalignedChunkRememberedSet.getCardTableStartOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer getCardTableEnd(UnalignedHeapChunk.UnalignedHeader chunk) {
        return UnalignedChunkRememberedSet.getCardTableStart(chunk).add(UnalignedChunkRememberedSet.getCardTableSize(UnalignedChunkRememberedSet.getObjectStartOffset(chunk).subtract(UnalignedChunkRememberedSet.sizeOfObjectStartOffsetField())));
    }

    @Fold
    static int wordSize() {
        return ConfigurationValues.getTarget().wordSize;
    }

    @Fold
    static int sizeOfObjectStartOffsetField() {
        return UnalignedChunkRememberedSet.wordSize();
    }
}

