/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.configure.ConfigurationFile;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.allocationprofile.AllocationCounter;
import com.oracle.svm.core.allocationprofile.AllocationSite;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.nodes.NewPodInstanceNode;
import com.oracle.svm.core.graal.nodes.NewStoredContinuationNode;
import com.oracle.svm.core.graal.nodes.SubstrateNewDynamicHubNode;
import com.oracle.svm.core.graal.nodes.SubstrateNewHybridInstanceNode;
import com.oracle.svm.core.graal.snippets.GCAllocationSupport;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.Pod;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.hub.RuntimeClassLoading;
import com.oracle.svm.core.identityhashcode.IdentityHashCodeSupport;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.reflect.MissingReflectionRegistrationUtils;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.PiArrayNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnreachableNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.extended.ForeignCallWithExceptionNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.java.DynamicNewArrayNode;
import jdk.graal.compiler.nodes.java.DynamicNewArrayWithExceptionNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceWithExceptionNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.NewArrayWithExceptionNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.NewInstanceWithExceptionNode;
import jdk.graal.compiler.nodes.java.NewMultiArrayNode;
import jdk.graal.compiler.nodes.java.NewMultiArrayWithExceptionNode;
import jdk.graal.compiler.nodes.java.ValidateNewInstanceClassNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.AllocationSnippets;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.replacements.SnippetCounter;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.word.BarrieredAccess;
import jdk.graal.compiler.word.ObjectAccess;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class SubstrateAllocationSnippets
extends AllocationSnippets {
    public static final LocationIdentity TLAB_START_IDENTITY = NamedLocationIdentity.mutable((String)"TLAB.start");
    public static final LocationIdentity TLAB_TOP_IDENTITY = NamedLocationIdentity.mutable((String)"TLAB.top");
    public static final LocationIdentity TLAB_END_IDENTITY = NamedLocationIdentity.mutable((String)"TLAB.end");
    public static final Object[] ALLOCATION_LOCATIONS = new Object[]{TLAB_START_IDENTITY, TLAB_TOP_IDENTITY, TLAB_END_IDENTITY, IdentityHashCodeSupport.IDENTITY_HASHCODE_SALT_LOCATION, AllocationCounter.COUNT_FIELD, AllocationCounter.SIZE_FIELD};
    public static final LocationIdentity[] GC_LOCATIONS = new LocationIdentity[]{TLAB_START_IDENTITY, TLAB_TOP_IDENTITY, TLAB_END_IDENTITY, IdentityHashCodeSupport.IDENTITY_HASHCODE_SALT_LOCATION};
    private static final SnippetRuntime.SubstrateForeignCallDescriptor NEW_MULTI_ARRAY = SnippetRuntime.findForeignCall(SubstrateAllocationSnippets.class, "newMultiArrayStub", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_PATH_HUB_OR_UNSAFE_INSTANTIATE_ERROR = SnippetRuntime.findForeignCall(SubstrateAllocationSnippets.class, "slowPathHubOrUnsafeInstantiationError", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor ARRAY_HUB_ERROR = SnippetRuntime.findForeignCall(SubstrateAllocationSnippets.class, "arrayHubErrorStub", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{NEW_MULTI_ARRAY, SLOW_PATH_HUB_OR_UNSAFE_INSTANTIATE_ERROR, ARRAY_HUB_ERROR};

    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(FOREIGN_CALLS);
    }

    @Snippet
    protected Object allocateInstance(@Snippet.NonNullParameter DynamicHub hub, @Snippet.ConstantParameter long size, @Snippet.ConstantParameter boolean forceSlowPath, @Snippet.ConstantParameter AllocationSnippets.FillContent fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter AllocationSnippets.AllocationProfilingData profilingData, @Snippet.ConstantParameter boolean withException) {
        Object result = this.allocateInstanceImpl(SubstrateAllocationSnippets.encodeAsTLABObjectHeader(hub), Word.unsigned((long)size), forceSlowPath, fillContents, emitMemoryBarrier, true, profilingData, withException);
        return PiNode.piCastToSnippetReplaceeStamp((Object)result);
    }

    @Snippet
    protected Object allocateInstanceConstantHeader(long objectHeader, @Snippet.ConstantParameter long size, @Snippet.ConstantParameter boolean forceSlowPath, @Snippet.ConstantParameter AllocationSnippets.FillContent fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter AllocationSnippets.AllocationProfilingData profilingData, @Snippet.ConstantParameter boolean withException) {
        Object result = this.allocateInstanceImpl((Word)Word.unsigned((long)objectHeader), Word.unsigned((long)size), forceSlowPath, fillContents, emitMemoryBarrier, true, profilingData, withException);
        return PiNode.piCastToSnippetReplaceeStamp((Object)result);
    }

    @Snippet
    public Object allocateArray(@Snippet.NonNullParameter DynamicHub hub, int length, @Snippet.ConstantParameter boolean forceSlowPath, @Snippet.ConstantParameter int arrayBaseOffset, @Snippet.ConstantParameter int log2ElementSize, @Snippet.ConstantParameter AllocationSnippets.FillContent fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter boolean maybeUnroll, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter boolean supportsOptimizedFilling, @Snippet.ConstantParameter AllocationSnippets.AllocationProfilingData profilingData, @Snippet.ConstantParameter boolean withException) {
        Object result = this.allocateArrayImpl(SubstrateAllocationSnippets.encodeAsTLABObjectHeader(hub), length, forceSlowPath, arrayBaseOffset, log2ElementSize, fillContents, SubstrateAllocationSnippets.afterArrayLengthOffset(), emitMemoryBarrier, maybeUnroll, supportsBulkZeroing, supportsOptimizedFilling, profilingData, withException);
        return PiArrayNode.piArrayCastToSnippetReplaceeStamp((Object)result, (int)length);
    }

    @Snippet
    public Object allocateArrayConstantHeader(long objectHeader, int length, @Snippet.ConstantParameter boolean forceSlowPath, @Snippet.ConstantParameter int arrayBaseOffset, @Snippet.ConstantParameter int log2ElementSize, @Snippet.ConstantParameter AllocationSnippets.FillContent fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter boolean maybeUnroll, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter boolean supportsOptimizedFilling, @Snippet.ConstantParameter AllocationSnippets.AllocationProfilingData profilingData, @Snippet.ConstantParameter boolean withException) {
        Object result = this.allocateArrayImpl((Word)Word.unsigned((long)objectHeader), length, forceSlowPath, arrayBaseOffset, log2ElementSize, fillContents, SubstrateAllocationSnippets.afterArrayLengthOffset(), emitMemoryBarrier, maybeUnroll, supportsBulkZeroing, supportsOptimizedFilling, profilingData, withException);
        return PiArrayNode.piArrayCastToSnippetReplaceeStamp((Object)result, (int)length);
    }

    @Snippet
    public Object allocateStoredContinuation(@Snippet.NonNullParameter DynamicHub hub, int length, @Snippet.ConstantParameter boolean forceSlowPath, @Snippet.ConstantParameter int arrayBaseOffset, @Snippet.ConstantParameter int log2ElementSize, @Snippet.ConstantParameter long ipOffset, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter AllocationSnippets.AllocationProfilingData profilingData) {
        Object result;
        Word thread = this.getTLABInfo();
        Word top = this.readTlabTop(thread);
        Word end = this.readTlabEnd(thread);
        ReplacementsUtil.dynamicAssert((boolean)end.subtract(top).belowOrEqual(Integer.MAX_VALUE), (String)"TLAB is too large");
        UnsignedWord allocationSize = this.arrayAllocationSize(length, arrayBaseOffset, log2ElementSize);
        Word newTop = top.add(allocationSize);
        if (!forceSlowPath && this.useTLAB() && BranchProbabilityNode.probability((double)0.99, (boolean)this.shouldAllocateInTLAB(allocationSize, true)) && BranchProbabilityNode.probability((double)0.99, (boolean)newTop.belowOrEqual(end))) {
            this.writeTlabTop(thread, newTop);
            this.emitPrefetchAllocate(newTop, true);
            result = this.formatStoredContinuation(SubstrateAllocationSnippets.encodeAsTLABObjectHeader(hub), allocationSize, length, top, emitMemoryBarrier, ipOffset, profilingData.snippetCounters);
        } else {
            profilingData.snippetCounters.stub.inc();
            result = SubstrateAllocationSnippets.callSlowNewStoredContinuation(SubstrateAllocationSnippets.gcAllocationSupport().getNewStoredContinuationStub(), SubstrateAllocationSnippets.encodeAsTLABObjectHeader(hub), length);
        }
        this.profileAllocation(profilingData, allocationSize);
        return PiArrayNode.piArrayCastToSnippetReplaceeStamp((Object)this.verifyOop(result), (int)length);
    }

    @Snippet
    public Object allocatePod(@Snippet.NonNullParameter DynamicHub hub, int arrayLength, @Snippet.ConstantParameter boolean forceSlowPath, byte[] referenceMap, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter boolean maybeUnroll, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter boolean supportsOptimizedFilling, @Snippet.ConstantParameter AllocationSnippets.AllocationProfilingData profilingData) {
        Object result;
        Word thread = this.getTLABInfo();
        Word top = this.readTlabTop(thread);
        Word end = this.readTlabEnd(thread);
        ReplacementsUtil.dynamicAssert((boolean)end.subtract(top).belowOrEqual(Integer.MAX_VALUE), (String)"TLAB is too large");
        int arrayBaseOffset = LayoutEncoding.getArrayBaseOffsetAsInt(hub.getLayoutEncoding());
        UnsignedWord allocationSize = this.arrayAllocationSize(arrayLength, arrayBaseOffset, 0);
        Word newTop = top.add(allocationSize);
        if (!forceSlowPath && this.useTLAB() && BranchProbabilityNode.probability((double)0.99, (boolean)this.shouldAllocateInTLAB(allocationSize, true)) && BranchProbabilityNode.probability((double)0.99, (boolean)newTop.belowOrEqual(end))) {
            this.writeTlabTop(thread, newTop);
            this.emitPrefetchAllocate(newTop, true);
            result = this.formatPod(SubstrateAllocationSnippets.encodeAsTLABObjectHeader(hub), hub, allocationSize, arrayLength, referenceMap, top, AllocationSnippets.FillContent.WITH_ZEROES, emitMemoryBarrier, maybeUnroll, supportsBulkZeroing, supportsOptimizedFilling, profilingData.snippetCounters);
        } else {
            profilingData.snippetCounters.stub.inc();
            result = SubstrateAllocationSnippets.callSlowNewPodInstance(SubstrateAllocationSnippets.gcAllocationSupport().getNewPodInstanceStub(), SubstrateAllocationSnippets.encodeAsTLABObjectHeader(hub), arrayLength, referenceMap);
        }
        this.profileAllocation(profilingData, allocationSize);
        return PiArrayNode.piArrayCastToSnippetReplaceeStamp((Object)this.verifyOop(result), (int)arrayLength);
    }

    @Snippet
    public Object allocateDynamicHub(int vTableEntries, @Snippet.ConstantParameter int vTableBaseOffset, @Snippet.ConstantParameter int log2VTableEntrySize, @Snippet.ConstantParameter AllocationSnippets.AllocationProfilingData profilingData) {
        profilingData.snippetCounters.stub.inc();
        Object result = SubstrateAllocationSnippets.callNewDynamicHub(SubstrateAllocationSnippets.gcAllocationSupport().getNewDynamicHub(), vTableEntries);
        UnsignedWord allocationSize = this.arrayAllocationSize(vTableEntries, vTableBaseOffset, log2VTableEntrySize);
        this.profileAllocation(profilingData, allocationSize);
        return PiArrayNode.piArrayCastToSnippetReplaceeStamp((Object)this.verifyOop(result), (int)vTableEntries);
    }

    @Snippet
    public Object allocateInstanceDynamic(@Snippet.NonNullParameter DynamicHub hub, @Snippet.ConstantParameter boolean forceSlowPath, @Snippet.ConstantParameter AllocationSnippets.FillContent fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter boolean supportsOptimizedFilling, @Snippet.ConstantParameter AllocationSnippets.AllocationProfilingData profilingData, @Snippet.ConstantParameter boolean withException) {
        return this.allocateInstanceDynamicImpl(hub, forceSlowPath, fillContents, emitMemoryBarrier, supportsBulkZeroing, supportsOptimizedFilling, profilingData, withException);
    }

    protected Object allocateInstanceDynamicImpl(DynamicHub hub, boolean forceSlowPath, AllocationSnippets.FillContent fillContents, boolean emitMemoryBarrier, boolean supportsBulkZeroing, boolean supportsOptimizedFilling, AllocationSnippets.AllocationProfilingData profilingData, boolean withException) {
        UnsignedWord size = LayoutEncoding.getPureInstanceAllocationSize(hub.getLayoutEncoding());
        Object result = this.allocateInstanceImpl(SubstrateAllocationSnippets.encodeAsTLABObjectHeader(hub), size, forceSlowPath, fillContents, emitMemoryBarrier, false, profilingData, withException);
        return PiNode.piCastToSnippetReplaceeStamp((Object)result);
    }

    @Snippet
    public Object allocateArrayDynamic(DynamicHub elementType, int length, @Snippet.ConstantParameter boolean forceSlowPath, @Snippet.ConstantParameter AllocationSnippets.FillContent fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter boolean supportsOptimizedFilling, @Snippet.ConstantParameter boolean withException, @Snippet.ConstantParameter AllocationSnippets.AllocationProfilingData profilingData) {
        DynamicHub checkedArrayHub = SubstrateAllocationSnippets.getCheckedArrayHub(elementType);
        int layoutEncoding = checkedArrayHub.getLayoutEncoding();
        int arrayBaseOffset = SubstrateAllocationSnippets.getArrayBaseOffset(layoutEncoding);
        int log2ElementSize = LayoutEncoding.getArrayIndexShift(layoutEncoding);
        Object result = this.allocateArrayImpl(SubstrateAllocationSnippets.encodeAsTLABObjectHeader(checkedArrayHub), length, forceSlowPath, arrayBaseOffset, log2ElementSize, fillContents, arrayBaseOffset, emitMemoryBarrier, false, supportsBulkZeroing, supportsOptimizedFilling, profilingData, withException);
        return PiArrayNode.piArrayCastToSnippetReplaceeStamp((Object)result, (int)length);
    }

    @Snippet
    protected Object newmultiarray(DynamicHub hub, @Snippet.ConstantParameter int rank, @Snippet.ConstantParameter boolean withException, @Snippet.VarargsParameter int[] dimensions) {
        return this.newMultiArrayImpl(Word.objectToUntrackedPointer((Object)hub), rank, withException, dimensions);
    }

    @Snippet
    public DynamicHub validateNewInstanceClass(DynamicHub hub) {
        DynamicHub nonNullHub;
        if (BranchProbabilityNode.probability((double)0.999999, (hub != null ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.999999, (boolean)(nonNullHub = (DynamicHub)PiNode.piCastNonNull((Object)hub, (GuardingNode)SnippetAnchorNode.anchor())).canUnsafeInstantiateAsInstanceFastPath())) {
            return nonNullHub;
        }
        DynamicHub slowPathStub = SubstrateAllocationSnippets.slowPathHubOrUnsafeInstantiationErrorStub(SLOW_PATH_HUB_OR_UNSAFE_INSTANTIATE_ERROR, DynamicHub.toClass(hub));
        return (DynamicHub)PiNode.piCastNonNull((Object)slowPathStub, (GuardingNode)SnippetAnchorNode.anchor());
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object newMultiArrayStub(Word dynamicHub, int rank, Word dimensionsStackValue) {
        DynamicHub hub = (DynamicHub)dynamicHub.toObject();
        return SubstrateAllocationSnippets.newMultiArrayRecursion(hub, rank, dimensionsStackValue);
    }

    private static Object newMultiArrayRecursion(DynamicHub hub, int rank, Word dimensionsStackValue) {
        int length = dimensionsStackValue.readInt(0);
        Object result = Array.newInstance(DynamicHub.toClass(hub.getComponentHub()), length);
        if (BranchProbabilityNode.probability((double)0.6, (rank > 1 ? 1 : 0) != 0)) {
            UnsignedWord offset = LayoutEncoding.getArrayBaseOffset(hub.getLayoutEncoding());
            UnsignedWord endOffset = LayoutEncoding.getArrayElementOffset(hub.getLayoutEncoding(), length);
            while (GraalDirectives.injectIterationCount((double)10.0, (boolean)offset.belowThan(endOffset))) {
                BarrieredAccess.writeObject((Object)result, (WordBase)offset, (Object)SubstrateAllocationSnippets.newMultiArrayRecursion(hub.getComponentHub(), rank - 1, dimensionsStackValue.add(4)));
                offset = offset.add(ConfigurationValues.getObjectLayout().getReferenceSize());
            }
        }
        return result;
    }

    @Node.NodeIntrinsic(value=ForeignCallWithExceptionNode.class)
    private static native DynamicHub slowPathHubOrUnsafeInstantiationErrorStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Class<?> var1);

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static DynamicHub slowPathHubOrUnsafeInstantiationError(DynamicHub hub) throws InstantiationException {
        if (hub == null) {
            throw new NullPointerException("Allocation type is null.");
        }
        if (!hub.isInstanceClass() || LayoutEncoding.isSpecial(hub.getLayoutEncoding())) {
            throw new InstantiationException("Can only allocate instance objects for concrete classes: " + DynamicHub.toClass(hub).getTypeName());
        }
        if (LayoutEncoding.isHybrid(hub.getLayoutEncoding())) {
            throw new InstantiationException("Cannot allocate objects of special hybrid types: " + DynamicHub.toClass(hub).getTypeName());
        }
        if (hub.canUnsafeInstantiateAsInstanceSlowPath()) {
            hub.setCanUnsafeAllocate();
            return hub;
        }
        if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
            MissingReflectionRegistrationUtils.reportUnsafeAllocation(DynamicHub.toClass(hub));
        }
        throw new IllegalArgumentException("Type " + DynamicHub.toClass(hub).getTypeName() + " is instantiated reflectively but was never registered. Register the type by adding \"unsafeAllocated\" for the type in " + ConfigurationFile.REFLECTION.getFileName() + ".");
    }

    private static DynamicHub getCheckedArrayHub(DynamicHub elementType) {
        DynamicHub nonNullArrayHub;
        DynamicHub nonNullElementType;
        DynamicHub arrayHub;
        if (BranchProbabilityNode.probability((double)0.999999, (elementType != null ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.999999, (elementType != DynamicHub.fromClass(Void.TYPE) ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.999999, ((arrayHub = (nonNullElementType = (DynamicHub)PiNode.piCastNonNull((Object)elementType, (GuardingNode)SnippetAnchorNode.anchor())).getArrayHub()) != null ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.999999, (boolean)(nonNullArrayHub = (DynamicHub)PiNode.piCastNonNull((Object)arrayHub, (GuardingNode)SnippetAnchorNode.anchor())).isInstantiated())) {
            return nonNullArrayHub;
        }
        SubstrateAllocationSnippets.callArrayHubErrorStub(ARRAY_HUB_ERROR, DynamicHub.toClass(elementType));
        throw UnreachableNode.unreachable();
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callArrayHubErrorStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Class<?> var1);

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void arrayHubErrorStub(DynamicHub elementType) {
        if (elementType == null) {
            throw new NullPointerException("Allocation type is null.");
        }
        if (elementType == DynamicHub.fromClass(Void.TYPE)) {
            throw new IllegalArgumentException("Cannot allocate void array.");
        }
        if (elementType.getArrayHub() == null || !elementType.getArrayHub().isInstantiated()) {
            throw MissingReflectionRegistrationUtils.reportArrayInstantiation(DynamicHub.toClass(elementType), 1);
        }
        VMError.shouldNotReachHereUnexpectedInput(elementType);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callSlowNewPodInstance(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, int var2, byte[] var3);

    public Object formatArray(Word hub, UnsignedWord allocationSize, int length, Word memory, AllocationSnippets.FillContent fillContents, boolean emitMemoryBarrier, boolean maybeUnroll, boolean supportsBulkZeroing, boolean supportsOptimizedFilling, AllocationSnippets.AllocationSnippetCounters snippetCounters) {
        return this.formatArray(hub, allocationSize, length, memory, fillContents, emitMemoryBarrier, SubstrateAllocationSnippets.afterArrayLengthOffset(), maybeUnroll, supportsBulkZeroing, supportsOptimizedFilling, snippetCounters);
    }

    public Object formatStoredContinuation(Word objectHeader, UnsignedWord allocationSize, int arrayLength, Word memory, boolean emitMemoryBarrier, long ipOffset, AllocationSnippets.AllocationSnippetCounters snippetCounters) {
        Object result = this.formatArray(objectHeader, allocationSize, arrayLength, memory, AllocationSnippets.FillContent.DO_NOT_FILL, false, false, false, false, snippetCounters);
        memory.writeWord((WordBase)Word.unsigned((long)ipOffset), (WordBase)Word.nullPointer(), LocationIdentity.init());
        this.emitMemoryBarrierIf(emitMemoryBarrier);
        return result;
    }

    public Object formatPod(Word objectHeader, DynamicHub hub, UnsignedWord allocationSize, int arrayLength, byte[] referenceMap, Word memory, AllocationSnippets.FillContent fillContents, boolean emitMemoryBarrier, boolean maybeUnroll, boolean supportsBulkZeroing, boolean supportsOptimizedFilling, AllocationSnippets.AllocationSnippetCounters snippetCounters) {
        Object result = this.formatArray(objectHeader, allocationSize, arrayLength, memory, fillContents, false, maybeUnroll, supportsBulkZeroing, supportsOptimizedFilling, snippetCounters);
        int fromOffset = ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.Byte);
        int toOffset = LayoutEncoding.getArrayBaseOffsetAsInt(hub.getLayoutEncoding()) + arrayLength - referenceMap.length;
        int i = 0;
        while (BranchProbabilityNode.probability((double)0.6, (i < referenceMap.length ? 1 : 0) != 0)) {
            byte b = ObjectAccess.readByte((Object)referenceMap, (int)(fromOffset + i), (LocationIdentity)SubstrateAllocationSnippets.byteArrayIdentity());
            ObjectAccess.writeByte((Object)result, (int)(toOffset + i), (byte)b, (LocationIdentity)LocationIdentity.INIT_LOCATION);
            ++i;
        }
        this.emitMemoryBarrierIf(emitMemoryBarrier);
        return result;
    }

    @Fold
    static LocationIdentity byteArrayIdentity() {
        return NamedLocationIdentity.getArrayLocation((JavaKind)JavaKind.Byte);
    }

    protected final int getPrefetchStyle() {
        return SubstrateOptions.getAllocatePrefetchStyle();
    }

    protected int getPrefetchLines(boolean isArray) {
        if (isArray) {
            return SubstrateOptions.AllocatePrefetchLines.getValue();
        }
        return SubstrateOptions.AllocateInstancePrefetchLines.getValue();
    }

    protected final int getPrefetchStepSize() {
        return SubstrateOptions.AllocatePrefetchStepSize.getValue();
    }

    protected final int getPrefetchDistance() {
        return SubstrateOptions.AllocatePrefetchDistance.getValue();
    }

    protected final int instanceHeaderSize() {
        return ConfigurationValues.getObjectLayout().getFirstFieldOffset();
    }

    @Fold
    public static int afterArrayLengthOffset() {
        return ConfigurationValues.getObjectLayout().getArrayLengthOffset() + ConfigurationValues.getObjectLayout().sizeInBytes(JavaKind.Int);
    }

    protected final void profileAllocation(AllocationSnippets.AllocationProfilingData profilingData, UnsignedWord size) {
        if (AllocationSite.Options.AllocationProfiling.getValue().booleanValue()) {
            SubstrateAllocationProfilingData svmProfilingData = (SubstrateAllocationProfilingData)profilingData;
            AllocationCounter allocationSiteCounter = svmProfilingData.allocationSiteCounter;
            allocationSiteCounter.incrementCount();
            allocationSiteCounter.incrementSize(size.rawValue());
        }
    }

    @Fold
    protected int getMinimalBulkZeroingSize() {
        return (Integer)GraalOptions.MinimalBulkZeroingSize.getValue(HostedOptionValues.singleton());
    }

    protected final Object verifyOop(Object obj) {
        return obj;
    }

    public final int arrayLengthOffset() {
        return ConfigurationValues.getObjectLayout().getArrayLengthOffset();
    }

    protected final int objectAlignment() {
        return ConfigurationValues.getObjectLayout().getAlignment();
    }

    public static int getArrayBaseOffset(int layoutEncoding) {
        return (int)LayoutEncoding.getArrayBaseOffset(layoutEncoding).rawValue();
    }

    public static Word encodeAsTLABObjectHeader(DynamicHub hub) {
        return Heap.getHeap().getObjectHeader().encodeAsTLABObjectHeader(hub);
    }

    protected final Object callNewInstanceStub(Word objectHeader, boolean withException) {
        if (withException) {
            return SubstrateAllocationSnippets.callSlowNewInstanceWithException(SubstrateAllocationSnippets.gcAllocationSupport().getNewInstanceStub(), objectHeader);
        }
        return SubstrateAllocationSnippets.callSlowNewInstance(SubstrateAllocationSnippets.gcAllocationSupport().getNewInstanceStub(), objectHeader);
    }

    protected final Object callNewArrayStub(Word objectHeader, int length, boolean withException) {
        if (withException) {
            return SubstrateAllocationSnippets.callSlowNewArrayWithException(SubstrateAllocationSnippets.gcAllocationSupport().getNewArrayStub(), objectHeader, length);
        }
        return SubstrateAllocationSnippets.callSlowNewArray(SubstrateAllocationSnippets.gcAllocationSupport().getNewArrayStub(), objectHeader, length);
    }

    protected final Object callNewMultiArrayStub(Word objectHeader, int rank, Word dims, boolean withException) {
        if (withException) {
            return SubstrateAllocationSnippets.callNewMultiArrayWithException(NEW_MULTI_ARRAY, objectHeader, rank, dims);
        }
        return SubstrateAllocationSnippets.callNewMultiArray(NEW_MULTI_ARRAY, objectHeader, rank, dims);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callSlowNewInstance(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1);

    @Node.NodeIntrinsic(value=ForeignCallWithExceptionNode.class)
    private static native Object callSlowNewInstanceWithException(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callSlowNewArray(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, int var2);

    @Node.NodeIntrinsic(value=ForeignCallWithExceptionNode.class)
    private static native Object callSlowNewArrayWithException(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, int var2);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callSlowNewStoredContinuation(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, int var2);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callNewDynamicHub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, int var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callNewMultiArray(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, int var2, Word var3);

    @Node.NodeIntrinsic(value=ForeignCallWithExceptionNode.class)
    private static native Object callNewMultiArrayWithException(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, int var2, Word var3);

    public void initializeObjectHeader(Word memory, Word objectHeader, boolean isArrayLike) {
        Heap.getHeap().getObjectHeader().initializeHeaderOfNewObjectInit((Pointer)memory, objectHeader, isArrayLike);
    }

    public boolean useTLAB() {
        return SubstrateAllocationSnippets.gcAllocationSupport().useTLAB();
    }

    protected boolean shouldAllocateInTLAB(UnsignedWord size, boolean isArray) {
        return SubstrateAllocationSnippets.gcAllocationSupport().shouldAllocateInTLAB(size, isArray);
    }

    public Word getTLABInfo() {
        return SubstrateAllocationSnippets.gcAllocationSupport().getTLABInfo();
    }

    public Word readTlabTop(Word tlabInfo) {
        return (Word)tlabInfo.readWord(SubstrateAllocationSnippets.gcAllocationSupport().tlabTopOffset(), TLAB_TOP_IDENTITY);
    }

    public Word readTlabEnd(Word tlabInfo) {
        return (Word)tlabInfo.readWord(SubstrateAllocationSnippets.gcAllocationSupport().tlabEndOffset(), TLAB_END_IDENTITY);
    }

    public void writeTlabTop(Word tlabInfo, Word newTop) {
        tlabInfo.writeWord(SubstrateAllocationSnippets.gcAllocationSupport().tlabTopOffset(), (WordBase)newTop, TLAB_TOP_IDENTITY);
    }

    @Fold
    static GCAllocationSupport gcAllocationSupport() {
        return (GCAllocationSupport)ImageSingletons.lookup(GCAllocationSupport.class);
    }

    public static DynamicHub ensureMarkedAsInstantiated(DynamicHub hub) {
        if (!hub.isInstantiated()) {
            throw VMError.shouldNotReachHere("Cannot allocate type that is not marked as instantiated: " + hub.getName());
        }
        return hub;
    }

    public static class SubstrateAllocationProfilingData
    extends AllocationSnippets.AllocationProfilingData {
        final AllocationCounter allocationSiteCounter;

        public SubstrateAllocationProfilingData(AllocationSnippets.AllocationSnippetCounters snippetCounters, AllocationCounter allocationSiteCounter) {
            super(snippetCounters);
            this.allocationSiteCounter = allocationSiteCounter;
        }
    }

    public static class Templates
    extends SubstrateTemplates {
        private final AllocationSnippets.AllocationSnippetCounters snippetCounters = new AllocationSnippets.AllocationSnippetCounters(SnippetCounter.Group.NullFactory);
        private final AllocationSnippets.AllocationProfilingData profilingData = new SubstrateAllocationProfilingData(this.snippetCounters, null);
        private final SnippetTemplate.SnippetInfo allocateInstance;
        private final SnippetTemplate.SnippetInfo allocateInstanceConstantHeader;
        private final SnippetTemplate.SnippetInfo allocateArray;
        private final SnippetTemplate.SnippetInfo allocateArrayConstantHeader;
        private final SnippetTemplate.SnippetInfo newmultiarray;
        private final SnippetTemplate.SnippetInfo allocateArrayDynamic;
        private final SnippetTemplate.SnippetInfo allocateInstanceDynamic;
        private final SnippetTemplate.SnippetInfo validateNewInstanceClass;
        private final SnippetTemplate.SnippetInfo allocateStoredContinuation;
        private final SnippetTemplate.SnippetInfo allocatePod;
        private final SnippetTemplate.SnippetInfo allocateDynamicHub;

        public Templates(OptionValues options, Providers providers, SubstrateAllocationSnippets receiver) {
            super(options, providers);
            this.allocateInstance = this.snippet(providers, SubstrateAllocationSnippets.class, "allocateInstance", null, (Object)receiver, ALLOCATION_LOCATIONS);
            this.allocateInstanceConstantHeader = this.snippet(providers, SubstrateAllocationSnippets.class, "allocateInstanceConstantHeader", null, (Object)receiver, ALLOCATION_LOCATIONS);
            this.allocateArray = this.snippet(providers, SubstrateAllocationSnippets.class, "allocateArray", null, (Object)receiver, ALLOCATION_LOCATIONS);
            this.allocateArrayConstantHeader = this.snippet(providers, SubstrateAllocationSnippets.class, "allocateArrayConstantHeader", null, (Object)receiver, ALLOCATION_LOCATIONS);
            this.allocateInstanceDynamic = this.snippet(providers, SubstrateAllocationSnippets.class, "allocateInstanceDynamic", null, (Object)receiver, ALLOCATION_LOCATIONS);
            this.allocateArrayDynamic = this.snippet(providers, SubstrateAllocationSnippets.class, "allocateArrayDynamic", null, (Object)receiver, ALLOCATION_LOCATIONS);
            this.newmultiarray = this.snippet(providers, SubstrateAllocationSnippets.class, "newmultiarray", null, (Object)receiver, ALLOCATION_LOCATIONS);
            this.validateNewInstanceClass = this.snippet(providers, SubstrateAllocationSnippets.class, "validateNewInstanceClass", null, (Object)receiver, ALLOCATION_LOCATIONS);
            SnippetTemplate.SnippetInfo allocateStoredContinuationSnippet = null;
            if (ContinuationSupport.isSupported()) {
                allocateStoredContinuationSnippet = this.snippet(providers, SubstrateAllocationSnippets.class, "allocateStoredContinuation", null, (Object)receiver, ALLOCATION_LOCATIONS);
            }
            this.allocateStoredContinuation = allocateStoredContinuationSnippet;
            SnippetTemplate.SnippetInfo allocatePodSnippet = null;
            if (Pod.RuntimeSupport.isPresent()) {
                Object[] podLocations = ALLOCATION_LOCATIONS;
                podLocations = Arrays.copyOf(podLocations, podLocations.length + 1);
                podLocations[podLocations.length - 1] = SubstrateAllocationSnippets.byteArrayIdentity();
                allocatePodSnippet = this.snippet(providers, SubstrateAllocationSnippets.class, "allocatePod", null, (Object)receiver, podLocations);
            }
            this.allocatePod = allocatePodSnippet;
            SnippetTemplate.SnippetInfo allocateDynamicHubSnippet = null;
            if (RuntimeClassLoading.isSupported()) {
                allocateDynamicHubSnippet = this.snippet(providers, SubstrateAllocationSnippets.class, "allocateDynamicHub", null, (Object)receiver, ALLOCATION_LOCATIONS);
            }
            this.allocateDynamicHub = allocateDynamicHubSnippet;
        }

        public void registerLowering(Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
            lowerings.put(NewInstanceNode.class, new NewInstanceLowering());
            lowerings.put(NewInstanceWithExceptionNode.class, new NewInstanceLowering());
            lowerings.put(SubstrateNewHybridInstanceNode.class, new NewHybridInstanceLowering());
            lowerings.put(NewArrayNode.class, new NewArrayLowering());
            lowerings.put(NewArrayWithExceptionNode.class, new NewArrayLowering());
            lowerings.put(DynamicNewInstanceNode.class, new DynamicNewInstanceLowering());
            lowerings.put(DynamicNewInstanceWithExceptionNode.class, new DynamicNewInstanceWithExceptionLowering());
            lowerings.put(DynamicNewArrayNode.class, new DynamicNewArrayLowering());
            lowerings.put(DynamicNewArrayWithExceptionNode.class, new DynamicNewArrayWithExceptionLowering());
            lowerings.put(NewMultiArrayNode.class, new NewMultiArrayLowering());
            lowerings.put(NewMultiArrayWithExceptionNode.class, new NewMultiArrayWithExceptionLowering());
            lowerings.put(ValidateNewInstanceClassNode.class, new ValidateNewInstanceClassLowering());
            if (ContinuationSupport.isSupported()) {
                lowerings.put(NewStoredContinuationNode.class, new NewStoredContinuationLowering());
            }
            if (Pod.RuntimeSupport.isPresent()) {
                lowerings.put(NewPodInstanceNode.class, new NewPodInstanceLowering());
            }
            if (RuntimeClassLoading.isSupported()) {
                lowerings.put(SubstrateNewDynamicHubNode.class, new NewDynamicHubLowering());
            }
        }

        public AllocationSnippets.AllocationSnippetCounters getSnippetCounters() {
            return this.snippetCounters;
        }

        public AllocationSnippets.AllocationProfilingData getProfilingData(ValueNode node, ResolvedJavaType type) {
            if (AllocationSite.Options.AllocationProfiling.getValue().booleanValue()) {
                return new SubstrateAllocationProfilingData(this.snippetCounters, Templates.createAllocationSiteCounter(node, type));
            }
            return this.profilingData;
        }

        private static AllocationCounter createAllocationSiteCounter(ValueNode node, ResolvedJavaType type) {
            String siteName = "[others]";
            if (node.getNodeSourcePosition() != null) {
                siteName = node.getNodeSourcePosition().getMethod().asStackTraceElement(node.getNodeSourcePosition().getBCI()).toString();
            }
            String className = "[dynamic]";
            if (type != null) {
                className = type.toJavaName(true);
            }
            AllocationSite allocationSite = AllocationSite.lookup(siteName, className);
            String counterName = node.graph().name;
            if (counterName == null) {
                counterName = node.graph().method().format("%H.%n(%p)");
            }
            return allocationSite.createCounter(counterName);
        }

        private static boolean shouldForceSlowPath(StructuredGraph graph) {
            return (Boolean)GraalOptions.ReduceCodeSize.getValue(graph.getOptions());
        }

        private final class NewInstanceLowering
        implements NodeLoweringProvider<FixedNode> {
            private NewInstanceLowering() {
            }

            @Override
            public void lower(FixedNode node, LoweringTool tool) {
                SnippetTemplate.Arguments args;
                boolean withException;
                boolean emitMemoryBarrier;
                boolean fillContents;
                SharedType type;
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage().areFrameStatesAtSideEffects()) {
                    return;
                }
                if (node instanceof NewInstanceNode) {
                    NewInstanceNode n = (NewInstanceNode)node;
                    type = (SharedType)n.instanceClass();
                    fillContents = n.fillContents();
                    emitMemoryBarrier = n.emitMemoryBarrier();
                    withException = false;
                } else if (node instanceof NewInstanceWithExceptionNode) {
                    NewInstanceWithExceptionNode n = (NewInstanceWithExceptionNode)node;
                    type = (SharedType)n.instanceClass();
                    fillContents = n.fillContents();
                    emitMemoryBarrier = n.emitMemoryBarrier();
                    withException = true;
                } else {
                    throw VMError.shouldNotReachHereUnexpectedInput(node);
                }
                DynamicHub hub = SubstrateAllocationSnippets.ensureMarkedAsInstantiated(type.getHub());
                long size = LayoutEncoding.getPureInstanceAllocationSize(hub.getLayoutEncoding()).rawValue();
                ValueNode objectHeaderConstant = Templates.this.snippetReflection.forTLABObjectHeader((Object)hub, graph);
                if (objectHeaderConstant != null) {
                    args = new SnippetTemplate.Arguments(Templates.this.allocateInstanceConstantHeader, graph.getGuardsStage(), tool.getLoweringStage());
                    args.add("objectHeader", (Object)objectHeaderConstant);
                } else {
                    ConstantNode hubConstant = ConstantNode.forConstant((JavaConstant)Templates.this.snippetReflection.forObject((Object)hub), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)graph);
                    args = new SnippetTemplate.Arguments(Templates.this.allocateInstance, graph.getGuardsStage(), tool.getLoweringStage());
                    args.add("hub", (Object)hubConstant);
                }
                args.add("size", (Object)size);
                args.add("forceSlowPath", (Object)Templates.shouldForceSlowPath(graph));
                args.add("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean((boolean)fillContents));
                args.add("emitMemoryBarrier", (Object)emitMemoryBarrier);
                args.add("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, type));
                args.add("withException", (Object)withException);
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private final class NewHybridInstanceLowering
        implements NodeLoweringProvider<SubstrateNewHybridInstanceNode> {
            private NewHybridInstanceLowering() {
            }

            @Override
            public void lower(SubstrateNewHybridInstanceNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage().areFrameStatesAtSideEffects()) {
                    return;
                }
                SharedType instanceClass = (SharedType)node.instanceClass();
                ValueNode length = node.length();
                DynamicHub hub = instanceClass.getHub();
                int layoutEncoding = hub.getLayoutEncoding();
                int arrayBaseOffset = LayoutEncoding.getArrayBaseOffsetAsInt(layoutEncoding);
                int log2ElementSize = LayoutEncoding.getArrayIndexShift(layoutEncoding);
                boolean fillContents = node.fillContents();
                assert (fillContents) : "fillContents must be true for hybrid allocations";
                ConstantNode hubConstant = ConstantNode.forConstant((JavaConstant)Templates.this.snippetReflection.forObject((Object)hub), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)graph);
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.allocateArray, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)hubConstant);
                args.add("length", length.isAlive() ? length : graph.addOrUniqueWithInputs((Node)length));
                args.add("forceSlowPath", (Object)Templates.shouldForceSlowPath(graph));
                args.add("arrayBaseOffset", (Object)arrayBaseOffset);
                args.add("log2ElementSize", (Object)log2ElementSize);
                args.add("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean((boolean)fillContents));
                args.add("emitMemoryBarrier", (Object)node.emitMemoryBarrier());
                args.add("maybeUnroll", (Object)length.isConstant());
                args.add("supportsBulkZeroing", (Object)tool.getLowerer().supportsBulkZeroingOfEden());
                args.add("supportsOptimizedFilling", (Object)tool.getLowerer().supportsOptimizedFilling(graph.getOptions()));
                args.add("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, instanceClass));
                args.add("withException", (Object)false);
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private final class NewArrayLowering
        implements NodeLoweringProvider<FixedNode> {
            private NewArrayLowering() {
            }

            @Override
            public void lower(FixedNode node, LoweringTool tool) {
                SnippetTemplate.Arguments args;
                boolean withException;
                boolean emitMemoryBarrier;
                boolean fillContents;
                SharedType type;
                ValueNode length;
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage().areFrameStatesAtSideEffects()) {
                    return;
                }
                if (node instanceof NewArrayNode) {
                    NewArrayNode n = (NewArrayNode)node;
                    length = n.length();
                    type = (SharedType)n.elementType().getArrayClass();
                    fillContents = n.fillContents();
                    emitMemoryBarrier = n.emitMemoryBarrier();
                    withException = false;
                } else if (node instanceof NewArrayWithExceptionNode) {
                    NewArrayWithExceptionNode n = (NewArrayWithExceptionNode)node;
                    length = n.length();
                    type = (SharedType)n.elementType().getArrayClass();
                    fillContents = n.fillContents();
                    emitMemoryBarrier = n.emitMemoryBarrier();
                    withException = true;
                } else {
                    throw VMError.shouldNotReachHereUnexpectedInput(node);
                }
                DynamicHub hub = SubstrateAllocationSnippets.ensureMarkedAsInstantiated(type.getHub());
                int layoutEncoding = hub.getLayoutEncoding();
                int arrayBaseOffset = SubstrateAllocationSnippets.getArrayBaseOffset(layoutEncoding);
                int log2ElementSize = LayoutEncoding.getArrayIndexShift(layoutEncoding);
                ValueNode objectHeaderConstant = Templates.this.snippetReflection.forTLABObjectHeader((Object)hub, graph);
                if (objectHeaderConstant != null) {
                    args = new SnippetTemplate.Arguments(Templates.this.allocateArrayConstantHeader, graph.getGuardsStage(), tool.getLoweringStage());
                    args.add("objectHeader", (Object)objectHeaderConstant);
                } else {
                    ConstantNode hubConstant = ConstantNode.forConstant((JavaConstant)Templates.this.snippetReflection.forObject((Object)hub), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)graph);
                    args = new SnippetTemplate.Arguments(Templates.this.allocateArray, graph.getGuardsStage(), tool.getLoweringStage());
                    args.add("hub", (Object)hubConstant);
                }
                args.add("length", length.isAlive() ? length : graph.addOrUniqueWithInputs((Node)length));
                args.add("forceSlowPath", (Object)Templates.shouldForceSlowPath(graph));
                args.add("arrayBaseOffset", (Object)arrayBaseOffset);
                args.add("log2ElementSize", (Object)log2ElementSize);
                args.add("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean((boolean)fillContents));
                args.add("emitMemoryBarrier", (Object)emitMemoryBarrier);
                args.add("maybeUnroll", (Object)length.isConstant());
                args.add("supportsBulkZeroing", (Object)tool.getLowerer().supportsBulkZeroingOfEden());
                args.add("supportsOptimizedFilling", (Object)tool.getLowerer().supportsOptimizedFilling(graph.getOptions()));
                args.add("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, type));
                args.add("withException", (Object)withException);
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private final class DynamicNewInstanceLowering
        implements NodeLoweringProvider<DynamicNewInstanceNode> {
            private DynamicNewInstanceLowering() {
            }

            @Override
            public void lower(DynamicNewInstanceNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage().areFrameStatesAtSideEffects()) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.allocateInstanceDynamic, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)node.getInstanceType());
                args.add("forceSlowPath", (Object)Templates.shouldForceSlowPath(graph));
                args.add("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean((boolean)node.fillContents()));
                args.add("emitMemoryBarrier", (Object)node.emitMemoryBarrier());
                args.add("supportsBulkZeroing", (Object)tool.getLowerer().supportsBulkZeroingOfEden());
                args.add("supportsOptimizedFilling", (Object)tool.getLowerer().supportsOptimizedFilling(graph.getOptions()));
                args.add("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, null));
                args.add("withException", (Object)false);
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private final class DynamicNewInstanceWithExceptionLowering
        implements NodeLoweringProvider<DynamicNewInstanceWithExceptionNode> {
            private DynamicNewInstanceWithExceptionLowering() {
            }

            @Override
            public void lower(DynamicNewInstanceWithExceptionNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage().areFrameStatesAtSideEffects()) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.allocateInstanceDynamic, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)node.getInstanceType());
                args.add("forceSlowPath", (Object)Templates.shouldForceSlowPath(graph));
                args.add("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean((boolean)true));
                args.add("emitMemoryBarrier", (Object)true);
                args.add("supportsBulkZeroing", (Object)tool.getLowerer().supportsBulkZeroingOfEden());
                args.add("supportsOptimizedFilling", (Object)tool.getLowerer().supportsOptimizedFilling(graph.getOptions()));
                args.add("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, null));
                args.add("withException", (Object)true);
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private final class DynamicNewArrayLowering
        implements NodeLoweringProvider<DynamicNewArrayNode> {
            private DynamicNewArrayLowering() {
            }

            @Override
            public void lower(DynamicNewArrayNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage().areFrameStatesAtSideEffects()) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.allocateArrayDynamic, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("elementType", (Object)node.getElementType());
                args.add("length", (Object)node.length());
                args.add("forceSlowPath", (Object)Templates.shouldForceSlowPath(graph));
                args.add("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean((boolean)node.fillContents()));
                args.add("emitMemoryBarrier", (Object)node.emitMemoryBarrier());
                args.add("supportsBulkZeroing", (Object)tool.getLowerer().supportsBulkZeroingOfEden());
                args.add("supportsOptimizedFilling", (Object)tool.getLowerer().supportsOptimizedFilling(graph.getOptions()));
                args.add("withException", (Object)false);
                args.add("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, null));
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private final class DynamicNewArrayWithExceptionLowering
        implements NodeLoweringProvider<DynamicNewArrayWithExceptionNode> {
            private DynamicNewArrayWithExceptionLowering() {
            }

            @Override
            public void lower(DynamicNewArrayWithExceptionNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage().areFrameStatesAtSideEffects()) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.allocateArrayDynamic, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("elementType", (Object)node.getElementType());
                args.add("length", (Object)node.length());
                args.add("forceSlowPath", (Object)Templates.shouldForceSlowPath(graph));
                args.add("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean((boolean)true));
                args.add("emitMemoryBarrier", (Object)true);
                args.add("supportsBulkZeroing", (Object)tool.getLowerer().supportsBulkZeroingOfEden());
                args.add("supportsOptimizedFilling", (Object)tool.getLowerer().supportsOptimizedFilling(graph.getOptions()));
                args.add("withException", (Object)true);
                args.add("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, null));
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private final class NewMultiArrayLowering
        implements NodeLoweringProvider<NewMultiArrayNode> {
            private NewMultiArrayLowering() {
            }

            @Override
            public void lower(NewMultiArrayNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage().areFrameStatesAtSideEffects()) {
                    return;
                }
                int rank = node.dimensionCount();
                ValueNode[] dims = new ValueNode[rank];
                for (int i = 0; i < node.dimensionCount(); ++i) {
                    dims[i] = node.dimension(i);
                }
                SharedType type = (SharedType)node.type();
                ConstantNode hubConstant = ConstantNode.forConstant((JavaConstant)Templates.this.snippetReflection.forObject((Object)type.getHub()), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)graph);
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.newmultiarray, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)hubConstant);
                args.add("rank", (Object)rank);
                args.add("withException", (Object)false);
                args.addVarargs("dimensions", Integer.TYPE, StampFactory.forKind((JavaKind)JavaKind.Int), (Object)dims);
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private final class NewMultiArrayWithExceptionLowering
        implements NodeLoweringProvider<NewMultiArrayWithExceptionNode> {
            private NewMultiArrayWithExceptionLowering() {
            }

            @Override
            public void lower(NewMultiArrayWithExceptionNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage().areFrameStatesAtSideEffects()) {
                    return;
                }
                int rank = node.dimensionCount();
                ValueNode[] dims = new ValueNode[rank];
                for (int i = 0; i < node.dimensionCount(); ++i) {
                    dims[i] = node.dimension(i);
                }
                SharedType type = (SharedType)node.type();
                ConstantNode hubConstant = ConstantNode.forConstant((JavaConstant)Templates.this.snippetReflection.forObject((Object)type.getHub()), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)graph);
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.newmultiarray, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)hubConstant);
                args.add("rank", (Object)rank);
                args.add("withException", (Object)true);
                args.addVarargs("dimensions", Integer.TYPE, StampFactory.forKind((JavaKind)JavaKind.Int), (Object)dims);
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private final class ValidateNewInstanceClassLowering
        implements NodeLoweringProvider<ValidateNewInstanceClassNode> {
            private ValidateNewInstanceClassLowering() {
            }

            @Override
            public void lower(ValidateNewInstanceClassNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.validateNewInstanceClass, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)node.getInstanceType());
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private final class NewStoredContinuationLowering
        implements NodeLoweringProvider<NewStoredContinuationNode> {
            private NewStoredContinuationLowering() {
            }

            @Override
            public void lower(NewStoredContinuationNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage().areFrameStatesAtSideEffects()) {
                    return;
                }
                SharedType instanceClass = (SharedType)node.instanceClass();
                ValueNode length = node.length();
                DynamicHub hub = instanceClass.getHub();
                int layoutEncoding = hub.getLayoutEncoding();
                int arrayBaseOffset = LayoutEncoding.getArrayBaseOffsetAsInt(layoutEncoding);
                int log2ElementSize = LayoutEncoding.getArrayIndexShift(layoutEncoding);
                ConstantNode hubConstant = ConstantNode.forConstant((JavaConstant)Templates.this.snippetReflection.forObject((Object)hub), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)graph);
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.allocateStoredContinuation, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)hubConstant);
                args.add("length", length.isAlive() ? length : graph.addOrUniqueWithInputs((Node)length));
                args.add("forceSlowPath", (Object)Templates.shouldForceSlowPath(graph));
                args.add("arrayBaseOffset", (Object)arrayBaseOffset);
                args.add("log2ElementSize", (Object)log2ElementSize);
                args.add("ipOffset", (Object)ContinuationSupport.singleton().getIPOffset());
                args.add("emitMemoryBarrier", (Object)node.emitMemoryBarrier());
                args.add("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, instanceClass));
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private final class NewPodInstanceLowering
        implements NodeLoweringProvider<NewPodInstanceNode> {
            private NewPodInstanceLowering() {
            }

            @Override
            public void lower(NewPodInstanceNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage().areFrameStatesAtSideEffects()) {
                    return;
                }
                assert (node.getKnownInstanceType() == null || node.getHub().isConstant() && tool.getConstantReflection().asJavaType(node.getHub().asConstant()).equals((Object)node.getKnownInstanceType()));
                assert (node.fillContents()) : "fillContents must be true for hybrid allocations";
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.allocatePod, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("hub", (Object)node.getHub());
                args.add("arrayLength", (Object)node.getArrayLength());
                args.add("forceSlowPath", (Object)Templates.shouldForceSlowPath(graph));
                args.add("referenceMap", (Object)node.getReferenceMap());
                args.add("emitMemoryBarrier", (Object)node.emitMemoryBarrier());
                args.add("maybeUnroll", (Object)node.getArrayLength().isConstant());
                args.add("supportsBulkZeroing", (Object)tool.getLowerer().supportsBulkZeroingOfEden());
                args.add("supportsOptimizedFilling", (Object)tool.getLowerer().supportsOptimizedFilling(graph.getOptions()));
                args.add("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, node.getKnownInstanceType()));
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private final class NewDynamicHubLowering
        implements NodeLoweringProvider<SubstrateNewDynamicHubNode> {
            private NewDynamicHubLowering() {
            }

            @Override
            public void lower(SubstrateNewDynamicHubNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage().areFrameStatesAtSideEffects()) {
                    return;
                }
                assert (node.getVTableEntries() != null);
                assert (node.fillContents()) : "fillContents must be true for DynamicHub allocations";
                ValueNode vTableEntries = node.getVTableEntries();
                SharedType type = (SharedType)tool.getMetaAccess().lookupJavaType(Class.class);
                DynamicHub hubOfDynamicHub = type.getHub();
                int layoutEncoding = hubOfDynamicHub.getLayoutEncoding();
                int vTableBaseOffset = SubstrateAllocationSnippets.getArrayBaseOffset(layoutEncoding);
                assert (vTableBaseOffset == KnownOffsets.singleton().getVTableBaseOffset());
                int log2VTableEntrySize = LayoutEncoding.getArrayIndexShift(layoutEncoding);
                assert (log2VTableEntrySize == NumUtil.unsignedLog2((long)KnownOffsets.singleton().getVTableEntrySize()));
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.allocateDynamicHub, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("vTableEntries", (Object)vTableEntries);
                args.add("vTableBaseOffset", (Object)vTableBaseOffset);
                args.add("log2VTableEntrySize", (Object)log2VTableEntrySize);
                args.add("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, type));
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }
    }
}

