/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub.registry;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.hub.RuntimeClassLoading;
import org.graalvm.nativeimage.impl.ClassLoadingSupport;

@AutomaticallyRegisteredImageSingleton(value={ClassLoadingSupport.class})
public class ClassLoadingSupportImpl
implements ClassLoadingSupport {
    private final ThreadLocal<Integer> ignoreReflectionConfiguration = new ThreadLocal<Integer>(this){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public boolean isSupported() {
        return RuntimeClassLoading.isSupported();
    }

    public boolean followReflectionConfiguration() {
        return this.ignoreReflectionConfiguration.get() == 0;
    }

    public void startIgnoreReflectionConfigurationScope() {
        int previous = this.ignoreReflectionConfiguration.get();
        this.ignoreReflectionConfiguration.set(Math.incrementExact(previous));
    }

    public void endIgnoreReflectionConfigurationScope() {
        int previous = this.ignoreReflectionConfiguration.get();
        if (previous == 0) {
            throw new IllegalStateException("Unbalanced start/end arbitrary classloading allowed scopes");
        }
        assert (previous > 0);
        this.ignoreReflectionConfiguration.set(previous - 1);
    }
}

