/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.image;

import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayoutInfo;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.image.ImageHeapPartition;
import java.nio.ByteBuffer;

public interface ImageHeapLayouter {
    public ImageHeapPartition[] getPartitions();

    public void assignObjectToPartition(ImageHeapObject var1, boolean var2, boolean var3, boolean var4, boolean var5);

    public ImageHeapLayoutInfo layout(ImageHeap var1, int var2, ImageHeapLayouterCallback var3);

    default public void afterLayout(ImageHeap imageHeap) {
    }

    public void writeMetadata(ByteBuffer var1, long var2);

    public static class ImageHeapLayoutCancelledException
    extends RuntimeException {
        private static final long serialVersionUID = 1017980175582546348L;
    }

    public static interface ImageHeapLayouterCallback {
        public static final ImageHeapLayouterCallback NONE = () -> false;

        public boolean shouldCancel();
    }

    public static class ImageHeapLayouterControl {
        protected final ImageHeapLayouterCallback callback;

        public ImageHeapLayouterControl(ImageHeapLayouterCallback callback) {
            this.callback = callback;
        }

        public void poll() throws ImageHeapLayoutCancelledException {
            if (this.callback.shouldCancel()) {
                throw new ImageHeapLayoutCancelledException();
            }
        }
    }
}

