/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import java.util.Optional;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@AutomaticallyRegisteredFeature
public class JavaNetHttpFeature
extends JNIRegistrationUtil
implements InternalFeature {
    private static Optional<Module> requiredModule() {
        return ModuleLayer.boot().findModule("java.net.http");
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return JavaNetHttpFeature.requiredModule().isPresent();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        JavaNetHttpFeature.class.getModule().addReads(JavaNetHttpFeature.requiredModule().get());
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        RuntimeClassInitializationSupport rci = (RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
        rci.initializeAtRunTime("jdk.internal.net.http", "for reading properties at run time");
        rci.initializeAtRunTime("jdk.internal.net.http.websocket.OpeningHandshake", "contains a SecureRandom reference");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerReachabilityHandler(JavaNetHttpFeature::registerInitFiltersAccess, new Object[]{JavaNetHttpFeature.method((Feature.FeatureAccess)access, "jdk.internal.net.http.HttpClientImpl", "initFilters", new Class[0])});
    }

    private static void registerInitFiltersAccess(Feature.DuringAnalysisAccess a) {
        RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{JavaNetHttpFeature.clazz((Feature.FeatureAccess)a, "jdk.internal.net.http.AuthenticationFilter")});
        RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{JavaNetHttpFeature.clazz((Feature.FeatureAccess)a, "jdk.internal.net.http.RedirectFilter")});
        RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{JavaNetHttpFeature.clazz((Feature.FeatureAccess)a, "jdk.internal.net.http.CookieFilter")});
    }
}

