/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmti;

import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.jvmti.headers.JvmtiEventCallbacks;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;

public final class JvmtiEventCallbacksUtil {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JvmtiEventCallbacksUtil() {
    }

    public static void setEventCallbacks(JvmtiEventCallbacks envEventCallbacks, JvmtiEventCallbacks newCallbacks, int sizeOfCallbacks) {
        int internalStructSize = SizeOf.get(JvmtiEventCallbacks.class);
        UnmanagedMemoryUtil.fill((Pointer)envEventCallbacks, Word.unsigned((int)internalStructSize), (byte)0);
        if (newCallbacks.isNonNull()) {
            int bytesToCopy = UninterruptibleUtils.Math.min(internalStructSize, sizeOfCallbacks);
            UnmanagedMemoryUtil.copy((Pointer)newCallbacks, (Pointer)envEventCallbacks, Word.unsigned((int)bytesToCopy));
        }
    }
}

