/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.locks;

import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.locks.ClassInstanceReplacer;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.ImageHeapList;
import java.util.Comparator;
import java.util.List;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordBase;

public abstract class VMLockSupport {
    protected final List<VMMutex> mutexes = ImageHeapList.create(VMMutex.class, Comparator.comparing(VMMutex::getName));
    protected final List<VMCondition> conditions = ImageHeapList.create(VMCondition.class, Comparator.comparing(VMCondition::getName));
    protected final List<VMSemaphore> semaphores = ImageHeapList.create(VMSemaphore.class, Comparator.comparing(VMSemaphore::getName));
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected ClassInstanceReplacer<VMMutex, VMMutex> mutexReplacer;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected ClassInstanceReplacer<VMCondition, VMCondition> conditionReplacer;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected ClassInstanceReplacer<VMSemaphore, VMSemaphore> semaphoreReplacer;

    @Fold
    public static VMLockSupport singleton() {
        return (VMLockSupport)ImageSingletons.lookup(VMLockSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected abstract VMMutex replaceVMMutex(VMMutex var1);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected abstract VMCondition replaceVMCondition(VMCondition var1);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected abstract VMSemaphore replaceSemaphore(VMSemaphore var1);

    @Uninterruptible(reason="Too early for safepoints.")
    public final boolean initialize() {
        int i;
        for (i = 0; i < this.mutexes.size(); ++i) {
            if (this.mutexes.get(i).initialize() == 0) continue;
            return false;
        }
        for (i = 0; i < this.conditions.size(); ++i) {
            if (this.conditions.get(i).initialize() == 0) continue;
            return false;
        }
        for (i = 0; i < this.semaphores.size(); ++i) {
            if (this.semaphores.get(i).initialize() == 0) continue;
            return false;
        }
        return true;
    }

    @Uninterruptible(reason="The isolate teardown is in progress.")
    public final boolean destroy() {
        int i;
        for (i = 0; i < this.semaphores.size(); ++i) {
            if (this.semaphores.get(i).destroy() == 0) continue;
            return false;
        }
        for (i = 0; i < this.conditions.size(); ++i) {
            if (this.conditions.get(i).destroy() == 0) continue;
            return false;
        }
        for (i = 0; i < this.mutexes.size(); ++i) {
            if (this.mutexes.get(i).destroy() == 0) continue;
            return false;
        }
        return true;
    }

    public static class DumpVMMutexes
    extends SubstrateDiagnostics.DiagnosticThunk {
        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, SubstrateDiagnostics.ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            log.string("VM mutexes:").indent(true);
            VMLockSupport support = null;
            if (ImageSingletons.contains(VMLockSupport.class)) {
                support = (VMLockSupport)ImageSingletons.lookup(VMLockSupport.class);
            }
            if (support == null || support.mutexes == null) {
                log.string("No mutex information is available.").newline();
            } else {
                for (int i = 0; i < support.mutexes.size(); ++i) {
                    VMMutex mutex = support.mutexes.get(i);
                    IsolateThread owner = mutex.owner;
                    log.string("mutex \"").string(mutex.getName()).string("\" ");
                    if (owner.isNull()) {
                        log.string("is unlocked.");
                    } else {
                        log.string("is locked by ");
                        if (owner.equal((ComparableWord)VMMutex.UNSPECIFIED_OWNER)) {
                            log.string("an unspecified thread.");
                        } else {
                            log.string("thread ").zhex((WordBase)owner);
                        }
                    }
                    log.newline();
                }
            }
            log.indent(false);
        }
    }
}

