/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.monitor;

import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.monitor.MultiThreadedMonitorSupport;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.MembarNode;
import jdk.graal.compiler.nodes.java.AccessMonitorNode;
import jdk.graal.compiler.nodes.java.MonitorEnterNode;
import jdk.graal.compiler.nodes.java.MonitorExitNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.word.LocationIdentity;

public class MonitorSnippets
extends SubstrateTemplates
implements Snippets {
    protected static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_PATH_MONITOR_ENTER = SnippetRuntime.findForeignCall(MultiThreadedMonitorSupport.class, "slowPathMonitorEnter", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    protected static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_PATH_MONITOR_EXIT = SnippetRuntime.findForeignCall(MultiThreadedMonitorSupport.class, "slowPathMonitorExit", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    protected static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{SLOW_PATH_MONITOR_ENTER, SLOW_PATH_MONITOR_EXIT};
    private final SnippetTemplate.SnippetInfo monitorEnter;
    private final SnippetTemplate.SnippetInfo monitorExit;

    @Snippet
    protected static void monitorEnterSnippet(Object obj) {
        MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.NONE, (LocationIdentity)LocationIdentity.any());
        MonitorSnippets.callSlowPath(SLOW_PATH_MONITOR_ENTER, obj);
    }

    @Snippet
    protected static void monitorExitSnippet(Object obj) {
        MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.NONE, (LocationIdentity)LocationIdentity.any());
        MonitorSnippets.callSlowPath(SLOW_PATH_MONITOR_EXIT, obj);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    protected static native void callSlowPath(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    protected MonitorSnippets(OptionValues options, Providers providers) {
        super(options, providers);
        this.monitorEnter = this.snippet(providers, MonitorSnippets.class, "monitorEnterSnippet", new LocationIdentity[0]);
        this.monitorExit = this.snippet(providers, MonitorSnippets.class, "monitorExitSnippet", new LocationIdentity[0]);
    }

    protected void registerLowerings(Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        MonitorLowering lowering = new MonitorLowering();
        lowerings.put(MonitorEnterNode.class, lowering);
        lowerings.put(MonitorExitNode.class, lowering);
    }

    protected class MonitorLowering
    implements NodeLoweringProvider<AccessMonitorNode> {
        protected MonitorLowering() {
        }

        @Override
        public final void lower(AccessMonitorNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.LOW_TIER) {
                assert (StampTool.isPointerNonNull((ValueNode)node.object())) : "null check is inserted by high-tier lowering";
                this.lowerLowTier(node, tool);
            } else {
                this.lowerHighTier(node, tool);
            }
        }

        protected void lowerHighTier(AccessMonitorNode node, LoweringTool tool) {
            ValueNode object = node.object();
            if (!StampTool.isPointerNonNull((ValueNode)object)) {
                GuardingNode nullCheck = tool.createGuard((FixedNode)node, (LogicNode)node.graph().unique((Node)IsNullNode.create((ValueNode)object)), DeoptimizationReason.NullCheckException, DeoptimizationAction.InvalidateReprofile, SpeculationLog.NO_SPECULATION, true, null);
                node.setObject((ValueNode)node.graph().addOrUnique((Node)PiNode.create((ValueNode)object, (Stamp)StampFactory.objectNonNull(), (ValueNode)((ValueNode)nullCheck))));
            }
        }

        protected void lowerLowTier(AccessMonitorNode node, LoweringTool tool) {
            SnippetTemplate.SnippetInfo snippet;
            if (node instanceof MonitorEnterNode) {
                snippet = MonitorSnippets.this.monitorEnter;
            } else if (node instanceof MonitorExitNode) {
                snippet = MonitorSnippets.this.monitorExit;
            } else {
                throw VMError.shouldNotReachHereUnexpectedInput(node);
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("obj", (Object)node.object());
            MonitorSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

