/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.option.URIOptionOrigin;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.core.common.SuppressFBWarnings;

final class JarOptionOrigin
extends URIOptionOrigin {
    protected JarOptionOrigin(boolean isStable, URI rawOrigin) {
        super(isStable);
        String specific = rawOrigin.getSchemeSpecificPart();
        int sep = specific.lastIndexOf(33);
        VMError.guarantee(sep > 0, "Invalid jar origin");
        String origin = specific.substring(0, sep);
        this.container = URIOptionOrigin.originURI(origin);
        this.location = Path.of(specific.substring(sep + 2), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="location()).getParent() is never null")
    public List<String> getRedirectionValues(Path valuesFile) throws IOException {
        FileSystem probeJarFS;
        URI jarFileURI = URI.create("jar:" + String.valueOf(this.container()));
        boolean cleanup = false;
        try {
            probeJarFS = FileSystems.getFileSystem(jarFileURI);
        }
        catch (FileSystemNotFoundException e) {
            probeJarFS = FileSystems.newFileSystem(jarFileURI, Map.of());
            cleanup = true;
        }
        if (probeJarFS == null) {
            throw new IOException("Unable to create jar file system for " + String.valueOf(jarFileURI));
        }
        try {
            List<String> values;
            Path normalizedRedirPath = this.location().getParent().resolve(valuesFile).normalize();
            List<String> list = values = JarOptionOrigin.getRedirectionValuesFromPath(probeJarFS.getPath("/", normalizedRedirPath.toString()));
            return list;
        }
        finally {
            if (cleanup) {
                probeJarFS.close();
            }
        }
    }
}

