/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.DynamicMethodAddressResolutionHeapSupport;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.os.ImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public abstract class AbstractImageHeapProvider
implements ImageHeapProvider {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected UnsignedWord getTotalRequiredAddressSpaceSize() {
        UnsignedWord size = this.getImageHeapAddressSpaceSize();
        if (DynamicMethodAddressResolutionHeapSupport.isEnabled()) {
            size = size.add(AbstractImageHeapProvider.getPreHeapAlignedSizeForDynamicMethodAddressResolver());
        }
        return size;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getImageHeapAddressSpaceSize() {
        UnsignedWord pageSize = VirtualMemoryProvider.get().getGranularity();
        int imageHeapOffset = Heap.getHeap().getImageHeapOffsetInAddressSpace();
        assert (imageHeapOffset >= 0);
        UnsignedWord size = Word.unsigned((int)imageHeapOffset);
        size = size.add(AbstractImageHeapProvider.getImageHeapSizeInFile());
        size = UnsignedUtils.roundUp(size, pageSize);
        return size;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static UnsignedWord getImageHeapSizeInFile(Word beginAddress, Word endAddress) {
        assert (endAddress.aboveOrEqual(endAddress));
        return endAddress.subtract(beginAddress);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getImageHeapSizeInFile() {
        return AbstractImageHeapProvider.getImageHeapSizeInFile(Isolates.IMAGE_HEAP_BEGIN.get(), Isolates.IMAGE_HEAP_END.get());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static Pointer getImageHeapBegin(Pointer heapBase) {
        return heapBase.add(Heap.getHeap().getImageHeapOffsetInAddressSpace());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static UnsignedWord getPreHeapAlignedSizeForDynamicMethodAddressResolver() {
        UnsignedWord requiredPreHeapMemoryInBytes = DynamicMethodAddressResolutionHeapSupport.get().getRequiredPreHeapMemoryInBytes();
        UnsignedWord heapAlignment = Word.unsigned((int)Heap.getHeap().getPreferredAddressSpaceAlignment());
        return PointerUtils.roundUp((PointerBase)requiredPreHeapMemoryInBytes, heapAlignment);
    }
}

