/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.attach;

import com.oracle.svm.core.attach.AttachListenerThread;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.attach.AttachHelper;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.BasedOnJDKFile;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;

public final class PosixAttachListenerThread
extends AttachListenerThread {
    private final int listener;

    public PosixAttachListenerThread(int listener) {
        this.listener = listener;
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/os/posix/attachListener_posix.cpp#L256-L313")
    protected AttachListenerThread.AttachOperation dequeue() {
        AttachListenerThread.AttachOperation op;
        while (true) {
            int socket;
            if ((socket = AttachHelper.waitForRequest(this.listener)) == -1) {
                return null;
            }
            PosixAttachSocketChannel channel = new PosixAttachSocketChannel(socket);
            op = PosixAttachListenerThread.readRequest(channel);
            if (op != null) break;
            channel.close();
        }
        return op;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/os/posix/attachListener_posix.cpp#L102-L139")
    private static class PosixAttachSocketChannel
    extends AttachListenerThread.AttachSocketChannel {
        private int socket;

        PosixAttachSocketChannel(int socket) {
            this.socket = socket;
        }

        @Override
        public int read(PointerBase buffer, int size) {
            return PosixUtils.readUninterruptibly(this.socket, (Pointer)buffer, size, 0);
        }

        @Override
        protected void write(byte[] data) {
            PosixUtils.writeUninterruptibly(this.socket, data);
        }

        protected boolean isOpen() {
            return this.socket != -1;
        }

        @Override
        public void close() {
            if (this.isOpen()) {
                AttachHelper.shutdownSocket(this.socket);
                Unistd.NoTransitions.close(this.socket);
                this.socket = -1;
            }
        }
    }
}

