/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.thread.RecurringCallbackSupport;
import java.util.concurrent.TimeUnit;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Threading;
import org.graalvm.nativeimage.impl.ThreadingSupport;

@AutomaticallyRegisteredImageSingleton(value={ThreadingSupport.class})
public class ThreadingSupportImpl
implements ThreadingSupport {
    private static final String ENABLE_SUPPORT_OPTION = SubstrateOptionsParser.commandArgument(RecurringCallbackSupport.ConcealedOptions.SupportRecurringCallback, "+");

    public void registerRecurringCallback(long interval, TimeUnit unit, Threading.RecurringCallback callback) {
        IsolateThread thread = CurrentIsolate.getCurrentThread();
        if (callback != null) {
            if (!RecurringCallbackSupport.isEnabled()) {
                throw new UnsupportedOperationException("Recurring callbacks must be enabled during image build with option " + ENABLE_SUPPORT_OPTION);
            }
            long intervalNanos = unit.toNanos(interval);
            if (intervalNanos < 1L) {
                throw new IllegalArgumentException("The intervalNanos field is less than one.");
            }
            RecurringCallbackSupport.RecurringCallbackTimer callbackTimer = RecurringCallbackSupport.createCallbackTimer(intervalNanos, callback);
            RecurringCallbackSupport.installCallback(thread, callbackTimer, true);
        } else if (RecurringCallbackSupport.isEnabled()) {
            RecurringCallbackSupport.uninstallCallback(thread);
        }
    }

    @Fold
    public static boolean isRecurringCallbackSupported() {
        return RecurringCallbackSupport.isEnabled();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void pauseRecurringCallback(String reason) {
        RecurringCallbackSupport.suspendCallbackTimer(reason);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void resumeRecurringCallbackAtNextSafepoint() {
        RecurringCallbackSupport.resumeCallbackTimerAtNextSafepointCheck();
    }
}

